/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLTemplate {
    private final List<Term> terms = new ArrayList<Term>();
    private List<Parameter> parameters = null;
    private List<Pattern> inclusionPatternList = null;
    private List<Pattern> exclusionPatternList = null;

    public URLTemplate(String template) {
        this.initializeFromTemplate(template);
    }

    public void addExclusionPattern(String pattern) throws PatternSyntaxException {
        this.getExclusionPatternList().add(Pattern.compile(pattern));
    }

    public void addInclusionPattern(String pattern) throws PatternSyntaxException {
        this.getInclusionPatternList().add(Pattern.compile(pattern));
    }

    public void generatePath(StringBuilder result, Map<String, Object> properties, Map<String, String[]> params) {
        for (Term term : this.terms) {
            if (term.isReplaceable()) {
                String replacement = this.getReplacement(term.getValue(), properties, params);
                if (replacement == null) continue;
                result.append(replacement);
                continue;
            }
            result.append(term.getValue());
        }
    }

    public void generateQueryString(StringBuilder sb, Map<String, Object> properties, Map<String, String[]> params) {
        int delim = 63;
        StringBuilder sbNVP = new StringBuilder();
        if (this.hasTemplateParameters()) {
            for (Parameter parameter : this.getTemplateParametersList()) {
                sbNVP.setLength(0);
                parameter.render(sbNVP, properties, params);
                if (sbNVP.length() <= 0) continue;
                sb.append((char)delim).append((CharSequence)sbNVP);
                delim = 38;
            }
        }
        if (this.hasInclusionPatterns()) {
            for (Map.Entry entry : params.entrySet()) {
                Matcher matcher;
                String name = (String)entry.getKey();
                boolean include = false;
                for (Pattern pattern : this.getInclusionPatternList()) {
                    matcher = pattern.matcher(name);
                    if (!matcher.matches()) continue;
                    include = true;
                    break;
                }
                if (include && this.hasExclusionPatterns()) {
                    for (Pattern pattern : this.getExclusionPatternList()) {
                        matcher = pattern.matcher(name);
                        if (!matcher.matches()) continue;
                        include = false;
                        break;
                    }
                }
                if (!include) continue;
                sbNVP.setLength(0);
                String[] stringArray = (String[])entry.getValue();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    sb.append((char)delim).append(name).append('=').append(URLTemplate.urlEncode(value));
                    delim = 38;
                    ++n2;
                }
            }
        }
    }

    public String generateURL(Map<String, Object> properties, Map<String, String[]> params) {
        StringBuilder result = new StringBuilder();
        this.generateURL(result, properties, params);
        return result.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.terms != null) {
            for (Term term : this.terms) {
                sb.append(term);
            }
        }
        sb.append('?');
        boolean sep = false;
        if (this.parameters != null) {
            for (Parameter param : this.parameters) {
                if (sep) {
                    sb.append('&');
                }
                sb.append(param.toString());
                sep = true;
            }
        }
        sb.append(" (parameter inclusions:");
        if (this.inclusionPatternList != null) {
            for (Pattern inclusionPattern : this.inclusionPatternList) {
                sb.append(' ').append(inclusionPattern.toString());
            }
        }
        sb.append(") (parameter exclusions:");
        if (this.exclusionPatternList != null) {
            for (Pattern exclusionPattern : this.exclusionPatternList) {
                sb.append(' ').append(exclusionPattern.toString());
            }
        }
        sb.append(')');
        return sb.toString();
    }

    String getReplacement(String key, Map<String, Object> properties, Map<String, String[]> params) {
        Object o;
        String[] values;
        String replacement = null;
        if (params != null && (values = params.get(key)) != null) {
            String string = replacement = values.length > 0 ? values[0] : "";
        }
        if (replacement == null && properties != null && (o = properties.get(key)) != null) {
            replacement = o.toString();
        }
        return replacement;
    }

    private void generateURL(StringBuilder result, Map<String, Object> properties, Map<String, String[]> params) {
        this.generatePath(result, properties, params);
        this.generateQueryString(result, properties, params);
    }

    private List<Pattern> getExclusionPatternList() {
        if (this.exclusionPatternList == null) {
            this.exclusionPatternList = new ArrayList<Pattern>();
        }
        return this.exclusionPatternList;
    }

    private List<Pattern> getInclusionPatternList() {
        if (this.inclusionPatternList == null) {
            this.inclusionPatternList = new ArrayList<Pattern>();
        }
        return this.inclusionPatternList;
    }

    private List<Parameter> getTemplateParametersList() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    private boolean hasExclusionPatterns() {
        return this.exclusionPatternList != null && this.exclusionPatternList.size() > 0;
    }

    private boolean hasInclusionPatterns() {
        return this.inclusionPatternList != null && this.inclusionPatternList.size() > 0;
    }

    private boolean hasTemplateParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    private void initializeFromTemplate(String template) {
        int q = template.indexOf(63);
        if (q == -1) {
            URLTemplate.parseTerms(this.terms, template);
        } else {
            URLTemplate.parseTerms(this.terms, template.substring(0, q));
            this.initializeParameters(template.substring(q + 1));
        }
    }

    private void initializeParameters(String qsTemplate) {
        StringTokenizer parser = new StringTokenizer(qsTemplate, "&", false);
        while (parser.hasMoreTokens()) {
            String nvp = parser.nextToken();
            int sep = nvp.indexOf(61);
            Parameter param = nvp.indexOf(123) > sep ? new ParameterTemplate(nvp.substring(0, sep), nvp.substring(sep + 1)) : new ParameterLiteral(nvp.substring(0, sep), nvp.substring(sep + 1));
            this.getTemplateParametersList().add(param);
        }
    }

    static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return value;
        }
    }

    private static void parseTerms(List<Term> terms, String template) {
        StringTokenizer parser = new StringTokenizer(template, "{}", true);
        while (parser.hasMoreTokens()) {
            Term term;
            String token = parser.nextToken();
            if ("{".equals(token)) {
                String keyToken = parser.nextToken();
                if (keyToken.charAt(0) == '?') {
                    keyToken = keyToken.substring(1);
                    term = new Term(keyToken, true, true);
                } else {
                    term = new Term(keyToken, true);
                }
                parser.nextToken();
            } else {
                term = new Term(token);
            }
            terms.add(term);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Parameter {
        public void render(StringBuilder var1, Map<String, Object> var2, Map<String, String[]> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterLiteral
    implements Parameter {
        protected final String name;
        protected final String value;

        public ParameterLiteral(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void render(StringBuilder sb, Map<String, Object> properties, Map<String, String[]> params) {
            sb.append(this.name).append('=').append(this.value);
        }

        public String toString() {
            return String.valueOf(this.name) + '=' + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterTemplate
    implements Parameter {
        private final String name;
        private final List<Term> terms = new ArrayList<Term>();

        public ParameterTemplate(String name, String value) {
            this.name = name;
            URLTemplate.parseTerms(this.terms, value);
        }

        @Override
        public void render(StringBuilder sb, Map<String, Object> properties, Map<String, String[]> params) {
            StringBuilder buf = new StringBuilder(this.name).append('=');
            boolean optional = true;
            for (Term term : this.terms) {
                if (term.isReplaceable()) {
                    optional &= term.isOptional();
                    String replacement = URLTemplate.this.getReplacement(term.getValue(), properties, params);
                    if (replacement == null) continue;
                    sb.append((CharSequence)buf);
                    buf = new StringBuilder();
                    buf.append(URLTemplate.urlEncode(replacement));
                    optional = false;
                    continue;
                }
                buf.append(term.getValue());
            }
            if (!optional) {
                sb.append((CharSequence)buf);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append('=');
            if (this.terms != null) {
                for (Term term : this.terms) {
                    sb.append(term);
                }
            }
            return sb.toString();
        }
    }

    static class Term {
        private final String value;
        private final boolean replaceable;
        private final boolean optional;

        public Term(String value) {
            this(value, false, false);
        }

        public Term(String value, boolean replaceable) {
            this(value, replaceable, false);
        }

        public Term(String value, boolean replaceable, boolean optional) {
            this.value = value;
            this.replaceable = replaceable;
            this.optional = optional;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isReplaceable() {
            return this.replaceable;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            if (this.replaceable) {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                if (this.optional) {
                    sb.append('?');
                }
                sb.append(this.value).append('}');
                return sb.toString();
            }
            return this.value;
        }
    }
}

