/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.i18n;

import com.ibm.cognos.bux.config.BiBusConfigurationManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LocaleUtils {
    public static final Map<String, String> BI_SPECIAL_CONTENT_LOCALE_MAPPING = new HashMap<String, String>(2);

    static {
        BI_SPECIAL_CONTENT_LOCALE_MAPPING.put("iw", "he");
        BI_SPECIAL_CONTENT_LOCALE_MAPPING.put("in", "id");
    }

    private LocaleUtils() {
    }

    private static String getBINormalizedLocale(String locale) {
        String result = BI_SPECIAL_CONTENT_LOCALE_MAPPING.get(locale.substring(0, 2));
        if (result != null) {
            return result + locale.substring(2);
        }
        return locale;
    }

    public static Locale getServerLocale() {
        Locale locale = null;
        try {
            locale = LocaleUtils.toLocale(BiBusConfigurationManager.getInstance().getValue("serverLocale", true));
        }
        catch (Exception exception) {
            locale = null;
        }
        return locale == null ? LocaleUtils.toLocale(System.getProperty("user.language")) : locale;
    }

    public static Locale toLocale(String locale) {
        if (locale == null) {
            return null;
        }
        String _locale = locale.trim();
        if (_locale.length() == 0) {
            return null;
        }
        int idx = _locale.indexOf(45);
        if (idx != -1) {
            return new Locale(_locale.substring(0, idx).toLowerCase(), _locale.substring(idx + 1).toUpperCase());
        }
        return new Locale(_locale.toLowerCase(), "");
    }

    public static String toNormalizedString(Locale locale) {
        String result = null;
        if (locale == null) {
            return null;
        }
        String country = locale.getCountry();
        result = country.length() == 0 ? locale.getLanguage() : locale.getLanguage() + '-' + country.toLowerCase();
        return LocaleUtils.getBINormalizedLocale(result);
    }

    public static String toNormalizedString(String locale) {
        if (locale == null) {
            return null;
        }
        String _locale = locale.trim();
        if (_locale.length() == 0) {
            return null;
        }
        if ((_locale = _locale.replace('_', '-').toLowerCase()).length() > 5) {
            _locale = _locale.substring(0, 5);
        }
        return LocaleUtils.getBINormalizedLocale(_locale);
    }
}

