/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.i18n;

import com.ibm.cognos.bux.i18n.BUXMessages;
import com.ibm.cognos.bux.i18n.LocaleUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalizationManager {
    private final transient Map<String, BUXMessages> msgs = new HashMap<String, BUXMessages>();
    private static LocalizationManager instance = null;

    protected LocalizationManager() {
    }

    public static LocalizationManager getInstance() {
        if (instance == null) {
            instance = new LocalizationManager();
        }
        return instance;
    }

    public BUXMessages getMessages(String messageFile, Locale locale, ClassLoader classLoader) {
        String key = LocalizationManager.buildKey(messageFile, LocaleUtils.toNormalizedString(locale));
        BUXMessages messages = this.msgs.get(key);
        if (messages == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(messageFile, locale, classLoader);
            messages = new BUXMessages(resourceBundle);
            this.msgs.put(key, messages);
        }
        return messages;
    }

    private static String buildKey(String messageFile, String locale) {
        return messageFile + '_' + locale;
    }

    public Map<String, BUXMessages> getMsgs() {
        return this.msgs;
    }
}

