/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.logging;

import com.ibm.cognos.bux.logging.BUXAuditLogger;
import com.ibm.cognos.bux.logging.BUXLogAuditLevel;
import com.ibm.cognos.bux.logging.BUXLogBaseDetails;
import com.ibm.cognos.bux.logging.BUXLogDetails;
import com.ibm.cognos.bux.logging.IAuditLoggerFactory;

public class BUXAuditLoggerFactory {
    private static IAuditLoggerFactory theInstance = null;
    private static NoopAuditLogger theNoopLogger = null;
    private static BUXAuditLoggerFactory afactory = new BUXAuditLoggerFactory();

    static {
        theNoopLogger = afactory.new NoopAuditLogger();
    }

    public static BUXAuditLogger getAuditLogger(String name) {
        IAuditLoggerFactory factory = BUXAuditLoggerFactory.getLoggerFactory();
        if (factory != null) {
            return factory.getAuditLogger(name);
        }
        return theNoopLogger;
    }

    public static BUXAuditLogger getAuditLogger() {
        BUXAuditLogger alogger;
        IAuditLoggerFactory factory = BUXAuditLoggerFactory.getLoggerFactory();
        if (factory != null && (alogger = factory.getAuditLogger("")) != null) {
            return alogger;
        }
        return theNoopLogger;
    }

    public static synchronized IAuditLoggerFactory getLoggerFactory() {
        return theInstance;
    }

    public static synchronized IAuditLoggerFactory setLoggerFactory(IAuditLoggerFactory factory) {
        IAuditLoggerFactory prevInstance = theInstance;
        theInstance = factory;
        return prevInstance;
    }

    protected class NoopAuditLogger
    implements BUXAuditLogger {
        protected NoopAuditLogger() {
        }

        public void auditLogDetailed(BUXLogBaseDetails data, String functionName, String functionReturnValue, Object requestContextParameters) {
        }

        public void auditLogRequestLevelEvent(BUXLogDetails data, Object requestContextParameters) {
        }

        public void auditLogSystemEvent(BUXLogDetails data, Object requestContextParameters) {
        }

        public boolean isAuditLoggingEnabled(BUXLogAuditLevel loggingLevel) {
            return false;
        }

        public void auditLogException(BUXLogDetails data, Throwable exception, String logMessage, Object requestContextParameters) {
        }

        public void auditLogException(BUXLogDetails data, Throwable exception, Object requestContextParameters) {
        }
    }
}

