/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.logging;

import com.ibm.cognos.bux.logging.BUXLogBaseDetails;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BUXLogDetails
extends BUXLogBaseDetails {
    private static final String EXCEPTION_HEADER = "<BUXEXCEPTION>";
    private static final String EXCEPTION_TAILER = "</BUXEXCEPTION>";
    private static final String EXCEPTION_MSG_HEADER = "<ERRMESSAGE>";
    private static final String EXCEPTION_MSG_TAILER = "</ERRMESSAGE>";
    private static final String EXCETPION_ST_HEADER = "<STACKTRACE>";
    private static final String EXCETPION_ST_TAILER = "</STACKTRACE>";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private String objectType;
    private String status;
    private ArrayList<String> errorMessages;
    private String objectPath;
    private Throwable exception;

    public Throwable getException() {
        return this.exception;
    }

    public BUXLogDetails() {
        this.operation = BUXLogBaseDetails.Operation.BUX_REQUEST;
        this.objectType = "";
        this.status = "";
        this.logDataParameters = null;
        this.errorMessages = null;
        this.objectPath = "";
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String theObjectType) {
        this.objectType = theObjectType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String theStatus) {
        this.status = theStatus;
    }

    public ArrayList<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void addErrorMessage(String message) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList();
        }
        this.errorMessages.add(message);
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public void setObjectPath(String theObjectPath) {
        this.objectPath = theObjectPath;
    }

    public void setException(Throwable e) {
        this.exception = e;
        if (e != null) {
            if (this.logDataParameters == null) {
                this.logDataParameters = new HashMap();
            }
            this.logDataParameters.put("ERROR", BUXLogDetails.getExceptionAsString(e));
        }
    }

    public static String getExceptionAsString(Throwable e) {
        if (e != null) {
            StringBuffer sb = new StringBuffer(EXCEPTION_HEADER);
            sb.append(NEW_LINE).append(EXCEPTION_MSG_HEADER).append(e.getClass().getName());
            String errMsg = e.getLocalizedMessage();
            if (errMsg != null) {
                sb.append(":").append(errMsg);
            }
            sb.append(EXCEPTION_MSG_TAILER).append(NEW_LINE);
            sb.append(EXCETPION_ST_HEADER).append(NEW_LINE);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            sb.append(sw.toString());
            sb.append(NEW_LINE).append(EXCETPION_ST_TAILER);
            sb.append(NEW_LINE).append(EXCEPTION_TAILER);
            return sb.toString();
        }
        return null;
    }
}

