/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.logging;

import com.ibm.cognos.bux.logging.BUXClassLogger;
import com.ibm.cognos.bux.logging.BUXTraceLogger;
import com.ibm.cognos.bux.logging.BUXZipiTraceLogger;
import com.ibm.cognos.bux.logging.IClassLogger;
import com.ibm.cognos.bux.logging.ILoggerFactory;
import org.apache.commons.httpclient.HttpMethodBase;

public class BUXLoggerFactory {
    private static ILoggerFactory theInstance = null;
    private static NoopLogger theNoopLogger = null;
    private static NoopZipiLogger theNoopZipiLogger = null;
    private static NoopClassLogger theNoopClassLogger = null;
    private static BUXLoggerFactory afactory = new BUXLoggerFactory();

    static {
        theNoopLogger = afactory.new NoopLogger();
        theNoopZipiLogger = afactory.new NoopZipiLogger();
        theNoopClassLogger = afactory.new NoopClassLogger();
    }

    public static BUXTraceLogger getLogger(String name) {
        BUXTraceLogger alogger;
        ILoggerFactory factory = BUXLoggerFactory.getLoggerFactory();
        if (factory != null && (alogger = factory.getLogger(name)) != null) {
            return alogger;
        }
        return theNoopLogger;
    }

    public static BUXZipiTraceLogger getZipiLogger() {
        BUXZipiTraceLogger alogger;
        ILoggerFactory factory = BUXLoggerFactory.getLoggerFactory();
        if (factory != null && (alogger = factory.getZipiLogger()) != null) {
            return alogger;
        }
        return theNoopZipiLogger;
    }

    public static IClassLogger getClassLogger(Class clazz) {
        BUXTraceLogger coreLogger;
        ILoggerFactory factory = BUXLoggerFactory.getLoggerFactory();
        if (factory != null && clazz != null && (coreLogger = factory.getLogger(clazz.getPackage().getName())) != null) {
            String className = clazz.getName();
            if (className.lastIndexOf(46) > 0) {
                className = className.substring(className.lastIndexOf(46) + 1);
            }
            return new BUXClassLogger(coreLogger, className);
        }
        return theNoopClassLogger;
    }

    public static synchronized ILoggerFactory getLoggerFactory() {
        return theInstance;
    }

    public static synchronized ILoggerFactory setLoggerFactory(ILoggerFactory factory) {
        ILoggerFactory prevInstance = theInstance;
        theInstance = factory;
        return prevInstance;
    }

    protected class NoopClassLogger
    implements IClassLogger {
        protected NoopClassLogger() {
        }

        public void debug(String message, Object requestContextParameters) {
        }

        public void enter(String method, Object requestContextParameters) {
        }

        public void error(String message, Object requestContextParameters) {
        }

        public void error(String message, Throwable cause, Object requestContextParameters) {
        }

        public void exit(String method, Object requestContextParameters) {
        }

        public void fatal(String message, Object requestContextParameters) {
        }

        public void fatal(String message, Throwable cause, Object requestContextParameters) {
        }

        public void info(String message, Object requestContextParameters) {
        }

        public void warn(String message, Object requestContextParameters) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public boolean isFatalEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }
    }

    protected class NoopLogger
    implements BUXTraceLogger {
        protected NoopLogger() {
        }

        public void debug(String objectClassName, String message, Object requestContextParameters) {
        }

        public void enter(String objectClassName, String method, Object requestContextParameters) {
        }

        public void error(String objectClassName, String message, Object requestContextParameters) {
        }

        public void error(String objectClassName, String message, Throwable cause, Object requestContextParameters) {
        }

        public void exit(String objectClassName, String method, Object requestContextParameters) {
        }

        public void fatal(String objectClassName, String message, Object requestContextParameters) {
        }

        public void fatal(String objectClassName, String message, Throwable cause, Object requestContextParameters) {
        }

        public void info(String objectClassName, String message, Object requestContextParameters) {
        }

        public void warn(String objectClassName, String message, Object requestContextParameters) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public boolean isFatalEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }
    }

    protected class NoopZipiLogger
    implements BUXZipiTraceLogger {
        protected NoopZipiLogger() {
        }

        public Object handleHttpRequest(HttpMethodBase method) {
            return null;
        }

        public void handleHttpResponse(Object timer, HttpMethodBase method) {
        }

        public Object createThreadRequestAdapter() {
            return null;
        }

        public Object startTimer(Object threadAdapter) {
            return null;
        }

        public void stopTimer(Object timer) {
        }

        public void setObjectPath(Object timer, String path) {
        }

        public void setAction(Object timer, String action) {
        }

        public Object startTimer_action(String sAction) {
            return null;
        }

        public void createMarker(String gesture, String action, String path) {
        }

        public void stopAndClearTimer(Object timer) {
        }
    }
}

