/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.viewer.widget.processor;

import com.ibm.cognos.bux.service.atom.widget.processor.intf.AtomWidgetProcessor;
import com.ibm.cognos.bux.service.atom.widget.processor.intf.DashboardEntryHelper;
import com.ibm.cognos.bux.service.atom.widget.processor.intf.FrameworkContext;
import com.ibm.cognos.bux.service.atom.widget.processor.util.LocalPlatformServices;
import com.ibm.cognos.bux.service.atom.widget.processor.util.PlatformServicesTrackerCustomizer;
import com.ibm.cognos.bux.utils.EncodingUtils;
import com.ibm.cognos.bux.utils.xml.dom.DomUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerWidgetProcessor
implements AtomWidgetProcessor {
    private static final String CONTAINER = "container";
    private static final String VIEWER_I_WIDGET_DEBUG_XML = "ViewerIWidget.debug.xml";
    private static final String X_NODE_ID = "X-Node-ID";
    private static final String VIEWER_I_WIDGET_XML = "ViewerIWidget.xml";
    private static final String URL = "url";
    private static final String ID = "id";
    private static final String VALUE = "value";
    private static final String ITEM = "item";
    private static final String CV_OUTPUT_KEY = "cv.outputKey";
    private static final String CV_ID = "cv.id";
    private static final String CV_UPDATE_DATA_FILTER = "cv.updateDataFilters";
    private static final String DASHBOARD_ID = "dashboardID";
    private static final String CV_DELAYED_KEY = "cv.delayedKey";
    private StringBuilder widgetIdBase;
    protected HashMap<String, Object> extractedInfoForWidgets;
    private static AtomicInteger viewerWidgetIdx = new AtomicInteger(1);
    private Object requestHandle;
    private String currentUserRole;
    private Map<String, String[]> urlParams = new HashMap<String, String[]>();
    private static final String PARAM_VALUE_SPLLITER = ",";
    private static final String P_PARAM_PREFIX = "p_";
    private String locale;

    public AtomWidgetProcessor create() {
        return new ViewerWidgetProcessor();
    }

    public void release() {
    }

    public void preProcessDashboardAction(Object bibusRequestHandle, String userRole, DashboardEntryHelper dbEntryHelper, Map<String, String[]> urlParameters, String localeStr) {
        this.widgetIdBase = new StringBuilder(128);
        this.widgetIdBase.append(dbEntryHelper.getDashboardID()).append('.');
        this.extractedInfoForWidgets = new HashMap();
        this.currentUserRole = userRole;
        this.requestHandle = bibusRequestHandle;
        this.urlParams = urlParameters;
        this.locale = localeStr;
    }

    public Map<String, String[]> getURLParams() {
        return this.urlParams;
    }

    public void processWidgetInstance(Element widgetInstance, DashboardEntryHelper dbEntryHelper, FrameworkContext context) throws Exception {
        if (this.isViewerWidgetInstance(widgetInstance)) {
            this._processWidgetInstance(widgetInstance, dbEntryHelper, context);
        }
    }

    private void _processWidgetInstance(Element widgetInstance, DashboardEntryHelper dbEntryHelper, FrameworkContext context) {
        HashMap<String, String> extractedWidgetItemSet = this.prepareViewerWidgetItemSet(dbEntryHelper, this.extractedInfoForWidgets, widgetInstance);
        NodeList itemSets = dbEntryHelper.getContentItemSets(widgetInstance);
        int len = itemSets.getLength();
        int k = 0;
        while (k < len) {
            String sliderState;
            String sliderIDs;
            String sliderIDsStr;
            Element srcContentItemSet = (Element)itemSets.item(k);
            this.extractItems(dbEntryHelper, srcContentItemSet, extractedWidgetItemSet);
            String contentLocale = this.locale;
            int indexOfDash = contentLocale.indexOf("-");
            if (indexOfDash != -1) {
                contentLocale = contentLocale.substring(0, indexOfDash);
            }
            String lastSavedContentLocale = contentLocale;
            String savedLocalesStr = extractedWidgetItemSet.get("SavedLocales");
            if (savedLocalesStr != null) {
                String[] savedLocales = savedLocalesStr.replace("defaultLocale", "").replace("true", "").replace("false", "").replace("{", "").replace("}", "").replace("\"", "").replace("::", "").split(PARAM_VALUE_SPLLITER);
                int i = 0;
                while (i < savedLocales.length) {
                    if (savedLocales[i].contains(contentLocale)) {
                        lastSavedContentLocale = savedLocales[i];
                    }
                    ++i;
                }
            }
            if ((sliderIDsStr = extractedWidgetItemSet.get("sliderIDs")) != null && (sliderIDs = sliderIDsStr.replace("[", "").replace("]", "").replace("\"", "")) != null && !sliderIDs.isEmpty() && (sliderState = extractedWidgetItemSet.get("sliderState_" + sliderIDs + "_" + lastSavedContentLocale)) != null && !sliderState.isEmpty()) {
                StringBuilder updateDataFilters = new StringBuilder();
                EncodingUtils.xmlencode((String)sliderState, (StringBuilder)updateDataFilters);
                extractedWidgetItemSet.put(CV_UPDATE_DATA_FILTER, "<UpdateDataFilters><filter>" + updateDataFilters.toString() + "</filter>" + "</UpdateDataFilters>");
            }
            String displayTitle = dbEntryHelper.getCustomTitle(widgetInstance, this.locale);
            String widgetTitle = extractedWidgetItemSet.get("widgetTitle");
            extractedWidgetItemSet.put("cv.buxRTStateInfo", dbEntryHelper.getWidgetRTStateInfo(widgetTitle));
            if (displayTitle == null) {
                displayTitle = widgetTitle;
            }
            extractedWidgetItemSet.put("displayTitle", displayTitle);
            this.addDashboardIDToItemSet(dbEntryHelper, extractedWidgetItemSet);
            this.addCvIdAndOutputKey(dbEntryHelper, srcContentItemSet, extractedWidgetItemSet, viewerWidgetIdx.getAndIncrement(), dbEntryHelper.getWidgetID(widgetInstance));
            this.addP_parametersToItemSet(this.getURLParams(), extractedWidgetItemSet);
            srcContentItemSet.appendChild(dbEntryHelper.createContentItemSetItem(srcContentItemSet, X_NODE_ID, context.getNodeID()));
            ++k;
        }
    }

    private HashMap<String, String> prepareViewerWidgetItemSet(DashboardEntryHelper context, HashMap<String, Object> widgetInfo, Element widgetInstance) {
        String widgetId = context.getAttrNodeValue(widgetInstance, ID);
        HashMap<String, String> itemSetForViewerWidget = new HashMap<String, String>();
        widgetInfo.put(widgetId, itemSetForViewerWidget);
        return itemSetForViewerWidget;
    }

    private void extractItems(DashboardEntryHelper context, Element src, HashMap<String, String> dest) {
        NodeList entries = DomUtils.selectNodes((Element)src, (String)ITEM);
        int len = entries.getLength();
        int l = 0;
        while (l < len) {
            Element entry = (Element)entries.item(l);
            dest.put(context.getAttrNodeValue(entry, ID), context.getAttrNodeValue(entry, VALUE));
            ++l;
        }
    }

    private void addCvIdAndOutputKey(DashboardEntryHelper context, Element contentItemSet, HashMap<String, String> itemSetForViewerWidget, int nId, String widgetId) {
        String outputKey = new StringBuilder(this.widgetIdBase).append(widgetId).toString();
        String wId = new StringBuilder(32).append("_x").append(nId).toString();
        itemSetForViewerWidget.put(CV_ID, wId);
        itemSetForViewerWidget.put(CV_DELAYED_KEY, outputKey);
        contentItemSet.appendChild(context.createContentItemSetItem(contentItemSet, CV_OUTPUT_KEY, outputKey));
    }

    private void addDashboardIDToItemSet(DashboardEntryHelper context, HashMap<String, String> targetItemSet) {
        String dbid = targetItemSet.get(DASHBOARD_ID);
        if (dbid == null) {
            dbid = "$$dbid$$";
        }
        dbid = dbid + context.getDashboardID();
        targetItemSet.remove(DASHBOARD_ID);
        targetItemSet.put(DASHBOARD_ID, dbid);
    }

    public void addP_parametersToItemSet(Map<String, String[]> urlParameters, Map<String, String> targetItemSet) {
        if (urlParameters != null) {
            for (Map.Entry<String, String[]> entry : urlParameters.entrySet()) {
                String key = entry.getKey();
                String[] paramValue = entry.getValue();
                if (!key.startsWith(P_PARAM_PREFIX)) continue;
                int max = paramValue.length - 1;
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i <= max) {
                    sb.append(paramValue[i]);
                    if (i < max) {
                        sb.append(PARAM_VALUE_SPLLITER);
                    }
                    ++i;
                }
                targetItemSet.put(key, sb.toString());
            }
        }
    }

    private boolean isViewerWidgetInstance(Element widgetInstance) {
        String val;
        boolean bRet = false;
        Node urlNode = DomUtils.selectSingleNode((Element)widgetInstance, (String)URL);
        if (urlNode != null && ((val = DomUtils.getTextContent((Node)urlNode)).contains(VIEWER_I_WIDGET_XML) || val.contains(VIEWER_I_WIDGET_DEBUG_XML))) {
            bRet = true;
        }
        return bRet;
    }

    public void postProcessDashboardAction() {
        LocalPlatformServices platform = PlatformServicesTrackerCustomizer.getPlatformServices();
        Object envelope = platform.getRequestEnvelope_dom4j(this.requestHandle);
        if (this.extractedInfoForWidgets != null) {
            for (Map.Entry<String, Object> widget : this.extractedInfoForWidgets.entrySet()) {
                this.postProcessDashboardAction(platform, envelope, widget);
            }
        }
    }

    private void postProcessDashboardAction(LocalPlatformServices platform, Object skeletalRequestEnvelope, Map.Entry<String, Object> widget) {
        HashMap contentItemSet = (HashMap)widget.getValue();
        HashMap<String, String> params = this.populateParams(contentItemSet);
        try {
            Object reqEnvelopeCopy = platform.copyRequestEnvelope_dom4j(skeletalRequestEnvelope);
            platform.invoke_dom4j(this.requestHandle, reqEnvelopeCopy, "presentationService.cognosViewerExpeditorHandler", params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HashMap<String, String> populateParams(HashMap<String, String> contentItemSet) {
        String[] containerParam;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("b_action", "cvx");
        params.put("cv.waitForResponse", "false");
        params.put("widget.itemSet", "true");
        params.put("userRole", this.currentUserRole);
        if (this.urlParams != null && (containerParam = this.urlParams.get(CONTAINER)) != null && containerParam[0] != null) {
            params.put(CONTAINER, containerParam[0]);
        }
        for (Map.Entry<String, String> item : contentItemSet.entrySet()) {
            params.put(item.getKey(), item.getValue());
        }
        return params;
    }
}

