/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json;

import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JsonWriter {
    private static final int STR_BUFFER_LEN = 4096;
    protected JsonFactory factory;
    protected boolean prettyPrint;
    protected Writer out;
    protected char[] indent;
    protected int indentLevel;
    private char[] strBuf;

    public JsonWriter(boolean prettyPrint) {
        this(DefaultJsonFactory.instance, prettyPrint);
    }

    public JsonWriter(JsonFactory f, boolean prettyPrint) {
        this.factory = f;
        this.prettyPrint = prettyPrint;
        this.indent = prettyPrint ? new char[60] : new char[0];
        Arrays.fill(this.indent, 0, this.indent.length, ' ');
        this.indentLevel = 0;
        this.strBuf = new char[4096];
    }

    void setBufferSize(int size) {
        this.strBuf = new char[size];
    }

    public void write(OutputStream os, Object obj) throws IOException {
        this.write(new OutputStreamWriter(os, StandardCharsets.UTF_8), obj);
    }

    public void write(Writer w, Object obj) throws IOException {
        this.out = w;
        this.writeAny(obj);
        w.flush();
    }

    protected void writeAny(Object obj) throws IOException {
        if (this.factory.isNull(obj)) {
            this.out.write("null");
        } else if (obj instanceof Map) {
            this.writeObject((Map)obj);
        } else if (obj instanceof List) {
            this.writeArray((List)obj);
        } else if (this.factory.isString(obj)) {
            this.writeString(this.factory.toString(obj));
        } else if (this.factory.isBoolean(obj)) {
            this.out.write(Boolean.toString(this.factory.toBoolean(obj)));
        } else if (this.factory.isLong(obj)) {
            this.out.write(Long.toString(this.factory.toLong(obj)));
        } else if (this.factory.isDouble(obj)) {
            this.out.write(Double.toString(this.factory.toDouble(obj)));
        } else if (this.factory.isBigInteger(obj)) {
            this.out.write(this.factory.toBigInteger(obj).toString());
        } else if (this.factory.isBigDecimal(obj)) {
            this.out.write(this.factory.toBigDecimal(obj).toString());
        } else {
            this.out.write(this.factory.toString(obj));
        }
    }

    private void writeArray(List<Object> obj) throws IOException {
        if (obj.isEmpty()) {
            this.out.write("[]");
            return;
        }
        this.out.write("[");
        this.indent();
        boolean first = true;
        for (Object o : obj) {
            if (first) {
                first = false;
            } else {
                this.out.write(",");
            }
            this.newLine();
            this.writeAny(o);
        }
        this.unindent();
        this.newLine();
        this.out.write("]");
    }

    protected void writeObject(Map<Object, Object> obj) throws IOException {
        if (obj.isEmpty()) {
            this.out.write("{}");
            return;
        }
        if (this.indentLevel != 0) {
            this.newLine();
        }
        this.out.write("{");
        this.indent();
        boolean first = true;
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            if (first) {
                first = false;
            } else {
                this.out.write(",");
            }
            this.newLine();
            String key = this.factory.toString(entry.getKey());
            this.writeString(key);
            if (this.prettyPrint) {
                this.out.write(": ");
            } else {
                this.out.write(":");
            }
            this.writeAny(entry.getValue());
        }
        this.unindent();
        this.newLine();
        this.out.write("}");
    }

    protected void writeString(String value) throws IOException {
        this.out.write(34);
        int end = 0;
        int strLen = value.length();
        while (end < strLen) {
            int start = end;
            int n = Math.min(this.strBuf.length, strLen - start);
            end = start + n;
            value.getChars(start, end, this.strBuf, 0);
            int off = 0;
            String escape = null;
            for (int i = 0; i < n; ++i) {
                char ch = this.strBuf[i];
                switch (ch) {
                    case '\b': {
                        escape = "\\b";
                        break;
                    }
                    case '\t': {
                        escape = "\\t";
                        break;
                    }
                    case '\n': {
                        escape = "\\n";
                        break;
                    }
                    case '\f': {
                        escape = "\\f";
                        break;
                    }
                    case '\r': {
                        escape = "\\r";
                        break;
                    }
                    case '\"': {
                        escape = "\\\"";
                        break;
                    }
                    case '/': {
                        escape = "\\/";
                        break;
                    }
                    case '\\': {
                        escape = "\\\\";
                        break;
                    }
                    default: {
                        if (ch >= ' ' && ch <= '~') break;
                        escape = String.format("\\u%04x", ch);
                    }
                }
                if (escape == null) continue;
                if (i != off) {
                    this.out.write(this.strBuf, off, i - off);
                }
                this.out.write(escape);
                escape = null;
                off = i + 1;
            }
            if (off >= n) continue;
            this.out.write(this.strBuf, off, n - off);
        }
        this.out.write(34);
    }

    protected void newLine() throws IOException {
        if (this.prettyPrint) {
            this.out.write("\r\n");
            this.out.write(this.indent, 0, this.indentLevel);
        }
    }

    protected void indent() {
        if (this.prettyPrint) {
            this.indentLevel += 3;
            if (this.indentLevel > this.indent.length) {
                char[] tmp = new char[this.indent.length + 60];
                Arrays.fill(tmp, ' ');
                this.indent = tmp;
            }
        }
    }

    protected void unindent() {
        if (this.prettyPrint) {
            this.indentLevel -= 3;
            if (this.indentLevel < 0) {
                throw new IllegalStateException();
            }
        }
    }
}

