/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.keystore;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfiguration;
import com.ibm.bi.platform.commons.crypto.api.CAMKeyPair;
import com.ibm.bi.platform.commons.crypto.api.Parameters;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMKeyStore;
import com.ibm.bi.platform.commons.crypto.internal.keystore.KeyDistributor;
import com.ibm.bi.platform.commons.crypto.internal.utils.CryptoParams;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.crypto.internal.utils.KeysAndCertsGenerator;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Optional;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalKeyDistributorProvider
extends KeyDistributor.KeyDistributorSpi {
    private static final String keyPairEntryAlias = "default";
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyDistributor.class);

    @Override
    public CAMKeyPair engineGetKeyPair(String algorithm) throws CAMCryptoException {
        CAMKeyStore localKeyStore = this.localKeyStore();
        Optional<CAMKeyPair> mayBeKeyPair = this.keyPairFromLocalKeyStore(localKeyStore);
        if (this.isKeyPairWithRequestedAlgorithmPresent(algorithm, mayBeKeyPair)) {
            return mayBeKeyPair.get();
        }
        KeyPair keyPair = KeysAndCertsGenerator.newKeyPair(algorithm, CryptoParams.getInstance().keyLength(algorithm));
        this.persistKeyPairToLocalKeyStore(keyPair, localKeyStore);
        return this.keyPairFromLocalKeyStore(localKeyStore).orElseThrow(() -> new CAMCryptoException(CamCryptoMessageKeys.could_not_retrieve_key_from_distributor.buildMessage()));
    }

    private CAMKeyStore localKeyStore() throws CAMCryptoException {
        CAMKeyStore localKeyStore = null;
        try {
            localKeyStore = CAMKeyStore.newInstance("pkcs12", Config.localDistributorKeyStorePath, Config.localDistributorKeyStorePassword);
        }
        catch (CAMCryptoException e) {
            LOGGER.error("couldn't load the existing key store due to file corruption or wrong password", (Throwable)((Object)e));
            try {
                LOGGER.info("trying to delete the current local distributor keystore {}", (Object)Config.localDistributorKeyStorePath);
                FileUtils.forceDelete((File)new File(Config.localDistributorKeyStorePath));
            }
            catch (IOException ioException) {
                LOGGER.error("couldn't delete the local distributor keystore", (Throwable)ioException);
                throw new CAMCryptoException(ioException, CamCryptoMessageKeys.could_not_load_keystore.buildMessage((Object)Config.localDistributorKeyStorePath));
            }
            try {
                LOGGER.info("trying to load the local distributor keystore {} again", (Object)Config.localDistributorKeyStorePath);
                localKeyStore = CAMKeyStore.newInstance("pkcs12", Config.localDistributorKeyStorePath, Config.localDistributorKeyStorePassword);
            }
            catch (CAMCryptoException e2) {
                throw new CAMCryptoException((Throwable)((Object)e2), CamCryptoMessageKeys.could_not_load_keystore.buildMessage((Object)Config.localDistributorKeyStorePath));
            }
        }
        if (localKeyStore == null) {
            throw new CAMCryptoException(CamCryptoMessageKeys.could_not_load_keystore.buildMessage((Object)Config.localDistributorKeyStorePath));
        }
        return localKeyStore;
    }

    private Optional<CAMKeyPair> keyPairFromLocalKeyStore(CAMKeyStore localKeyStore) throws CAMCryptoException {
        PrivateKey privateKey = localKeyStore.getPrivateKey(keyPairEntryAlias);
        Certificate certificate = localKeyStore.getTargetCertificate(keyPairEntryAlias);
        if (privateKey != null && certificate != null) {
            return Optional.of(new CAMKeyPair(this.uniqueId(certificate.getPublicKey()), privateKey.getAlgorithm(), privateKey, certificate.getPublicKey()));
        }
        return Optional.empty();
    }

    private boolean isKeyPairWithRequestedAlgorithmPresent(String algorithm, Optional<CAMKeyPair> persistedKeyPair) {
        return persistedKeyPair.isPresent() && persistedKeyPair.get().algorithm.toLowerCase().equals(algorithm.toLowerCase());
    }

    private void persistKeyPairToLocalKeyStore(KeyPair keyPair, CAMKeyStore localKeyStore) throws CAMCryptoException {
        X509Certificate publicKeySelfSignedCert = KeysAndCertsGenerator.selfSignedCertificate(new X500Principal("CN=distribution.cognos.ibm, OU=Cognos, O=IBM, C=CA"), keyPair.getPrivate(), keyPair.getPublic(), CryptoParams.getInstance().signatureAlgorithm(keyPair.getPrivate().getAlgorithm()), 933);
        localKeyStore.addPrivateKeyWithCertChain(keyPairEntryAlias, keyPair.getPrivate(), (Certificate[])Stream.of(publicKeySelfSignedCert).toArray(X509Certificate[]::new));
        localKeyStore.persist();
    }

    private String uniqueId(PublicKey publicKey) throws CAMCryptoException {
        try {
            MessageDigest messageDigest = JcaFactory.getInstance(MessageDigest.class, "SHA-256");
            byte[] publicKeyHash = messageDigest.digest(publicKey.getEncoded());
            return Base64.getEncoder().encodeToString(publicKeyHash);
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.crypto_algorithm_not_supported.buildMessage((Object)"SHA-256", (Object)"message digest"));
        }
    }

    @Override
    public CAMKeyPair engineGetKeyPair(String algorithm, Parameters params) {
        throw new UnsupportedOperationException();
    }

    public static class Config {
        public static String localDistributorKeyStorePath;
        public static char[] localDistributorKeyStorePassword;

        static {
            localDistributorKeyStorePassword = JCAMCryptoConfiguration.getProvider().getCSKPathPassword().toCharArray();
            String jksKeyStoreLocation = JCAMCryptoConfiguration.getProvider().getCamKeystoreFile();
            String keyStoresFolder = new File(jksKeyStoreLocation).getParent();
            localDistributorKeyStorePath = keyStoresFolder + File.separator + "distributorKeyStore.p12";
        }
    }
}

