/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client.hotspot;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class BufferPoolsExports
extends Collector {
    private static final Logger LOGGER = Logger.getLogger(BufferPoolsExports.class.getName());
    private final List<Object> bufferPoolMXBeans = new ArrayList<Object>();
    private Method getName;
    private Method getMemoryUsed;
    private Method getTotalCapacity;
    private Method getCount;

    public BufferPoolsExports() {
        try {
            Class<?> bufferPoolMXBeanClass = Class.forName("java.lang.management.BufferPoolMXBean");
            this.bufferPoolMXBeans.addAll(BufferPoolsExports.accessBufferPoolMXBeans(bufferPoolMXBeanClass));
            this.getName = bufferPoolMXBeanClass.getMethod("getName", new Class[0]);
            this.getMemoryUsed = bufferPoolMXBeanClass.getMethod("getMemoryUsed", new Class[0]);
            this.getTotalCapacity = bufferPoolMXBeanClass.getMethod("getTotalCapacity", new Class[0]);
            this.getCount = bufferPoolMXBeanClass.getMethod("getCount", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            LOGGER.fine("BufferPoolMXBean not available, no metrics for buffer pools will be exported");
        }
        catch (NoSuchMethodException e) {
            LOGGER.fine("Can not get necessary accessor from BufferPoolMXBean: " + e.getMessage());
        }
    }

    private static List<Object> accessBufferPoolMXBeans(Class<?> bufferPoolMXBeanClass) {
        try {
            Method getPlatformMXBeansMethod = ManagementFactory.class.getMethod("getPlatformMXBeans", Class.class);
            Object listOfBufferPoolMXBeanInstances = getPlatformMXBeansMethod.invoke(null, bufferPoolMXBeanClass);
            return (List)listOfBufferPoolMXBeanInstances;
        }
        catch (NoSuchMethodException e) {
            LOGGER.fine("ManagementFactory.getPlatformMXBeans not available, no metrics for buffer pools will be exported");
            return Collections.emptyList();
        }
        catch (IllegalAccessException e) {
            LOGGER.fine("ManagementFactory.getPlatformMXBeans not accessible, no metrics for buffer pools will be exported");
            return Collections.emptyList();
        }
        catch (InvocationTargetException e) {
            LOGGER.warning("ManagementFactory.getPlatformMXBeans could not be invoked, no metrics for buffer pools will be exported");
            return Collections.emptyList();
        }
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        GaugeMetricFamily used = new GaugeMetricFamily("jvm_buffer_pool_used_bytes", "Used bytes of a given JVM buffer pool.", Collections.singletonList("pool"));
        mfs.add(used);
        GaugeMetricFamily capacity = new GaugeMetricFamily("jvm_buffer_pool_capacity_bytes", "Bytes capacity of a given JVM buffer pool.", Collections.singletonList("pool"));
        mfs.add(capacity);
        GaugeMetricFamily buffers = new GaugeMetricFamily("jvm_buffer_pool_used_buffers", "Used buffers of a given JVM buffer pool.", Collections.singletonList("pool"));
        mfs.add(buffers);
        for (Object pool : this.bufferPoolMXBeans) {
            used.addMetric(Collections.singletonList(this.getName(pool)), this.callLongMethond(this.getMemoryUsed, pool));
            capacity.addMetric(Collections.singletonList(this.getName(pool)), this.callLongMethond(this.getTotalCapacity, pool));
            buffers.addMetric(Collections.singletonList(this.getName(pool)), this.callLongMethond(this.getCount, pool));
        }
        return mfs;
    }

    private long callLongMethond(Method method, Object pool) {
        try {
            return (Long)method.invoke(pool, new Object[0]);
        }
        catch (IllegalAccessException e) {
            LOGGER.fine("Couldn't call " + method.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.fine("Couldn't call " + method.getName() + ": " + e.getMessage());
        }
        return 0L;
    }

    private String getName(Object pool) {
        try {
            return (String)this.getName.invoke(pool, new Object[0]);
        }
        catch (IllegalAccessException e) {
            LOGGER.fine("Couldn't call getName " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.fine("Couldn't call getName " + e.getMessage());
        }
        return "<unknown>";
    }
}

