/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.jmx;

import io.prometheus.jmx.shaded.io.prometheus.jmx.JmxCollector;
import io.prometheus.jmx.shaded.io.prometheus.jmx.MatchedRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MatchedRulesCache {
    private final Map<JmxCollector.Rule, Map<String, MatchedRule>> cachedRules;

    public MatchedRulesCache(Collection<JmxCollector.Rule> rules) {
        this.cachedRules = new HashMap<JmxCollector.Rule, Map<String, MatchedRule>>(rules.size());
        for (JmxCollector.Rule rule : rules) {
            this.cachedRules.put(rule, new ConcurrentHashMap());
        }
    }

    public void put(JmxCollector.Rule rule, String cacheKey, MatchedRule matchedRule) {
        Map<String, MatchedRule> cachedRulesForRule = this.cachedRules.get(rule);
        cachedRulesForRule.put(cacheKey, matchedRule);
    }

    public MatchedRule get(JmxCollector.Rule rule, String cacheKey) {
        return this.cachedRules.get(rule).get(cacheKey);
    }

    public void evictStaleEntries(StalenessTracker stalenessTracker) {
        for (Map.Entry<JmxCollector.Rule, Map<String, MatchedRule>> entry : this.cachedRules.entrySet()) {
            JmxCollector.Rule rule = entry.getKey();
            Map<String, MatchedRule> cachedRulesForRule = entry.getValue();
            for (String cacheKey : cachedRulesForRule.keySet()) {
                if (stalenessTracker.contains(rule, cacheKey)) continue;
                cachedRulesForRule.remove(cacheKey);
            }
        }
    }

    public static class StalenessTracker {
        private final Map<JmxCollector.Rule, Set<String>> lastCachedEntries = new HashMap<JmxCollector.Rule, Set<String>>();

        public void add(JmxCollector.Rule rule, String cacheKey) {
            Set<String> lastCachedEntriesForRule = this.lastCachedEntries.get(rule);
            if (lastCachedEntriesForRule == null) {
                lastCachedEntriesForRule = new HashSet<String>();
                this.lastCachedEntries.put(rule, lastCachedEntriesForRule);
            }
            lastCachedEntriesForRule.add(cacheKey);
        }

        public boolean contains(JmxCollector.Rule rule, String cacheKey) {
            Set<String> lastCachedEntriesForRule = this.lastCachedEntries.get(rule);
            return lastCachedEntriesForRule != null && lastCachedEntriesForRule.contains(cacheKey);
        }

        public long cachedCount() {
            long count = 0L;
            for (Set<String> cacheKeys : this.lastCachedEntries.values()) {
                count += (long)cacheKeys.size();
            }
            return count;
        }
    }
}

