/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java;

import com.ibm.json.java.JSONObject;
import com.ibm.json.java.internal.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;

public class OrderedJSONObject
extends JSONObject {
    private static final long serialVersionUID = -3269263069889337299L;
    private ArrayList order = new ArrayList();

    public static JSONObject parse(Reader reader) throws IOException {
        reader = new BufferedReader(reader);
        return new Parser(reader).parse(true);
    }

    public static JSONObject parse(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        return OrderedJSONObject.parse(stringReader);
    }

    public static JSONObject parse(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (Exception exception) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        return OrderedJSONObject.parse(inputStreamReader);
    }

    public Object put(Object object, Object object2) {
        if (null == object) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!OrderedJSONObject.isValidObject(object2)) {
            if (object2 != null) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + object2.getClass().getName() + "] with value: [" + object2.toString() + "]");
            }
            throw new IllegalArgumentException("Invalid type of value.");
        }
        if (!this.containsKey(object)) {
            this.order.add(object);
        }
        return super.put(object, object2);
    }

    public Object remove(Object object) {
        Object var2_2 = null;
        if (null == object) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.containsKey(object)) {
            var2_2 = super.remove(object);
            for (int i = 0; i < this.order.size(); ++i) {
                Object e = this.order.get(i);
                if (!e.equals(object)) continue;
                this.order.remove(i);
                break;
            }
        }
        return var2_2;
    }

    public void clear() {
        super.clear();
        this.order.clear();
    }

    public Object clone() {
        OrderedJSONObject orderedJSONObject = (OrderedJSONObject)super.clone();
        Iterator iterator = orderedJSONObject.getOrder();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
            orderedJSONObject.order = arrayList;
        }
        return orderedJSONObject;
    }

    public Iterator getOrder() {
        return this.order.iterator();
    }
}

