/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import sun.nio.cs.Surrogate;

class COMPOUND_TEXT_Encoder
extends CharsetEncoder {
    private static final byte ISO_ESC = 27;
    private static final int DBCSESC = 36;
    private static final byte MSB = -128;
    private static final char REPLACE_CHAR = '\ufffd';
    private static final int ISO2022 = 64;
    private static final int UTF8 = 71;
    private static final int ASCII = 66;
    private static final byte[] DOCS_ISO2022 = new byte[]{27, 37, 64};
    private static final byte[] DOCS_UTF8 = new byte[]{27, 37, 71};
    private static final byte[] DOCS_ASCII = new byte[]{27, 40, 66};
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private CharsetEncoder[] Encoders;
    private int state;
    private int docstate;
    private int defaultMap = 0;
    private static final int ISO1 = 11585;
    private static final int ISO2 = 11586;
    private static final int ISO3 = 11587;
    private static final int ISO4 = 11588;
    private static final int ISO5 = 11596;
    private static final int ISO6 = 11591;
    private static final int ISO7 = 11590;
    private static final int ISO8 = 11592;
    private static final int ISO9 = 11597;
    private static final int ISO10 = 11606;
    private static final int ISO13 = 11609;
    private static final int ISO14 = 11615;
    private static final int ISO15 = 11618;
    private static final int ISO16 = 11597;
    private static final int TIS620 = 11604;
    private static final int KATAKANA = 10569;
    private static final int GB2312 = 9281;
    private static final int JIS0208 = 9282;
    private static final int KSC5601 = 9283;
    private static final int JIS0212 = 9284;
    private static final int CNSP1 = 9287;
    private static final String osName = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("os.name");
        }
    });
    static CTMap[] ctmap = new CTMap[]{new CTMap(11585, "ISO-8859-1", "\u00a0\u00ff"), new CTMap(10569, "JIS0201", "\uff61\uff9f"), new CTMap(11618, "ISO-8859-15", "\u0152\u0153\u0178\u0178\u20ac\u20ac"), new CTMap(11586, "ISO-8859-2", "\u0102\u0107\u010c\u0111\u0118\u011b\u0139\u013a\u013d\u013e\u0141\u0144\u0147\u0148\u0150\u0151\u0154\u0155\u0158\u0165\u016e\u0171\u0179\u017e\u02c7\u02c7\u02d8\u02d9\u02db\u02db\u02dd\u02dd"), new CTMap(11596, "ISO-8859-5", "\u0401\u045f\u2116\u2116"), new CTMap(11591, "ISO-8859-6", "\u060c\u066d\u200b\u200b\ufe70\ufef4"), new CTMap(11590, "ISO-8859-7", "\u02bc\u02bd\u0384\u03ce\u2015\u2015"), new CTMap(11592, "ISO-8859-8", "\u05d0\u05ea\u2017\u2017\u203e\u203e"), new CTMap(11597, "ISO-8859-9", "\u011e\u011f\u0130\u0131\u015e\u015f"), new CTMap(11604, "TIS620", "\u0e01\u0e5b"), new CTMap(11597, "ISO-8859-16", "\u0218\u021b"), new CTMap(11587, "ISO-8859-3", "\u0108\u0178"), new CTMap(11588, "ISO-8859-4", "\u0100\u017e\u02c7\u02c7"), new CTMap(11615, "ISO-8859-14", "\u010a\u0177\u1e0a\u1ef3"), new CTMap(9282, "JIS0208", "\u2010\u30fe\u4e00\u9fff\uff01\uff60\uffa0\uffef"), new CTMap(9281, "GB2312", "\u2010\u3229\u4e00\u9fff\uff01\uffef"), new CTMap(9283, "KSC5601", "\u2010\u33dd\u4e00\u9fff\uac00\ud7ff\uf900\uffef"), new CTMap(9284, "JIS0212", "\u4e00\u9fff"), new CTMap(9287, "EUC_TW", "\u2010\u33d5\u4e00\u9fff\ufe30\uffef"), new CTMap(0, null, null)};
    static final int completeMap = 11;
    char[] inbuf = new char[1];
    CharBuffer cb = CharBuffer.wrap(this.inbuf);
    byte[] outbuf = new byte[4];
    ByteBuffer bb = ByteBuffer.wrap(this.outbuf);

    COMPOUND_TEXT_Encoder(Charset charset) {
        super(charset, 3.0f, 9.0f);
        String string = Locale.getDefault().getLanguage();
        if (string.equals("ja")) {
            this.defaultMap = COMPOUND_TEXT_Encoder.findMap(9282);
        } else if (string.equals("zh")) {
            String string2 = Locale.getDefault().getCountry();
            this.defaultMap = string2.equals("TW") || string2.equals("HK") ? COMPOUND_TEXT_Encoder.findMap(9287) : COMPOUND_TEXT_Encoder.findMap(9281);
        } else if (string.equals("ko")) {
            this.defaultMap = COMPOUND_TEXT_Encoder.findMap(9283);
        }
        this.state = 11585;
        this.docstate = 64;
        this.Encoders = new CharsetEncoder[ctmap.length];
    }

    static int findMap(int n) {
        n <<= 16;
        for (int i = 0; i < ctmap.length; ++i) {
            if (n != COMPOUND_TEXT_Encoder.ctmap[i].state) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean isLegalReplacement(byte[] byArray) {
        return byArray.length == 1 && byArray[0] >= 32 && byArray[0] <= 126;
    }

    public boolean canEncode(int n) {
        return n >= 32 || n == 0 || n == 10 || n == 9;
    }

    @Override
    protected void implReset() {
        this.state = 11585;
        this.docstate = 64;
    }

    private CoderResult putSingle(ByteBuffer byteBuffer, int n) {
        int n2;
        if (this.docstate != 64) {
            if (byteBuffer.remaining() < DOCS_ISO2022.length) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put(DOCS_ISO2022);
        }
        if ((n2 = n >> 16) != this.state) {
            if (byteBuffer.remaining() < 3) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)27);
            byteBuffer.put((byte)(n2 >> 8));
            byteBuffer.put((byte)n2);
            this.state = n2;
        }
        if (!byteBuffer.hasRemaining()) {
            return CoderResult.OVERFLOW;
        }
        byteBuffer.put((byte)(n | 0xFFFFFF80));
        return null;
    }

    private CoderResult putDouble(ByteBuffer byteBuffer, int n) {
        int n2;
        if (this.docstate != 64) {
            if (byteBuffer.remaining() < DOCS_ISO2022.length) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put(DOCS_ISO2022);
            this.docstate = 64;
        }
        if (this.state != (n2 = n >> 16)) {
            if (byteBuffer.remaining() < 4) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)27);
            byteBuffer.put((byte)(n2 >> 8));
            byteBuffer.put((byte)41);
            byteBuffer.put((byte)n2);
            this.state = n2;
        }
        if (byteBuffer.remaining() < 2) {
            return CoderResult.OVERFLOW;
        }
        byteBuffer.put((byte)(n >> 8 | 0xFFFFFF80));
        byteBuffer.put((byte)(n | 0xFFFFFF80));
        return null;
    }

    private CoderResult putUnicode(ByteBuffer byteBuffer, int n) {
        int n2;
        if (this.docstate != 71) {
            if (byteBuffer.remaining() < DOCS_UTF8.length) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put(DOCS_UTF8);
            this.docstate = 71;
        }
        int n3 = n < 2048 ? 2 : (n2 = n < 65536 ? 3 : 4);
        if (byteBuffer.remaining() < n2 && byteBuffer.remaining() < n2) {
            return CoderResult.OVERFLOW;
        }
        switch (n2) {
            case 2: {
                byteBuffer.put((byte)(0xC0 | n >> 6 & 0x1F));
                byteBuffer.put((byte)(0x80 | n & 0x3F));
                break;
            }
            case 3: {
                byteBuffer.put((byte)(0xE0 | n >> 12 & 0xF));
                byteBuffer.put((byte)(0x80 | n >> 6 & 0x3F));
                byteBuffer.put((byte)(0x80 | n & 0x3F));
                break;
            }
            case 4: {
                byteBuffer.put((byte)(0xF0 | n >> 18 & 7));
                byteBuffer.put((byte)(0x80 | n >> 12 & 0x3F));
                byteBuffer.put((byte)(0x80 | n >> 6 & 0x3F));
                byteBuffer.put((byte)(0x80 | n & 0x3F));
            }
        }
        return null;
    }

    int getBytes(int n, int n2) {
        if (n == 0) {
            return 0x2D410000 | n2;
        }
        if (n == 1) {
            return 0x29490000 | n2 - 65344;
        }
        if (this.Encoders[n] == null) {
            try {
                this.Encoders[n] = Charset.forName(COMPOUND_TEXT_Encoder.ctmap[n].name).newEncoder();
            }
            catch (Exception exception) {
                COMPOUND_TEXT_Encoder.ctmap[n].invalid = true;
                return 0;
            }
        }
        CharsetEncoder charsetEncoder = this.Encoders[n];
        this.cb.rewind();
        this.bb.rewind();
        this.inbuf[0] = (char)n2;
        charsetEncoder.reset();
        CoderResult coderResult = charsetEncoder.encode(this.cb, this.bb, true);
        if (coderResult.isError()) {
            return 0;
        }
        int n3 = this.bb.position();
        int n4 = COMPOUND_TEXT_Encoder.ctmap[n].state;
        if (n3 == 1) {
            return n4 | this.outbuf[0] & 0xFF;
        }
        if (n3 == 2) {
            return n4 | this.outbuf[1] & 0xFF | (this.outbuf[0] & 0xFF) << 8;
        }
        if (n3 == 4 && this.outbuf[0] == -114) {
            int n5 = this.outbuf[2] & 0xFF | (this.outbuf[3] & 0xFF) << 8;
            return (n4 += (this.outbuf[1] & 7) - 1 << 16) | n5;
        }
        return 0;
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult = null;
        while (charBuffer.hasRemaining()) {
            int n = charBuffer.position();
            int n2 = charBuffer.get();
            if (Surrogate.is(n2) && (n2 = this.sgp.parse((char)n2, charBuffer)) < 0) {
                charBuffer.position(n);
                return this.sgp.error();
            }
            if (n2 <= 127) {
                if (n2 >= 32 || n2 == 0 || n2 == 9 || n2 == 10) {
                    if (osName.indexOf("AIX") != -1 && this.docstate != 66) {
                        if (byteBuffer.remaining() < DOCS_ASCII.length) {
                            return CoderResult.OVERFLOW;
                        }
                        byteBuffer.put(DOCS_ASCII);
                        this.docstate = 66;
                    }
                    if (byteBuffer.hasRemaining()) {
                        byteBuffer.put((byte)(n2 & 0x7F));
                    } else {
                        coderResult = CoderResult.OVERFLOW;
                    }
                } else if (n2 != 13) {
                    coderResult = CoderResult.unmappableForLength(1);
                }
            } else {
                if (osName.indexOf("AIX") != -1 && this.docstate == 66) {
                    this.implReset();
                }
                int n3 = this.defaultMap;
                int n4 = 0;
                int n5 = 0;
                while (n5 < ctmap.length) {
                    if (ctmap[n3].canEncode(n2) && (n4 = this.getBytes(n3, n2)) != 0) {
                        if (n4 >> 24 == 36) {
                            coderResult = this.putDouble(byteBuffer, n4);
                            break;
                        }
                        coderResult = this.putSingle(byteBuffer, n4);
                        break;
                    }
                    n3 = n5++;
                }
                if (n4 == 0) {
                    coderResult = this.putUnicode(byteBuffer, n2);
                }
            }
            if (coderResult == null) continue;
            charBuffer.position(n);
            return coderResult;
        }
        return CoderResult.UNDERFLOW;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("ibm.charset.ct.jis");
            }
        });
        if (string != null) {
            int n = COMPOUND_TEXT_Encoder.findMap(9282);
            COMPOUND_TEXT_Encoder.ctmap[n] = new CTMap(9282, string, "\u00a0\uff60\uffa0\uffef");
        }
    }

    private static class CTMap {
        int state;
        String name;
        String range;
        boolean invalid = false;

        CTMap(int n, String string, String string2) {
            this.state = n << 16;
            this.name = string;
            this.range = string2;
            if (n == 0) {
                this.invalid = true;
            }
        }

        boolean canEncode(int n) {
            if (this.invalid) {
                return false;
            }
            if (n > this.range.charAt(this.range.length() - 1)) {
                return false;
            }
            for (int i = 0; i < this.range.length(); i += 2) {
                if (n < this.range.charAt(i)) {
                    return false;
                }
                if (n > this.range.charAt(i + 1)) continue;
                return true;
            }
            return false;
        }
    }
}

