/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.SingleByte;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.IBM1381;

public class IBM1115
extends Charset
implements HistoricallyNamedCharset {
    private static final char[] b2cSB;

    public IBM1115() {
        super("x-IBM1115", ExtendedCharsets.aliasesFor("x-IBM1115"));
    }

    @Override
    public String historicalName() {
        return "Cp1115";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof IBM1115;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new SingleByte.Decoder(this, b2cSB);
    }

    @Override
    public CharsetEncoder newEncoder() {
        IBM1381.initc2b();
        return new Encoder(this);
    }

    static {
        int n;
        b2cSB = new char[256];
        IBM1381.initb2c();
        for (n = 0; n < 128; ++n) {
            IBM1115.b2cSB[n] = IBM1381.b2cSB[n + 128];
        }
        for (n = 128; n < 256; ++n) {
            IBM1115.b2cSB[n] = IBM1381.b2cSB[n - 128];
        }
    }

    protected static class Encoder
    extends DoubleByte.Encoder {
        public Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f, new byte[]{63}, IBM1381.c2b, IBM1381.c2bIndex);
        }

        @Override
        public int encodeChar(char c) {
            int n = super.encodeChar(c);
            if (n > 255) {
                n = 65533;
            }
            return n;
        }
    }
}

