/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.j9;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.util.Iterator;

public class Memory {
    private IAbstractAddressSpace space = null;
    private int asid = 0;

    public Memory(IAbstractAddressSpace space) {
        Iterator ranges;
        this.space = space;
        if (null != space && (ranges = space.getMemoryRanges()).hasNext()) {
            MemoryRange firstRange = (MemoryRange)ranges.next();
            this.asid = firstRange.getAsid();
        }
    }

    public int bytesPerPointer() {
        return this.space.bytesPerPointer(this.asid);
    }

    public long findPattern(byte[] whatBytes, int alignment, long startFrom) {
        return this.space.findPattern(whatBytes, alignment, startFrom);
    }

    public byte getByteAt(long address) throws MemoryAccessException {
        return this.space.getByteAt(this.asid, address);
    }

    public int getBytesAt(long address, byte[] buffer) throws MemoryAccessException {
        return this.space.getBytesAt(this.asid, address, buffer);
    }

    public int getIntAt(long address) throws MemoryAccessException {
        return this.space.getIntAt(this.asid, address);
    }

    public long getLongAt(long address) throws MemoryAccessException {
        return this.space.getLongAt(this.asid, address);
    }

    public byte[] getMemoryBytes(long address, int size) {
        return this.space.getMemoryBytes(address, size);
    }

    public Iterator getMemoryRanges() {
        return this.space.getMemoryRanges();
    }

    public long getPointerAt(long address) throws MemoryAccessException {
        return this.space.getPointerAt(this.asid, address);
    }

    public short getShortAt(long address) throws MemoryAccessException {
        return this.space.getShortAt(this.asid, address);
    }

    public boolean isExecutable(long address) throws MemoryAccessException {
        return this.space.isExecutable(this.asid, address);
    }

    public boolean isReadOnly(long address) throws MemoryAccessException {
        return this.space.isReadOnly(this.asid, address);
    }

    public boolean isShared(long address) throws MemoryAccessException {
        return this.space.isShared(this.asid, address);
    }
}

