/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class ImageProcess
implements com.ibm.dtfj.image.ImageProcess {
    private Vector _runtimes = new Vector();
    private Vector _libraries = new Vector();
    private Vector _threads = new Vector();
    private int _pointerSize;
    private ImageModule _executable;
    private String _id;
    private String _commandLine;
    private Properties _environment;
    private com.ibm.dtfj.image.j9.ImageThread _currentThread;
    private long _faultingNativeID = 0L;
    private int _signalNumber = 0;
    private Exception _runtimeCheckFailure;
    private static final String JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE = "IBM_JAVA_COMMAND_LINE";
    private static String[] names = new String[]{"ZERO", "SIGHUP", "SIGINT", "SIGQUIT", "SIGILL", "SIGTRAP", "SIGABRT", "SIGEMT", "SIGFPE", "SIGKILL", "SIGBUS", "SIGSEGV", "SIGSYS", "SIGPIPE", "SIGALRM", "SIGTERM", "SIGUSR1", "SIGUSR2", "SIGCHLD", "SIGPWR", "SIGWINCH", "SIGURG/BREAK", "SIGPOLL/ABRT", "SIGSTOP", "SIGTSTP", "SIGCONT", "SIGTTIN", "SIGTTOU", "SIGVTALRM", "SIGPROF", "SIGXCPU", "SIGXFSZ", "SIGWAITING", "SIGLWP", "SIGAIO", "SIGFPE_DIV_BY_ZERO", "SIGFPE_INT_DIV_BY_ZERO", "SIGFPE_INT_OVERFLOW"};

    public ImageProcess(String pid, String commandLine, Properties environment, com.ibm.dtfj.image.j9.ImageThread currentThread, Iterator threads, ImageModule executable, Iterator libraries, int pointerSize) {
        this._id = pid;
        this._commandLine = commandLine;
        this._environment = environment;
        this.setCurrentThread(currentThread);
        this.setThreads(threads);
        this._executable = executable;
        while (libraries.hasNext()) {
            this._libraries.add(libraries.next());
        }
        this._pointerSize = pointerSize;
    }

    @Override
    public String getCommandLine() throws DataUnavailable, CorruptDataException {
        Properties environment = this.getEnvironment();
        String javaCommandLine = environment.getProperty(JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE);
        if (javaCommandLine != null) {
            return javaCommandLine;
        }
        if (this._commandLine == null) {
            throw new DataUnavailable("Command line unavailable from core dump");
        }
        return this._commandLine;
    }

    @Override
    public Properties getEnvironment() throws DataUnavailable, CorruptDataException {
        if (null == this._environment) {
            if (null == this._runtimeCheckFailure) {
                throw new DataUnavailable("Environment base address when core file parsed");
            }
            throw new CorruptDataException(new CorruptData("Environment not found due to:  " + this._runtimeCheckFailure.getMessage(), null));
        }
        return this._environment;
    }

    @Override
    public String getID() throws DataUnavailable, CorruptDataException {
        return this._id;
    }

    @Override
    public Iterator getLibraries() throws DataUnavailable, CorruptDataException {
        return this._libraries.iterator();
    }

    @Override
    public ImageModule getExecutable() throws DataUnavailable, CorruptDataException {
        if (null == this._executable) {
            throw new DataUnavailable("Executable image not found");
        }
        return this._executable;
    }

    @Override
    public Iterator getThreads() {
        return this._threads.iterator();
    }

    @Override
    public ImageThread getCurrentThread() throws CorruptDataException {
        com.ibm.dtfj.image.j9.ImageThread current = this._currentThread;
        if (0L != this._faultingNativeID) {
            Iterator threads = this.getThreads();
            while (threads.hasNext()) {
                com.ibm.dtfj.image.j9.ImageThread thread;
                Object next = threads.next();
                if (next instanceof CorruptData || Long.decode((thread = (com.ibm.dtfj.image.j9.ImageThread)next).getID()) != this._faultingNativeID) continue;
                current = thread;
                break;
            }
        }
        if (0L != this._faultingNativeID && null == current) {
            throw new CorruptDataException(new CorruptData("no current thread", null));
        }
        return current;
    }

    @Override
    public Iterator getRuntimes() {
        Iterator<Object> iter = null == this._runtimeCheckFailure ? this._runtimes.iterator() : Collections.singleton(new CorruptData("No runtimes due to early startup error:  " + this._runtimeCheckFailure.getMessage(), null)).iterator();
        return iter;
    }

    @Override
    public int getSignalNumber() throws DataUnavailable, CorruptDataException {
        int agreedSignal;
        int n = agreedSignal = null == this._currentThread ? 0 : this._currentThread.getSignal();
        if (0 != this._signalNumber) {
            agreedSignal = this._signalNumber;
        }
        return agreedSignal;
    }

    private String resolvePlatformName(int num) {
        if (num >= 0 && num < names.length) {
            return names[num];
        }
        return "Signal." + Integer.toString(num);
    }

    @Override
    public String getSignalName() throws DataUnavailable, CorruptDataException {
        if (0 == this.getSignalNumber()) {
            return null;
        }
        int num = this.getSignalNumber();
        return this.resolvePlatformName(num);
    }

    @Override
    public int getPointerSize() {
        return this._pointerSize;
    }

    public void addRuntime(JavaRuntime vm) {
        this._runtimes.add(vm);
    }

    public void setFaultingThreadID(long nativeID) {
        this._faultingNativeID = nativeID;
    }

    public void setSignalNumber(int signalNumber) {
        this._signalNumber = signalNumber;
    }

    public void runtimeExtractionFailed(Exception e) {
        this._runtimeCheckFailure = e;
    }

    protected void setThreads(Iterator threads) {
        this._threads.clear();
        while (threads.hasNext()) {
            this._threads.add(threads.next());
        }
    }

    protected void setCurrentThread(com.ibm.dtfj.image.j9.ImageThread thread) {
        this._currentThread = thread;
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }
}

