/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaInstanceField;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import com.ibm.dtfj.java.j9.JavaStaticField;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Vector;

public class JavaClass
extends JavaAbstractClass {
    private long _superClassID;
    private String _className;
    private Vector _methods = new Vector();
    private Vector _fields = new Vector();
    private Vector _constantPoolClassRefs = new Vector();
    private Vector _constantPoolObjects = new Vector();
    private int _instanceSize;
    private String _fileName;

    public JavaClass(JavaRuntime vm, ImagePointer classPointer, long superClassID, String name, int instanceSize, long classLoaderID, int modifiers, int flagOffset, String fileName, ImagePointer objectID, int hashcodeSlot) {
        super(vm, classPointer, modifiers, classLoaderID, objectID, flagOffset, hashcodeSlot);
        this._superClassID = superClassID;
        this._className = name;
        this._instanceSize = instanceSize;
        this._fileName = fileName;
    }

    @Override
    public String getName() throws CorruptDataException {
        return this._className;
    }

    @Override
    public com.ibm.dtfj.java.JavaClass getSuperclass() throws CorruptDataException {
        if (this._superClassID == 0L) {
            return null;
        }
        if (Modifier.isInterface(this.getModifiers())) {
            return null;
        }
        com.ibm.dtfj.java.JavaClass ret = this._javaVM.getClassForID(this._superClassID);
        if (ret == null) {
            throw new CorruptDataException(new CorruptData("Unknown superclass ID " + this._superClassID, null));
        }
        return ret;
    }

    @Override
    public boolean isArray() throws CorruptDataException {
        return false;
    }

    @Override
    public com.ibm.dtfj.java.JavaClass getComponentType() throws CorruptDataException {
        throw new IllegalArgumentException("Only array types have component types");
    }

    @Override
    public Iterator getDeclaredFields() {
        return this._fields.iterator();
    }

    @Override
    public Iterator getDeclaredMethods() {
        return this._methods.iterator();
    }

    @Override
    public Iterator getConstantPoolReferences() {
        Iterator ids = this._constantPoolClassRefs.iterator();
        Vector<Object> allRefs = new Vector<Object>();
        while (ids.hasNext()) {
            long oneID = (Long)ids.next();
            Object toBeAdded = null;
            com.ibm.dtfj.java.JavaClass oneClass = this._javaVM.getClassForID(oneID);
            if (oneClass == null) {
                toBeAdded = new CorruptData("Unknown class in constant pool " + oneID, null);
            } else {
                try {
                    toBeAdded = oneClass.getObject();
                }
                catch (CorruptDataException e) {
                    toBeAdded = e.getCorruptData();
                }
                catch (Exception e) {
                    toBeAdded = new CorruptData(e.getMessage());
                }
            }
            allRefs.add(toBeAdded);
        }
        for (int i = 0; i < this._constantPoolObjects.size(); ++i) {
            try {
                long objectId = (Long)this._constantPoolObjects.get(i);
                if (objectId == 0L) continue;
                ImagePointer pointer = this._javaVM.pointerInAddressSpace(objectId);
                try {
                    JavaObject instance = this._javaVM.getObjectAtAddress(pointer);
                    allRefs.add(instance);
                }
                catch (IllegalArgumentException e) {
                    allRefs.add(new CorruptData(e.getMessage(), pointer));
                }
                continue;
            }
            catch (CorruptDataException e) {
                allRefs.add(e.getCorruptData());
            }
        }
        return allRefs.iterator();
    }

    public void addConstantPoolClassRef(long id) {
        if (0L != id) {
            this._constantPoolClassRefs.add(id);
        }
    }

    @Override
    public int getInstanceSize(JavaObject instance) {
        return this._instanceSize;
    }

    public String getFilename() throws DataUnavailable, CorruptDataException {
        if (this._fileName != null) {
            return this._fileName;
        }
        throw new DataUnavailable();
    }

    public void createNewField(String name, String sig, int modifiers, int offset, long classID) {
        if (this.getID().getAddress() == classID) {
            JavaInstanceField field = new JavaInstanceField(this._javaVM, name, sig, modifiers, offset, classID);
            this._fields.add(field);
        }
    }

    public JavaMethod createNewMethod(long id, String name, String signature, int modifiers) {
        JavaMethod method = new JavaMethod(this._javaVM.pointerInAddressSpace(id), name, signature, modifiers, this);
        this._javaVM.addMethodForID(method, id);
        this._methods.add(method);
        return method;
    }

    public void createConstantPoolObjectRef(long id) {
        this._constantPoolObjects.add(id);
    }

    public void createNewStaticField(String name, String sig, int modifiers, String value) {
        JavaStaticField newStatic = new JavaStaticField(this._javaVM, name, sig, modifiers, value, this.getID().getAddress());
        this._fields.add(newStatic);
    }

    public String toString() {
        return this._className + "@" + Long.toHexString(this._classPointer.getAddress());
    }

    @Override
    public Iterator getReferences() {
        Vector<Object> references = new Vector<Object>();
        JavaReference jRef = null;
        Iterator constantPoolIt = this.getConstantPoolReferences();
        while (constantPoolIt.hasNext()) {
            Object cpObject = constantPoolIt.next();
            if (cpObject instanceof JavaObject) {
                jRef = new JavaReference(this._javaVM, (Object)this, cpObject, "Constant Pool Object", 9, 0, 1);
            } else if (cpObject instanceof JavaClass) {
                JavaClass jClass = (JavaClass)cpObject;
                jRef = new JavaReference(this._javaVM, (Object)this, jClass, "Constant Pool Class", 9, 0, 1);
            }
            if (null == jRef) continue;
            references.add(jRef);
        }
        Iterator declaredFieldIt = this.getDeclaredFields();
        while (declaredFieldIt.hasNext()) {
            JavaField jField = (JavaField)declaredFieldIt.next();
            if (!(jField instanceof JavaStaticField)) continue;
            JavaStaticField sField = (JavaStaticField)jField;
            try {
                Object obj = sField.getReferenceType(null);
                if (null == obj || !(obj instanceof JavaObject)) continue;
                String fieldName = sField.getName();
                String description = "Static field";
                if (null != fieldName) {
                    description = description + " [field name:" + fieldName + "]";
                }
                JavaObject jObject = (JavaObject)obj;
                jRef = new JavaReference(this._javaVM, (Object)this, jObject, description, 8, 0, 1);
                references.add(jRef);
            }
            catch (CorruptDataException e) {
                references.add(e.getCorruptData());
            }
            catch (MemoryAccessException e) {
                ImagePointer ptrInError = e.getPointer();
                String message = e.getMessage();
                references.add(new CorruptData(message, ptrInError));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.addSuperclassReference(references);
        this.addClassLoaderReference(references);
        this.addClassObjectReference(references);
        return references.iterator();
    }

    public boolean isAncestorOf(com.ibm.dtfj.java.JavaClass theClass) {
        if (null == theClass) {
            return false;
        }
        if (this.equals(theClass)) {
            return true;
        }
        try {
            return this.isAncestorOf(theClass.getSuperclass());
        }
        catch (CorruptDataException cde) {
            return false;
        }
    }

    @Override
    public long getInstanceSize() throws CorruptDataException {
        return this._instanceSize;
    }
}

