/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.framework.scanner;

import com.ibm.dtfj.javacore.parser.framework.input.IInputBuffer;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.scanner.IScanner;
import com.ibm.dtfj.javacore.parser.framework.scanner.ScannerException;
import com.ibm.dtfj.javacore.parser.framework.scanner.TokenManager;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import java.io.IOException;
import java.util.ArrayList;

public class JavaCoreScanner
implements IScanner {
    private IInputBuffer fInputBuffer;
    private StringBuffer fLocalCache;
    private int fLineNumber;
    private String fUnknownType;
    private String fUnparsedType;
    private J9TagManager fTagManager;
    private int fMaxLineLength;
    private ArrayList fTokenCache;
    private static final short SEPARATE_ON_WHITESPACE = 1;
    private static final short GRAB_ALL = 2;

    public JavaCoreScanner(IInputBuffer inputBuffer, J9TagManager tagManager) {
        this.fTagManager = tagManager;
        this.fUnknownType = "UNKNOWN_TAG";
        this.fUnparsedType = "UNPARSED";
        this.fInputBuffer = inputBuffer;
        this.fLocalCache = new StringBuffer();
        this.fLineNumber = 0;
        this.fTokenCache = new ArrayList();
        this.fMaxLineLength = 32768;
    }

    @Override
    public IParserToken next() throws IOException, ScannerException {
        IParserToken token = null;
        if (this.fTokenCache.isEmpty()) {
            this.fillTokenCache();
        }
        if (this.fTokenCache.size() > 0) {
            token = (IParserToken)this.fTokenCache.remove(0);
        }
        return token;
    }

    private void fillTokenCache() throws IOException, ScannerException {
        this.readNextLine();
        boolean done = false;
        while (!done && !this.fInputBuffer.endReached()) {
            this.clear(this.fLocalCache);
            this.nextCharacterSequence(1, this.fLocalCache);
            if (this.fLocalCache.length() > 0) {
                if (this.fTagManager.isComment(this.fLocalCache)) {
                    this.consume(this.fLocalCache);
                    if (this.moreLeftInLine()) {
                        this.nextCharacterSequence(2, this.fLocalCache);
                        this.consume(this.fLocalCache);
                    }
                    this.readNextLine();
                    continue;
                }
                this.processTag();
                done = true;
                continue;
            }
            if (this.moreLeftInLine()) {
                this.consume(1);
            }
            this.readNextLine();
        }
    }

    private boolean readNextLine() throws IOException {
        boolean result = false;
        if (this.fInputBuffer.length() == 0 && (result = this.fInputBuffer.nextLine())) {
            ++this.fLineNumber;
        }
        return result;
    }

    private int consume(StringBuffer buffer) throws IOException {
        int offset = this.consume(buffer.length());
        this.clear(buffer);
        return offset;
    }

    private int consume(int length) throws IOException {
        return this.fInputBuffer.consume(length);
    }

    private boolean moreLeftInLine() {
        return this.fInputBuffer.length() > 0;
    }

    private void processTag() throws IOException, ScannerException {
        String value = this.fLocalCache.toString();
        String tokenType = this.fTagManager.hasTag(value) ? value : this.fUnknownType;
        int lengthConsumed = value.length();
        int offset = this.consume(this.fLocalCache);
        this.fTokenCache.add(TokenManager.getToken(lengthConsumed, offset, this.fLineNumber, tokenType, value));
        if (this.moreLeftInLine()) {
            tokenType = this.fUnparsedType;
            this.nextCharacterSequence(2, this.fLocalCache);
            value = this.fLocalCache.toString();
            lengthConsumed = this.fLocalCache.length();
            this.consume(this.fLocalCache);
            this.fTokenCache.add(TokenManager.getToken(lengthConsumed, offset, this.fLineNumber, tokenType, value));
        }
    }

    private void nextCharacterSequence(int whiteSpaceOption, StringBuffer targetBuffer) throws ScannerException {
        int copiedWhiteSpaceOption = whiteSpaceOption;
        copiedWhiteSpaceOption &= 0xFFFFFFFE;
        int length = this.fInputBuffer.length();
        for (int i = 0; i < length && (copiedWhiteSpaceOption & 1) == 0; ++i) {
            char nextCharacter = this.fInputBuffer.charAt(i);
            if (Character.isWhitespace(nextCharacter) && (whiteSpaceOption & 1) == 1) {
                copiedWhiteSpaceOption |= 1;
            } else {
                targetBuffer.append(nextCharacter);
            }
            if (i <= this.fMaxLineLength) continue;
            throw new ScannerException("Maximum line length (" + this.fMaxLineLength + ") exceeded. Input file corrupt or not a javacore.");
        }
    }

    private void clear(StringBuffer buffer) {
        buffer.delete(0, buffer.length());
    }

    @Override
    public boolean allTokensGenerated() {
        return this.fInputBuffer.endReached() && this.fTokenCache.isEmpty();
    }

    public void setMaximumLineLength(int maxLength) {
        this.fMaxLineLength = maxLength;
    }

    public int getMaximumLineLength() {
        return this.fMaxLineLength;
    }
}

