/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.Container;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Entry {
    protected static final Logger logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
    public static final String FILE_EXT_JAR = ".jar";
    public static final String FILE_EXT_CLASS = ".class";
    private final String name;
    private long lastModified = -1L;
    private long size = -1L;
    private Container parent = null;
    private URL url = null;
    protected File file = null;
    protected Object data = null;

    public Entry(String name) {
        this.name = name;
    }

    public Entry(String name, File file) {
        this(name);
        this.file = file;
        if (file != null) {
            this.size = file.length();
            this.lastModified = file.lastModified();
        }
    }

    public Entry(File file) {
        this(file != null ? file.getName() : "root", file);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public Container getParent() {
        return this.parent;
    }

    public URL toURL() {
        if (this.url == null) {
            if (this.file != null) {
                try {
                    this.url = this.file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    logger.log(Level.FINE, "Exception thrown when constructing URL from file name " + this.file.getAbsolutePath());
                }
            } else if (this.parent != null && this.parent.getName().endsWith(FILE_EXT_JAR)) {
                String jarPath = this.parent.getFile().getAbsolutePath();
                try {
                    this.url = new URL("jar:file:" + jarPath + "!/" + this.name);
                }
                catch (MalformedURLException e) {
                    logger.log(Level.FINE, "Exception thrown when constructing URL from jar file name " + jarPath + " and class file name " + this.name);
                }
            }
        }
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public boolean hasChanged(Entry previous) {
        if (this.file != null ? previous.file == null : !this.name.equals(previous.name)) {
            return false;
        }
        return this.size != previous.size || this.lastModified != previous.lastModified;
    }

    public boolean hasChanged(File previous) {
        if (this.file == null) {
            return true;
        }
        if (this.file.equals(previous)) {
            return this.size != previous.length() || this.lastModified != previous.lastModified();
        }
        return true;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Entry)) {
            return false;
        }
        Entry compareTo = (Entry)o;
        return this.name.equals(compareTo.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (this.file == null) {
            return this.name;
        }
        return this.name + " loaded from " + this.file.getAbsolutePath();
    }
}

