/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.JavaRuntimeMemorySection;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.JavaVMOption;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoMemoryCommand
extends BaseJdmpviewCommand {
    private static final String COM_IBM_DBGMALLOC_PROPERTY = "-Dcom.ibm.dbgmalloc=true";

    public InfoMemoryCommand() {
        this.addCommand("info memory", "", "Provides information about the native memory usage in the Java Virtual Machine");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        JavaRuntime runtime = this.ctx.getRuntime();
        try {
            Iterator memoryCategories = runtime.getMemoryCategories();
            this.printAllMemoryCategories(out, memoryCategories);
            this.printDbgmallocWarning(out, runtime);
        }
        catch (DataUnavailable du) {
            out.println("Memory categories information unavailable.");
            this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), du);
        }
    }

    private void printDbgmallocWarning(PrintStream out, JavaRuntime runtime) {
        try {
            boolean dbgmalloc = false;
            JavaVMInitArgs args = runtime.getJavaVMInitArgs();
            if (args != null) {
                Iterator opts = args.getOptions();
                while (opts.hasNext()) {
                    JavaVMOption opt;
                    Object obj = opts.next();
                    if (!(obj instanceof JavaVMOption) || !COM_IBM_DBGMALLOC_PROPERTY.equals((opt = (JavaVMOption)obj).getOptionString())) continue;
                    dbgmalloc = true;
                }
            }
            if (!dbgmalloc) {
                out.println();
                out.printf("Note: %s was not found in the Java VM init options.\nMemory allocated by some class library components will not have been recorded.\n", COM_IBM_DBGMALLOC_PROPERTY);
            }
        }
        catch (DataUnavailable du) {
            out.println("Java VM init options information unavailable.");
            this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), du);
        }
        catch (CorruptDataException cde) {
            out.println("Corrupt Data encountered walking Java VM init options");
            this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), cde);
        }
    }

    private void printAllMemoryCategories(PrintStream out, Iterator<?> memoryCategories) {
        try {
            while (memoryCategories.hasNext()) {
                Object obj = memoryCategories.next();
                if (!(obj instanceof JavaRuntimeMemoryCategory)) continue;
                JavaRuntimeMemoryCategory category = (JavaRuntimeMemoryCategory)obj;
                LinkedList<Integer> stack = new LinkedList<Integer>();
                int childCount = InfoMemoryCommand.countPrintableChildren(category);
                stack.addLast(childCount);
                this.printCategory(category, stack, out);
            }
        }
        catch (CorruptDataException cde) {
            out.println("Corrupt Data encountered walking memory categories");
            this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), cde);
        }
    }

    private void printCategory(JavaRuntimeMemoryCategory category, LinkedList<Integer> stack, PrintStream out) {
        int depth = stack.size() - 1;
        try {
            if (category.getShallowBytes() > 0L || category.getDeepBytes() > 0L) {
                InfoMemoryCommand.indentToDepth(new String[]{"|  ", "|  ", "   "}, stack, out, depth);
                if (depth > 0) {
                    out.println();
                }
                InfoMemoryCommand.indentToDepth(new String[]{"+--", "|  ", "   "}, stack, out, depth);
                out.printf("%s: %d bytes / %d allocations\n", category.getName(), category.getDeepBytes(), category.getDeepAllocations());
                if (category.getDeepBytes() > category.getShallowBytes()) {
                    Iterator memoryCategories = category.getChildren();
                    JavaRuntimeMemoryCategory other = InfoMemoryCommand.getOtherCategory(category);
                    while (memoryCategories.hasNext()) {
                        int parentCount = stack.get(depth);
                        stack.set(depth, --parentCount);
                        Object obj = memoryCategories.next();
                        if (!(obj instanceof JavaRuntimeMemoryCategory)) continue;
                        JavaRuntimeMemoryCategory next = (JavaRuntimeMemoryCategory)obj;
                        int childCount = InfoMemoryCommand.countPrintableChildren(next);
                        stack.addLast(childCount);
                        this.printCategory(next, stack, out);
                        stack.removeLast();
                    }
                    if (other != null) {
                        stack.addLast(0);
                        this.printCategory(other, stack, out);
                        stack.removeLast();
                    }
                }
            }
        }
        catch (CorruptDataException cde) {
            out.println("Corrupt Data encountered walking memory categories");
            this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), cde);
        }
    }

    private static int countPrintableChildren(JavaRuntimeMemoryCategory category) throws CorruptDataException {
        int children = 0;
        if (category.getDeepBytes() > category.getShallowBytes()) {
            Iterator memoryCategories = category.getChildren();
            while (memoryCategories.hasNext()) {
                JavaRuntimeMemoryCategory next;
                Object obj = memoryCategories.next();
                if (!(obj instanceof JavaRuntimeMemoryCategory) || (next = (JavaRuntimeMemoryCategory)obj).getShallowBytes() <= 0L && next.getDeepBytes() <= 0L) continue;
                ++children;
            }
        }
        if (category.getShallowAllocations() > 0L) {
            ++children;
        }
        return children;
    }

    private static JavaRuntimeMemoryCategory getOtherCategory(final JavaRuntimeMemoryCategory category) throws CorruptDataException {
        if (category.getShallowAllocations() == 0L) {
            return null;
        }
        JavaRuntimeMemoryCategory other = new JavaRuntimeMemoryCategory(){

            public long getShallowBytes() throws CorruptDataException {
                return 0L;
            }

            public long getShallowAllocations() throws CorruptDataException {
                return 0L;
            }

            public String getName() throws CorruptDataException {
                return "Other";
            }

            public Iterator<JavaRuntimeMemorySection> getMemorySections(boolean includeFreed) throws CorruptDataException, DataUnavailable {
                return null;
            }

            public long getDeepBytes() throws CorruptDataException {
                return category.getShallowBytes();
            }

            public long getDeepAllocations() throws CorruptDataException {
                return category.getShallowAllocations();
            }

            public Iterator<JavaRuntimeMemoryCategory> getChildren() throws CorruptDataException {
                return new Iterator<JavaRuntimeMemoryCategory>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public JavaRuntimeMemoryCategory next() {
                        return null;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        return other;
    }

    private static void indentToDepth(String[] indents, LinkedList<Integer> stack, PrintStream out, int depth) {
        for (int i = 0; i < depth; ++i) {
            if (i == depth - 1) {
                out.print(indents[0]);
                continue;
            }
            if (stack.get(i) > 0) {
                out.print(indents[1]);
                continue;
            }
            out.print(indents[2]);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("outputs a tree of native memory usage by each component in the Java Virtual Machine \n\nparameters: none\n");
    }
}

