/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import com.ibm.jvm.dtfjview.commands.xcommands.XCommand;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class XDCommand
extends XCommand {
    public XDCommand() {
        this.addCommand("x/d", "<hex address>", "displays the integer at the specified address");
    }

    @Override
    public boolean recognises(String command, IContext context) {
        if (super.recognises(command, context)) {
            return command.toLowerCase().endsWith("d");
        }
        return false;
    }

    @Override
    public void doCommand(String[] args) {
        String param = args[0];
        Long address = Utils.longFromStringWithPrefix(param);
        if (null == address) {
            this.out.println("invalid hex address specified; address must be specified as \"0x<hex_address>\"");
            return;
        }
        this.out.print("\n");
        boolean found = false;
        for (int index = 0; index < this.argUnitNumber; ++index) {
            long currAddr = address + (long)(index * this.argUnitSize);
            this.out.print("\t");
            this.out.print(Utils.toHex(currAddr));
            this.out.print(": ");
            ImageAddressSpace ias = this.ctx.getAddressSpace();
            ImagePointer ip = ias.getPointer(currAddr);
            byte b = 0;
            short s = 0;
            int i = 0;
            long l = 0L;
            try {
                switch (this.argUnitSize) {
                    case 1: {
                        b = ip.getByteAt(0L);
                        break;
                    }
                    case 2: {
                        s = ip.getShortAt(0L);
                        break;
                    }
                    case 4: {
                        i = ip.getIntAt(0L);
                        break;
                    }
                    case 8: {
                        l = ip.getLongAt(0L);
                    }
                }
                found = true;
            }
            catch (CorruptDataException e) {
                found = false;
            }
            catch (MemoryAccessException e) {
                found = false;
            }
            if (found) {
                switch (this.argUnitSize) {
                    case 1: {
                        this.out.print(Byte.toString(b));
                        break;
                    }
                    case 2: {
                        this.out.print(Short.toString(s));
                        break;
                    }
                    case 4: {
                        this.out.print(Integer.toString(i));
                        break;
                    }
                    case 8: {
                        this.out.print(Long.toString(l));
                    }
                }
            }
            this.out.print("\n");
        }
        if (!found) {
            this.out.print("<address not found in any address space>");
        }
        this.out.print("\n");
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        super.printDetailedHelp(out);
        out.println("displays the integer at the specified address\n\nparameters: 0x<addr>\n\nDisplays the integer at the specified address, adjusted for the endianness of the architecture this dump file is from.\n\nNote: This command uses the number of items and unit size passed to it by the \"x/\" command.\n");
    }
}

