/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools;

import com.ibm.jvm.dtfjview.Session;
import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.ITool;
import com.ibm.jvm.dtfjview.tools.ParsedCommand;
import com.ibm.jvm.dtfjview.tools.ToolsRegistryOutputChannels;
import com.ibm.jvm.dtfjview.tools.impl.CharsFromTool;
import com.ibm.jvm.dtfjview.tools.impl.CharsToTool;
import com.ibm.jvm.dtfjview.tools.impl.CmdFileTool;
import com.ibm.jvm.dtfjview.tools.impl.GrepTool;
import com.ibm.jvm.dtfjview.tools.impl.HelpTool;
import com.ibm.jvm.dtfjview.tools.impl.HistoryTool;
import com.ibm.jvm.dtfjview.tools.impl.OutFileTool;
import com.ibm.jvm.dtfjview.tools.impl.TokensTool;
import com.ibm.jvm.dtfjview.tools.utils.StringReceiver;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ToolsRegistry {
    private List<ITool> toolList;
    private HistoryTool history;
    private Session session;
    private String charsetName;
    private static ToolsRegistry registry = null;

    public static void initialize(Session session) {
        ToolsRegistryOutputChannels.initialize(session.getCharset());
        if (null == registry) {
            registry = new ToolsRegistry(session);
            registry.initializeTools();
        }
    }

    public static void recordAndExecute(String command) throws CommandException {
        if (null != command && 0 < command.trim().length()) {
            try {
                ToolsRegistry.execute(command);
            }
            finally {
                ToolsRegistry.registry.history.record(command);
            }
        }
    }

    public static void execute(String command) throws CommandException {
        ParsedCommand parsedCommand = ParsedCommand.parse(command);
        ToolsRegistry.execute(parsedCommand.getCommand(), parsedCommand.getArguments());
    }

    public static void execute(String command, String[] args) throws CommandException {
        PrintStream out = ToolsRegistryOutputChannels.newPrintStream();
        for (ITool tool : ToolsRegistry.registry.toolList) {
            if (!tool.accept(command, args)) continue;
            tool.process(command, args, out);
            return;
        }
        ToolsRegistry.executeJdmpviewCommand(new ParsedCommand(command, args).getCombinedCommandLine(), out);
    }

    public static void process(String command, PrintStream out) throws CommandException {
        ParsedCommand parsedCommand = ParsedCommand.parse(command);
        ToolsRegistry.process(parsedCommand.getCommand(), parsedCommand.getArguments(), out);
    }

    public static String process(String command) throws CommandException {
        ParsedCommand parsedCommand = ParsedCommand.parse(command);
        return ToolsRegistry.process(parsedCommand.getCommand(), parsedCommand.getArguments());
    }

    public static void process(String command, String[] args, PrintStream out) throws CommandException {
        for (ITool tool : ToolsRegistry.registry.toolList) {
            if (!tool.accept(command, args)) continue;
            tool.process(command, args, out);
            return;
        }
        ToolsRegistry.executeJdmpviewCommand(new ParsedCommand(command, args).getCombinedCommandLine(), out);
    }

    public static String process(String command, String[] args) throws CommandException {
        StringReceiver receiver = new StringReceiver(ToolsRegistry.registry.charsetName);
        ToolsRegistry.process(command, args, new PrintStream(receiver));
        try {
            return receiver.release();
        }
        catch (UnsupportedEncodingException e) {
            throw new CommandException(e);
        }
    }

    public static void executeJdmpviewCommand(String jdmpviewCommand, PrintStream out) {
        ToolsRegistry.registry.session.execute(jdmpviewCommand, out);
    }

    public static boolean isPipeLineEnabled(String command, String[] args) {
        for (ITool tool : ToolsRegistry.registry.toolList) {
            if (!tool.accept(command, args) || !(tool instanceof IPipe)) continue;
            return true;
        }
        return false;
    }

    public static void registerTool(ITool tool) {
        ToolsRegistry.registry.toolList.add(tool);
    }

    public static List<ITool> getAllTools() {
        return ToolsRegistry.registry.toolList;
    }

    private ToolsRegistry(Session session) {
        this.session = session;
        this.toolList = new ArrayList<ITool>();
        this.charsetName = session.getCharset();
    }

    private void initializeTools() {
        new HelpTool();
        this.history = new HistoryTool();
        new GrepTool();
        new CharsFromTool();
        new CharsToTool();
        new OutFileTool();
        new CmdFileTool(this.charsetName);
        new TokensTool();
    }
}

