/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.security.util.KeyUtil;
import com.ibm.security.util.Length;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

abstract class CKey
implements Key,
Length {
    private static final long serialVersionUID = -1088859394025049194L;
    protected final NativeHandles handles;
    protected final int keyLength;
    protected final String algorithm;

    protected CKey(String string, NativeHandles nativeHandles, int n) {
        this.algorithm = string;
        this.handles = nativeHandles;
        this.keyLength = n;
    }

    private static native void cleanUp(long var0, long var2);

    public int length() {
        return this.keyLength;
    }

    public long getHCryptKey() {
        return this.handles.hCryptKey;
    }

    public long getHCryptProvider() {
        return this.handles.hCryptProv;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    protected static native String getContainerName(long var0);

    protected static native String getKeyType(long var0);

    static byte[] generateECBlob(Key key) {
        int n = KeyUtil.getKeySize((Key)key);
        int n2 = (n + 7) / 8;
        boolean bl = key instanceof ECPrivateKey;
        byte[] byArray = new byte[8 + n2 * (bl ? 3 : 2)];
        byArray[0] = 69;
        byArray[1] = 67;
        byArray[2] = 83;
        byArray[3] = bl ? (byte)(n == 256 ? 50 : (n == 384 ? 52 : 54)) : (byte)(n == 256 ? 49 : (n == 384 ? 51 : 53));
        if (bl) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
            BigInteger bigInteger = eCPrivateKey.getS();
            byte[] byArray2 = bigInteger.toByteArray();
            System.arraycopy(byArray2, 0, byArray, 8 + n2 + n2 + n2 - byArray2.length, byArray2.length);
        } else {
            ECPublicKey eCPublicKey = (ECPublicKey)key;
            BigInteger bigInteger = eCPublicKey.getW().getAffineX();
            BigInteger bigInteger2 = eCPublicKey.getW().getAffineY();
            byte[] byArray3 = bigInteger2.toByteArray();
            System.arraycopy(byArray3, 0, byArray, 8 + n2 + n2 - byArray3.length, byArray3.length);
            byte[] byArray4 = bigInteger.toByteArray();
            System.arraycopy(byArray4, 0, byArray, 8 + n2 - byArray4.length, byArray4.length);
        }
        byArray[4] = (byte)n2;
        byArray[7] = 0;
        byArray[6] = 0;
        byArray[5] = 0;
        return byArray;
    }

    static class NativeHandles {
        long hCryptProv = 0L;
        long hCryptKey = 0L;

        public NativeHandles(long l, long l2) {
            this.hCryptProv = l;
            this.hCryptKey = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                NativeHandles nativeHandles = this;
                synchronized (nativeHandles) {
                    CKey.cleanUp(this.hCryptProv, this.hCryptKey);
                    this.hCryptProv = 0L;
                    this.hCryptKey = 0L;
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

