/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.capi.CKeyPair;
import com.ibm.security.capi.IBMCAC;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.UUID;

public abstract class CKeyPairGenerator
extends KeyPairGeneratorSpi {
    protected String keyAlg;

    public CKeyPairGenerator(String string) {
        this.keyAlg = string;
    }

    public static class RSA
    extends CKeyPairGenerator {
        static final int KEY_SIZE_MIN = 512;
        static final int KEY_SIZE_MAX = 16384;
        private static final int DEF_RSA_KEY_SIZE = 2048;
        private int keySize;

        public RSA() {
            super("RSA");
            this.initialize(2048, null);
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            try {
                RSAKeyFactory.checkKeyLengths((int)n, null, (int)512, (int)16384);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidParameterException(invalidKeyException.getMessage());
            }
            this.keySize = n;
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            int n;
            if (algorithmParameterSpec == null) {
                n = 2048;
            } else if (algorithmParameterSpec instanceof RSAKeyGenParameterSpec) {
                if (((RSAKeyGenParameterSpec)algorithmParameterSpec).getPublicExponent() != null) {
                    throw new InvalidAlgorithmParameterException("Exponent parameter is not supported");
                }
                n = ((RSAKeyGenParameterSpec)algorithmParameterSpec).getKeysize();
            } else {
                throw new InvalidAlgorithmParameterException("Params must be an instance of RSAKeyGenParameterSpec");
            }
            try {
                RSAKeyFactory.checkKeyLengths((int)n, null, (int)512, (int)16384);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidAlgorithmParameterException("Invalid Key sizes", invalidKeyException);
            }
            this.keySize = n;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CKeyPairGenerator: generateKeyPair");
            }
            try {
                CKeyPair cKeyPair = RSA.generateCKeyPair(this.keyAlg, this.keySize, "{" + UUID.randomUUID().toString() + "}");
                return new KeyPair(cKeyPair.getPublic(), cKeyPair.getPrivate());
            }
            catch (KeyException keyException) {
                throw new ProviderException(keyException);
            }
        }

        private static native CKeyPair generateCKeyPair(String var0, int var1, String var2) throws KeyException;
    }
}

