/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.capi.CKey;
import com.ibm.security.capi.CPrivateKey;
import com.ibm.security.capi.CPublicKey;
import com.ibm.security.capi.IBMCAC;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.KeyUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Locale;

abstract class CSignature
extends SignatureSpi {
    protected String keyAlgorithm;
    protected MessageDigest messageDigest;
    protected String messageDigestAlgorithm;
    protected boolean needsReset;
    protected CPrivateKey privateKey = null;
    protected CPublicKey publicKey = null;

    CSignature(String string, String string2) {
        this.keyAlgorithm = string;
        if (string2 != null) {
            try {
                this.messageDigest = MessageDigest.getInstance(string2);
                this.messageDigestAlgorithm = this.messageDigest.getAlgorithm();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ProviderException(noSuchAlgorithmException);
            }
        } else {
            this.messageDigest = null;
            this.messageDigestAlgorithm = null;
        }
        this.needsReset = false;
    }

    static native byte[] signCngHash(int var0, byte[] var1, int var2, int var3, String var4, long var5, long var7) throws SignatureException;

    private static native boolean verifyCngSignedHash(int var0, byte[] var1, int var2, byte[] var3, int var4, int var5, String var6, long var7, long var9) throws SignatureException;

    protected void resetDigest() {
        if (this.needsReset) {
            if (this.messageDigest != null) {
                this.messageDigest.reset();
            }
            this.needsReset = false;
        }
    }

    protected byte[] getDigestValue() throws SignatureException {
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    protected void setDigestName(String string) {
        this.messageDigestAlgorithm = string;
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.messageDigest.update(by);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.messageDigest.update(byArray, n, n2);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.messageDigest.update(byteBuffer);
        this.needsReset = true;
    }

    private static byte[] convertEndianArray(byte[] byArray) {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "CSignature: convertEndianArray");
        }
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        return byArray2;
    }

    private static native byte[] signHash(boolean var0, byte[] var1, int var2, String var3, long var4, long var6) throws SignatureException;

    private static native boolean verifySignedHash(byte[] var0, int var1, String var2, byte[] var3, int var4, long var5, long var7) throws SignatureException;

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No parameter accepted");
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    static native CPublicKey importPublicKey(String var0, byte[] var1, int var2) throws KeyStoreException;

    static native CPublicKey importECPublicKey(String var0, byte[] var1, int var2) throws KeyStoreException;

    public static final class PSS
    extends RSA {
        private PSSParameterSpec pssParams = null;
        private Signature fallbackSignature;

        public PSS() {
            super(null);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$PSS: engineInitSign");
            }
            super.engineInitSign(privateKey);
            this.fallbackSignature = null;
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            if (publicKey == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(publicKey instanceof RSAPublicKey)) {
                throw new InvalidKeyException("Key type not supported: " + publicKey.getClass());
            }
            this.privateKey = null;
            if (publicKey instanceof CPublicKey) {
                this.fallbackSignature = null;
                this.publicKey = (CPublicKey)publicKey;
            } else {
                if (this.fallbackSignature == null) {
                    try {
                        this.fallbackSignature = Signature.getInstance("RSAPSS", "IBMJCE");
                    }
                    catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
                        throw new InvalidKeyException("Invalid key", generalSecurityException);
                    }
                }
                this.fallbackSignature.initVerify(publicKey);
                if (this.pssParams != null) {
                    try {
                        this.fallbackSignature.setParameter(this.pssParams);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        throw new InvalidKeyException("Invalid params", invalidAlgorithmParameterException);
                    }
                }
                this.publicKey = null;
            }
            this.resetDigest();
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            this.ensureInit();
            if (this.fallbackSignature != null) {
                this.fallbackSignature.update(by);
            } else {
                this.messageDigest.update(by);
            }
            this.needsReset = true;
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            this.ensureInit();
            if (this.fallbackSignature != null) {
                this.fallbackSignature.update(byArray, n, n2);
            } else {
                this.messageDigest.update(byArray, n, n2);
            }
            this.needsReset = true;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            try {
                this.ensureInit();
            }
            catch (SignatureException signatureException) {
                throw new RuntimeException(signatureException.getMessage());
            }
            if (this.fallbackSignature != null) {
                try {
                    this.fallbackSignature.update(byteBuffer);
                }
                catch (SignatureException signatureException) {
                    throw new RuntimeException(signatureException.getMessage());
                }
            } else {
                this.messageDigest.update(byteBuffer);
            }
            this.needsReset = true;
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$PSS: engineSign");
            }
            byte[] byArray = null;
            this.ensureInit();
            byte[] byArray2 = this.getDigestValue();
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$PSS: signCngHash");
                System.out.println("                     hash: " + byArray2.toString());
                System.out.println("                     hash.length: " + byArray2.length);
                System.out.println("                     messageDigestAlgorithm: " + this.messageDigestAlgorithm);
                System.out.println("                     privateKey: " + this.privateKey.toString());
                System.out.println("                     HCryptProvider: " + this.privateKey.getHCryptProvider());
                System.out.println("                     HCryptKey: " + this.privateKey.getHCryptKey());
            }
            byArray = PSS.signCngHash(2, byArray2, byArray2.length, this.pssParams.getSaltLength(), ((MGF1ParameterSpec)this.pssParams.getMGFParameters()).getDigestAlgorithm(), this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
            if (IBMCAC.debug) {
                System.out.println("                     result: " + byArray.toString());
            }
            return byArray;
        }

        @Override
        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$PSS: engineVerify");
            }
            this.ensureInit();
            if (this.fallbackSignature != null) {
                this.needsReset = false;
                return this.fallbackSignature.verify(byArray);
            }
            byte[] byArray2 = this.getDigestValue();
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature: verifyCngSignedHash");
            }
            return CSignature.verifyCngSignedHash(2, byArray2, byArray2.length, byArray, byArray.length, this.pssParams.getSaltLength(), ((MGF1ParameterSpec)this.pssParams.getMGFParameters()).getDigestAlgorithm(), this.publicKey.getHCryptProvider(), this.publicKey.getHCryptKey());
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            if (this.needsReset) {
                throw new ProviderException("Cannot set parameters during operations");
            }
            this.pssParams = this.validateSigParams(algorithmParameterSpec);
            if (this.fallbackSignature != null) {
                this.fallbackSignature.setParameter(algorithmParameterSpec);
            }
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            AlgorithmParameters algorithmParameters = null;
            if (this.pssParams != null) {
                try {
                    algorithmParameters = AlgorithmParameters.getInstance("RSAPSS");
                    algorithmParameters.init(this.pssParams);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException(generalSecurityException.getMessage());
                }
            }
            return algorithmParameters;
        }

        private void ensureInit() throws SignatureException {
            if (this.privateKey == null && this.publicKey == null && this.fallbackSignature == null) {
                throw new SignatureException("Missing key");
            }
            if (this.pssParams == null) {
                throw new SignatureException("Parameters required for RSAPSS signatures");
            }
            if (this.fallbackSignature == null && this.messageDigest == null) {
                try {
                    this.messageDigest = MessageDigest.getInstance(this.pssParams.getDigestAlgorithm());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new SignatureException(noSuchAlgorithmException);
                }
            }
        }

        private PSSParameterSpec validateSigParams(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            String string;
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("Parameters cannot be null");
            }
            if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameters must be type PSSParameterSpec");
            }
            PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            if (pSSParameterSpec == this.pssParams) {
                return pSSParameterSpec;
            }
            if (!pSSParameterSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
                throw new InvalidAlgorithmParameterException("Only supports MGF1");
            }
            if (pSSParameterSpec.getTrailerField() != 1) {
                throw new InvalidAlgorithmParameterException("Only supports TrailerFieldBC(1)");
            }
            AlgorithmParameterSpec algorithmParameterSpec2 = pSSParameterSpec.getMGFParameters();
            if (!(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only support MGF1ParameterSpec");
            }
            MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)algorithmParameterSpec2;
            String string2 = pSSParameterSpec.getDigestAlgorithm().toLowerCase(Locale.ROOT).replaceAll("-", "");
            if (string2.equals("sha")) {
                string2 = "sha1";
            }
            if ((string = mGF1ParameterSpec.getDigestAlgorithm().toLowerCase(Locale.ROOT).replaceAll("-", "")).equals("sha")) {
                string = "sha1";
            }
            if (!string.equals(string2)) {
                throw new InvalidAlgorithmParameterException("MGF1 hash must be the same as message hash");
            }
            return pSSParameterSpec;
        }
    }

    static class ECDSA
    extends CSignature {
        public ECDSA(String string) {
            super("EC", string);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$ECDSA: engineInitSign");
            }
            if (privateKey == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(privateKey instanceof CPrivateKey) || !privateKey.getAlgorithm().equalsIgnoreCase("EC")) {
                if (IBMCAC.debug) {
                    System.out.println(IBMCAC.DEBUGHEADER + "ERROR: Key type is not com.ibm.security.capi.CPrivateKey$ECDSA");
                }
                throw new InvalidKeyException("Key type not supported: " + privateKey.getClass() + " " + privateKey.getAlgorithm());
            }
            this.privateKey = (CPrivateKey)privateKey;
            this.publicKey = null;
            this.resetDigest();
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            if (publicKey == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(publicKey instanceof ECPublicKey)) {
                throw new InvalidKeyException("Key type not supported: " + publicKey.getClass());
            }
            if (!(publicKey instanceof CPublicKey)) {
                try {
                    this.publicKey = ECDSA.importECPublicKey("EC", CKey.generateECBlob(publicKey), KeyUtil.getKeySize((Key)publicKey));
                }
                catch (KeyStoreException keyStoreException) {
                    throw new InvalidKeyException(keyStoreException);
                }
            } else {
                this.publicKey = (CPublicKey)publicKey;
            }
            this.privateKey = null;
            this.resetDigest();
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$ECDSA: engineSign");
            }
            byte[] byArray = this.getDigestValue();
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$ECDSA: signCngHash");
                System.out.println("                     hash: " + byArray.toString());
                System.out.println("                     hash.length: " + byArray.length);
                System.out.println("                     messageDigestAlgorithm: " + this.messageDigestAlgorithm);
                System.out.println("                     privateKey: " + this.privateKey.toString());
                System.out.println("                     HCryptProvider: " + this.privateKey.getHCryptProvider());
                System.out.println("                     HCryptKey: " + this.privateKey.getHCryptKey());
            }
            byte[] byArray2 = ECDSA.signCngHash(0, byArray, byArray.length, 0, null, this.privateKey.getHCryptProvider(), 0L);
            if (IBMCAC.debug) {
                System.out.println("                     result: " + byArray2.toString());
            }
            return ECDSA.encodeSignature(byArray2);
        }

        @Override
        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$ECDSA: engineVerify");
            }
            byte[] byArray2 = this.getDigestValue();
            byArray = ECDSA.decodeSignature(byArray);
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature: verifyCngSignedHash");
            }
            return CSignature.verifyCngSignedHash(0, byArray2, byArray2.length, byArray, byArray.length, 0, null, this.publicKey.getHCryptProvider(), 0L);
        }

        public static byte[] encodeSignature(byte[] byArray) throws SignatureException {
            try {
                int n = byArray.length >> 1;
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                BigInteger bigInteger = new BigInteger(1, byArray2);
                System.arraycopy(byArray, n, byArray2, 0, n);
                BigInteger bigInteger2 = new BigInteger(1, byArray2);
                DerOutputStream derOutputStream = new DerOutputStream(byArray.length + 10);
                derOutputStream.putInteger(bigInteger);
                derOutputStream.putInteger(bigInteger2);
                DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
                return derValue.toByteArray();
            }
            catch (Exception exception) {
                throw new SignatureException("Could not encode signature", exception);
            }
        }

        public static byte[] decodeSignature(byte[] byArray) throws SignatureException {
            try {
                DerInputStream derInputStream = new DerInputStream(byArray, 0, byArray.length, false);
                DerValue[] derValueArray = derInputStream.getSequence(2);
                if (derValueArray.length != 2 || derInputStream.available() != 0) {
                    throw new IOException("Invalid encoding for signature");
                }
                BigInteger bigInteger = derValueArray[0].getPositiveBigInteger();
                BigInteger bigInteger2 = derValueArray[1].getPositiveBigInteger();
                byte[] byArray2 = ECDSA.trimZeroes(bigInteger.toByteArray());
                byte[] byArray3 = ECDSA.trimZeroes(bigInteger2.toByteArray());
                int n = Math.max(byArray2.length, byArray3.length);
                byte[] byArray4 = new byte[n << 1];
                System.arraycopy(byArray2, 0, byArray4, n - byArray2.length, byArray2.length);
                System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
                return byArray4;
            }
            catch (Exception exception) {
                throw new SignatureException("Invalid encoding for signature", exception);
            }
        }

        public static byte[] trimZeroes(byte[] byArray) {
            int n;
            for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
            }
            if (n == 0) {
                return byArray;
            }
            return Arrays.copyOfRange(byArray, n, byArray.length);
        }
    }

    public static final class SHA512withECDSA
    extends ECDSA {
        public SHA512withECDSA() {
            super("SHA-512");
        }
    }

    public static final class SHA384withECDSA
    extends ECDSA {
        public SHA384withECDSA() {
            super("SHA-384");
        }
    }

    public static final class SHA256withECDSA
    extends ECDSA {
        public SHA256withECDSA() {
            super("SHA-256");
        }
    }

    public static final class SHA224withECDSA
    extends ECDSA {
        public SHA224withECDSA() {
            super("SHA-224");
        }
    }

    public static final class SHA1withECDSA
    extends ECDSA {
        public SHA1withECDSA() {
            super("SHA-1");
        }
    }

    public static final class MD2withRSA
    extends RSA {
        public MD2withRSA() {
            super("MD2");
        }
    }

    public static final class MD5withRSA
    extends RSA {
        public MD5withRSA() {
            super("MD5");
        }
    }

    public static final class SHA512withRSA
    extends RSA {
        public SHA512withRSA() {
            super("SHA-512");
        }
    }

    public static final class SHA384withRSA
    extends RSA {
        public SHA384withRSA() {
            super("SHA-384");
        }
    }

    public static final class SHA256withRSA
    extends RSA {
        public SHA256withRSA() {
            super("SHA-256");
        }
    }

    public static final class SHA1withRSA
    extends RSA {
        public SHA1withRSA() {
            super("SHA1");
        }
    }

    public static final class NONEwithRSA
    extends RSA {
        private static final int RAW_RSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset = 0;

        public NONEwithRSA() {
            super(null);
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            this.precomputedDigest[this.offset++] = by;
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            if (n2 > this.precomputedDigest.length - this.offset) {
                this.offset = 65;
                return;
            }
            System.arraycopy(byArray, n, this.precomputedDigest, this.offset, n2);
            this.offset += n2;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (n <= 0) {
                return;
            }
            if (n > this.precomputedDigest.length - this.offset) {
                this.offset = 65;
                return;
            }
            byteBuffer.get(this.precomputedDigest, this.offset, n);
            this.offset += n;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }

        @Override
        protected byte[] getDigestValue() throws SignatureException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$NONEwithRSA: getDigestValue");
            }
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            if (this.offset == 20) {
                this.setDigestName("SHA1");
            } else if (this.offset == 36) {
                this.setDigestName("SHA1+MD5");
            } else if (this.offset == 32) {
                this.setDigestName("SHA-256");
            } else if (this.offset == 48) {
                this.setDigestName("SHA-384");
            } else if (this.offset == 64) {
                this.setDigestName("SHA-512");
            } else if (this.offset == 16) {
                this.setDigestName("MD5");
            } else {
                throw new SignatureException("Message digest length is not supported");
            }
            byte[] byArray = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, byArray, 0, this.offset);
            this.offset = 0;
            return byArray;
        }
    }

    static class RSA
    extends CSignature {
        public RSA(String string) {
            super("RSA", string);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$RSA: engineInitSign");
            }
            if (privateKey == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(privateKey instanceof CPrivateKey) || !privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                if (IBMCAC.debug) {
                    System.out.println(IBMCAC.DEBUGHEADER + "ERROR: Key type is not com.ibm.security.capi.CPrivateKey$RSA");
                }
                throw new InvalidKeyException("Key type not supported: " + privateKey.getClass() + " " + privateKey.getAlgorithm());
            }
            this.privateKey = (CPrivateKey)privateKey;
            RSAKeyFactory.checkKeyLengths((int)(this.privateKey.length() + 7 & 0xFFFFFFF8), null, (int)512, (int)16384);
            this.publicKey = null;
            this.resetDigest();
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            if (publicKey == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(publicKey instanceof RSAPublicKey)) {
                throw new InvalidKeyException("Key type not supported: " + publicKey.getClass());
            }
            if (!(publicKey instanceof CPublicKey)) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
                BigInteger bigInteger = rSAPublicKey.getModulus();
                BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
                RSAKeyFactory.checkKeyLengths((int)(bigInteger.bitLength() + 7 & 0xFFFFFFF8), (BigInteger)bigInteger2, (int)-1, (int)16384);
                byte[] byArray = bigInteger.toByteArray();
                byte[] byArray2 = bigInteger2.toByteArray();
                int n = byArray[0] == 0 ? (byArray.length - 1) * 8 : byArray.length * 8;
                byte[] byArray3 = RSA.generatePublicKeyBlob(n, byArray, byArray2);
                try {
                    this.publicKey = RSA.importPublicKey("RSA", byArray3, n);
                }
                catch (KeyStoreException keyStoreException) {
                    throw new InvalidKeyException(keyStoreException);
                }
            } else {
                this.publicKey = (CPublicKey)publicKey;
            }
            this.privateKey = null;
            this.resetDigest();
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$RSA: engineSign");
            }
            byte[] byArray = null;
            byte[] byArray2 = this.getDigestValue();
            if (this.privateKey.getHCryptKey() == 0L) {
                if (IBMCAC.debug) {
                    System.out.println(IBMCAC.DEBUGHEADER + "CSignature$RSA: signCngHash");
                    System.out.println("                     hash: " + byArray2.toString());
                    System.out.println("                     hash.length: " + byArray2.length);
                    System.out.println("                     messageDigestAlgorithm: " + this.messageDigestAlgorithm);
                    System.out.println("                     privateKey: " + this.privateKey.toString());
                    System.out.println("                     HCryptProvider: " + this.privateKey.getHCryptProvider());
                    System.out.println("                     HCryptKey: " + this.privateKey.getHCryptKey());
                }
                byArray = RSA.signCngHash(1, byArray2, byArray2.length, 0, this instanceof NONEwithRSA ? null : this.messageDigestAlgorithm, this.privateKey.getHCryptProvider(), 0L);
                if (IBMCAC.debug) {
                    System.out.println("                     result: " + byArray.toString());
                }
                return byArray;
            }
            boolean bl = this instanceof NONEwithRSA;
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$RSA: signHash");
                System.out.println("                     noHashOID: " + bl);
                System.out.println("                     hash: " + byArray2.toString());
                System.out.println("                     hash.length: " + byArray2.length);
                System.out.println("                     messageDigestAlgorithm: " + this.messageDigestAlgorithm);
                System.out.println("                     privateKey: " + this.privateKey.toString());
                System.out.println("                     HCryptProvider: " + this.privateKey.getHCryptProvider());
                System.out.println("                     HCryptKey: " + this.privateKey.getHCryptKey());
            }
            byArray = CSignature.signHash(bl, byArray2, byArray2.length, this.messageDigestAlgorithm, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
            if (IBMCAC.debug) {
                System.out.println("                     result: " + byArray.toString());
            }
            return CSignature.convertEndianArray(byArray);
        }

        @Override
        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature$RSA: engineVerify");
            }
            byte[] byArray2 = this.getDigestValue();
            if (this.publicKey.getHCryptKey() == 0L) {
                if (IBMCAC.debug) {
                    System.out.println(IBMCAC.DEBUGHEADER + "CSignature: verifyCngSignedHash");
                }
                return CSignature.verifyCngSignedHash(1, byArray2, byArray2.length, byArray, byArray.length, 0, this.messageDigestAlgorithm, this.publicKey.getHCryptProvider(), 0L);
            }
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "CSignature: verifySignedHash");
            }
            return CSignature.verifySignedHash(byArray2, byArray2.length, this.messageDigestAlgorithm, CSignature.convertEndianArray(byArray), byArray.length, this.publicKey.getHCryptProvider(), this.publicKey.getHCryptKey());
        }

        static native byte[] generatePublicKeyBlob(int var0, byte[] var1, byte[] var2) throws InvalidKeyException;
    }
}

