/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.security.capi.CKey;
import com.ibm.security.capi.JarVerifierImpl;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.security.action.PutAllAction;

public final class IBMCAC
extends Provider {
    private static final long serialVersionUID = 8622598936488630849L;
    private static final String INFO = "IBM Crypto API for CAC JCE provider";
    static boolean debug = false;
    static String DEBUGHEADER = "IBMCAC-";
    private static volatile boolean integrityVerified;

    public IBMCAC() {
        super("IBMCAC", 1.8, INFO);
        Map<Object, Object> map = System.getSecurityManager() == null ? this : new HashMap();
        map.put("SecureRandom.Windows-PRNG", "com.ibm.security.capi.PRNG");
        map.put("KeyStore.Windows-MY", "com.ibm.security.capi.CKeyStore$MY");
        map.put("KeyStore.Windows-ROOT", "com.ibm.security.capi.CKeyStore$ROOT");
        map.put("KeyStore.WIExplorerMy", "com.ibm.security.capi.CKeyStore$MY");
        map.put("Signature.NONEwithRSA", "com.ibm.security.capi.CSignature$NONEwithRSA");
        map.put("Signature.RSAforSSL", "com.ibm.security.capi.CSignature$NONEwithRSA");
        map.put("Signature.SHA1withRSA", "com.ibm.security.capi.CSignature$SHA1withRSA");
        map.put("Signature.SHA256withRSA", "com.ibm.security.capi.CSignature$SHA256withRSA");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", "SHA256withRSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.11", "SHA256withRSA");
        map.put("Signature.SHA384withRSA", "com.ibm.security.capi.CSignature$SHA384withRSA");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.12", "SHA384withRSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.12", "SHA384withRSA");
        map.put("Signature.SHA512withRSA", "com.ibm.security.capi.CSignature$SHA512withRSA");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.13", "SHA512withRSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.13", "SHA512withRSA");
        map.put("Signature.MD5withRSA", "com.ibm.security.capi.CSignature$MD5withRSA");
        map.put("Signature.MD2withRSA", "com.ibm.security.capi.CSignature$MD2withRSA");
        map.put("Signature.RSAPSS", "com.ibm.security.capi.CSignature$PSS");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.10", "RSAPSS");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.10", "RSAPSS");
        map.put("Signature.NONEwithRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.RSAforSSL SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.SHA1withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.SHA256withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.SHA384withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.SHA512withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.MD5withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.MD2withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.RSAPSS SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.NONEwithRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.RSAforSSL SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA1withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA256withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA384withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA512withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.MD5withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.MD2withRSA SupportedKeyFormats", "MSCAPI");
        map.put("KeyPairGenerator.RSA", "com.ibm.security.capi.CKeyPairGenerator$RSA");
        map.put("KeyPairGenerator.RSA KeySize", "2048");
        map.put("Cipher.RSA", "com.ibm.security.capi.CRSACipher");
        map.put("Cipher.RSA/ECB/PKCS1Padding", "com.ibm.security.capi.CRSACipher");
        map.put("Cipher.RSA SupportedModes", "ECB");
        map.put("Cipher.RSA SupportedPaddings", "PKCS1PADDING");
        map.put("Cipher.RSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        if (map != this) {
            AccessController.doPrivileged(new PutAllAction(this, map));
        }
    }

    static void verifySelfIntegrity(Class clazz) {
        if (integrityVerified) {
            return;
        }
        IBMCAC.doVerifySelfIntegrity(clazz);
    }

    private static synchronized void doVerifySelfIntegrity(Class clazz) {
        integrityVerified = JarVerifierImpl.doVerification(clazz, "-----BEGIN CERTIFICATE-----\nMIIDVzCCAxWgAwIBAgIEQCFoGzALBgcqhkjOOAQDBQAwYDELMAkGA1UEBhMCVVMxGDAWBgNVBAoTD0lCTSBDb3Jwb3JhdGlvbjEZMBcGA1UECxMQSUJNIENvZGUgU2lnbmluZzEcMBoGA1UEAxMTSkNFIENvZGUgU2lnbmluZyBDQTAeFw0xODA1MDkxODE2NTBaFw0yNDA1MDcxODE2NTBaMGgxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9JQk0gQ29ycG9yYXRpb24xGTAXBgNVBAsTEElCTSBDb2RlIFNpZ25pbmcxJDAiBgNVBAMTG0lCTSBDb2RlIFNpZ25pbmcgLSBQcm92aWRlcjCCAbgwggEsBgcqhkjOOAQBMIIBHwKBgQD9f1OBHXUSKVLfSpwu7OTn9hG3UjzvRADDHj+AtlEmaUVdQCJR+1k9jVj6v8X1ujD2y5tVbNeBO4AdNG/yZmC3a5lQpaSfn+gEexAiwk+7qdf+t8Yb+DtX58aophUPBPuD9tPFHsMCNVQTWhaRMvZ1864rYdcq7/IiAxmd0UgBxwIVAJdgUI8VIwvMspK5gqLrhAvwWBz1AoGBAPfhoIXWmz3ey7yrXDa4V7l5lK+7+jrqgvlXTAs9B4JnUVlXjrrUWU/mcQcQgYC0SRZxI+hMKBYTt88JMozIpuE8FnqLVHyNKOCjrh4rs6Z1kW6jfwv6ITVi8ftiegEkO8yk8b6oUZCJqIPf4VrlnwaSi2ZegHtVJWQBTDv+z0kqA4GFAAKBgQCNJlh24PDu1Qy/3LQSKu9NAgQPTgETn4Uf2BXvAE6XvIRviEegg4WXtAZ3cF2maflCYFS6IyRewu9VD3aZwy6qZoKbeu1du/lEYdGEOftH3C7m6+CwwKWSMB3UEGyF1HS71NiDcEmVmKbsAaTQa8p1oHQa5mnnhbcXOWR4bqtOrKNTMFEwHwYDVR0jBBgwFoAUxNfMP3n5xnMAp4AiwoyVTZ9AdEowDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUxNfMP3n5xnMAp4AiwoyVTZ9AdEowCwYHKoZIzjgEAwUAAy8AMCwCFCRbp4EfB3oAQzBaJ/1k6UpfZ+agAhQFRtgMkQSWf0sG0OUxB4tEyGizGQ==\n-----END CERTIFICATE-----");
        if (!integrityVerified) {
            throw new ProviderException("The IBMCAC provider may have been tampered with.");
        }
    }

    private static String getDebugDate(String string) {
        String string2 = "Unknown";
        try {
            Class<?> clazz = Class.forName(string);
            Package package_ = clazz.getPackage();
            String string3 = package_.getImplementationVersion();
            int n = string3.indexOf("_");
            string2 = string3.substring(n + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("ibmcac");
                debug = Boolean.getBoolean("com.ibm.security.cac.debug");
                if (debug) {
                    System.out.println("IBMCAC Build-Level: -" + IBMCAC.getDebugDate("com.ibm.security.capi.IBMCAC"));
                    System.out.println("loading IBMCAC provider");
                }
                return null;
            }
        });
    }

    private static class IBMCACService
    extends Provider.Service {
        private final Provider provider;
        private final String algorithm;

        IBMCACService(Provider provider, String string, String string2, String string3, String[] stringArray) {
            super(provider, string, string2, string3, IBMCACService.toList(stringArray), null);
            this.provider = provider;
            this.algorithm = string2;
        }

        private static List<String> toList(String[] stringArray) {
            return stringArray == null ? null : Arrays.asList(stringArray);
        }

        @Override
        public boolean supportsParameter(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof CKey)) {
                throw new InvalidParameterException("Parameter must be a Key");
            }
            String string = this.getAlgorithm();
            String string2 = this.getType();
            CKey cKey = (CKey)object;
            String string3 = cKey.getAlgorithm();
            return cKey instanceof CKey;
        }

        @Override
        public String toString() {
            return super.toString() + "\nprovider = " + this.provider + "\nalgorithm = " + this.algorithm;
        }
    }
}

