/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.DHParameters;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.DHKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class DHPublicKey
extends X509Key
implements javax.crypto.interfaces.DHPublicKey,
PublicKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -2993913181811776154L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger y = null;
    private DHParameters dhParams = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private transient boolean destroyed = false;
    private transient DHKey dhKey = null;
    private static final String[] z;

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        this.dhParams = new DHParameters(iBMJCEPlusProvider);
        try {
            this.dhParams.engineInit(new DHParameterSpec(bigInteger2, bigInteger3, n2));
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[7]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z[6]);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, DHParameters dHParameters) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        this.dhParams = dHParameters;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[4]);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, DHKey dHKey) {
        try {
            this.provider = iBMJCEPlusProvider;
            this.algid = new AlgorithmId(AlgorithmId.DH_oid, dHKey.getParameters());
            byte[] byArray = this.a(dHKey.getPublicKeyBytes());
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.dhKey = dHKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[22], (Throwable)exception);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.a(byArray);
            byte[] byArray2 = this.a();
            this.dhKey = DHKey.createPublicKey(iBMJCEPlusProvider.a(), this.encodedKey);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[20]);
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[21], (Throwable)exception);
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new IOException(z[15]);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new IOException(z[16]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new IOException(z[17]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new IOException(z[8]);
            }
            if (derValue3.getTag() != 48) {
                throw new IOException(z[11]);
            }
            derValue3.getData().reset();
            BigInteger bigInteger = derValue3.getData().getInteger();
            BigInteger bigInteger2 = derValue3.getData().getInteger();
            int n2 = -1;
            if (derValue3.getData().available() != 0) {
                n2 = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new IOException(z[9]);
            }
            DHParameters dHParameters = this.dhParams = new DHParameters(this.provider);
            DHParameterSpec dHParameterSpec = n2 == -1 ? new DHParameterSpec(bigInteger, bigInteger2) : new DHParameterSpec(bigInteger, bigInteger2, n2);
            dHParameters.engineInit(dHParameterSpec);
            this.key = derValue.getData().getBitString();
            this.parseKeyBits();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(z[10]);
            }
            this.encodedKey = (byte[])byArray.clone();
            DerValue derValue4 = new DerValue(2, this.key);
            return derValue4.toByteArray();
        }
        catch (IOException | NumberFormatException exception) {
            throw new IOException(z[12], exception);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException(z[14], invalidKeyException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[13], invalidParameterSpecException);
        }
    }

    private byte[] a() throws Exception {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.y.toByteArray()), new DerValue(2, this.dhParams.a().toByteArray()), new DerValue(2, this.dhParams.b().toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.a(derOutputStream);
        }
        return derOutputStream.toByteArray();
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new InvalidKeyException(iOException.toString());
        }
    }

    @Override
    public DHParameterSpec getParams() {
        this.c();
        try {
            return this.dhParams.engineGetParameterSpec(DHParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw this.provider.a(z[18], (Throwable)invalidParameterSpecException);
        }
    }

    @Override
    public String getAlgorithm() {
        this.c();
        return z[19];
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncoded() {
        this.c();
        DerOutputStream derOutputStream = null;
        DerOutputStream derOutputStream2 = null;
        DerOutputStream derOutputStream3 = null;
        DerOutputStream derOutputStream4 = null;
        if (this.encodedKey == null) {
            try {
                derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(this.dhParams.a());
                derOutputStream.putInteger(this.dhParams.b());
                if (this.dhParams.c() != 0) {
                    derOutputStream.putInteger(BigInteger.valueOf(this.dhParams.c()));
                }
                DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream2);
                derOutputStream3.putBitString(this.key);
                derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
                this.a(derOutputStream);
                this.a(derOutputStream2);
                this.a(derOutputStream3);
                this.a(derOutputStream4);
            }
            catch (IOException iOException) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                this.a(derOutputStream);
                this.a(derOutputStream2);
                this.a(derOutputStream3);
                this.a(derOutputStream4);
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        this.c();
        return this.y;
    }

    DHKey b() {
        return this.dhKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.dhKey = null;
            this.y = null;
            this.dhParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[5]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[3] + this.y.toString() + z[2] + this.dhParams.a().toString() + z[0] + this.dhParams.b().toString());
        if (this.dhParams.c() != 0) {
            stringBuffer.append(z[1] + this.dhParams.c());
        }
        return stringBuffer.toString();
    }

    private void a(DerOutputStream derOutputStream) {
        try {
            derOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[23];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "o\u0003&{";
        int n3 = -1;
        block30: while (true) {
            char[] cArray;
            block34: {
                int n4;
                int n5;
                block33: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block33;
                    n5 = n5;
                    if (n5 <= n4) break block34;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 101;
                            break;
                        }
                        case 1: {
                            n6 = 100;
                            break;
                        }
                        case 2: {
                            n6 = 28;
                            break;
                        }
                        case 3: {
                            n6 = 113;
                            break;
                        }
                        default: {
                            n6 = 66;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "o\b&{bED<";
                    n3 = 0;
                    continue block30;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "o\u0014&{";
                    n3 = 1;
                    continue block30;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ",&Q;\u0001 DX\u0018$\u0003\ry\\\n\u0000\bp\u001c#\u000bDL\u0004 \t\r\u007fQ\t\u0000\u001d&{;_n";
                    n3 = 2;
                    continue block30;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "&\u0005r\u001f-\u0011Dl\u0003-\u0001\u0011\u007f\u0014b$7R_sE\u0001r\u0012-\u0001\rr\u0016";
                    n3 = 3;
                    continue block30;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "1\fu\u0002b\u000e\u0001eQ+\u0016Dr\u001eb\t\u000br\u0016'\u0017Dj\u0010.\f\u0000";
                    n3 = 4;
                    continue block30;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "&\u0005r\u001f-\u0011Du\u001f+\u0011\r}\u001d+\u001f\u0001<\u0001#\u0017\u0005q\u00146\u0000\u0016o";
                    n3 = 5;
                    continue block30;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "&\u0005r\u001f-\u0011Dl\u0003-\u0001\u0011\u007f\u0014b$7R_sE\u0001r\u0012-\u0001\rr\u0016";
                    n3 = 6;
                    continue block30;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "+\u0011p\u001db\u0015\u0005n\u0010/\u0000\u0010y\u00031";
                    n3 = 7;
                    continue block30;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = " \u001ch\u0003#E\u0014}\u0003#\b\u0001h\u00140E\u0000}\u0005#";
                    n3 = 8;
                    continue block30;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = " \u001c\u007f\u00141\u0016Dw\u0014;E\u0000}\u0005#";
                    n3 = 9;
                    continue block30;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "5\u0005n\u0010/\u0000\u0010y\u00031E\ns\u0005b\u0004DO4\u00130!R2\u0007";
                    n3 = 10;
                    continue block30;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = " \u0016n\u001e0E\u0014}\u00031\f\n{Q)\u0000\u001d<\u0014,\u0006\u000bx\u0018,\u0002";
                    n3 = 11;
                    continue block30;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = " \u0016n\u001e0E\u0007n\u0014#\u0011\rr\u0016b!,L\u00100\u0004\ty\u0005'\u0017\u0017";
                    n3 = 12;
                    continue block30;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = " \u0016n\u001e0E\u0014}\u00031\f\n{Q)\u0000\u001d<\u001c#\u0011\u0001n\u0018#\t";
                    n3 = 13;
                    continue block30;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = ",\nj\u0010.\f\u0000<\u001a'\u001cDz\u001e0\b\u0005h";
                    n3 = 14;
                    continue block30;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "$\b{8&E\roQ,\n\u0010<\u0010b6!M$\u0007+'Y";
                    n3 = 15;
                    continue block30;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "5\u0005n\u0010/\u0000\u0010y\u00031E\tu\u00021\f\n{";
                    n3 = 16;
                    continue block30;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "#\u0005u\u001d7\u0017\u0001<\u0018,E T!7\u0007\bu\u0012\t\u0000\u001d";
                    n3 = 17;
                    continue block30;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "!,";
                    n3 = 18;
                    continue block30;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = ",\nj\u0010.\f\u0000<\u001a'\u001cDz\u001e0\b\u0005h";
                    n3 = 19;
                    continue block30;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "#\u0005u\u001d7\u0017\u0001<\u0018,E T!7\u0007\bu\u0012\t\u0000\u001d";
                    n3 = 20;
                    continue block30;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "#\u0005u\u001d7\u0017\u0001<\u0018,E T!7\u0007\bu\u0012\t\u0000\u001d";
                    n3 = 21;
                    continue block30;
                }
                case 21: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

