/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.RSAKey;
import com.ibm.crypto.plus.provider.q;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class RSAPrivateCrtKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateCrtKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -4315189411360884318L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private AlgorithmParameterSpec keyParams;
    private transient boolean destroyed = false;
    private transient RSAKey rsaKey = null;
    private static final String[] z;

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.rsaPrivateCrtKey(this.algid, iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public RSAPrivateCrtKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.rsaPrivateCrtKey(algorithmId, iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public void rsaPrivateCrtKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        block21: {
            block20: {
                this.algid = algorithmId;
                this.provider = iBMJCEPlusProvider;
                this.modulus = bigInteger;
                this.publicExponent = bigInteger2;
                this.privateExponent = bigInteger3;
                this.primeP = bigInteger4;
                this.primeQ = bigInteger5;
                this.primeExponentP = bigInteger6;
                this.primeExponentQ = bigInteger7;
                this.crtCoefficient = bigInteger8;
                this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
                if (this.modulus == null || this.publicExponent == null) break block20;
                if (this.privateExponent == null) break block20;
                if (this.primeP == null) break block20;
                if (this.primeQ == null) break block20;
                if (this.primeExponentP == null) break block20;
                if (this.primeExponentQ == null) break block20;
                if (this.crtCoefficient != null) break block21;
            }
            throw new InvalidKeyException(z[3]);
        }
        q.a(this.provider, this.modulus.bitLength(), this.publicExponent);
        try {
            this.key = RSAPrivateCrtKey.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[4] + iOException.getMessage());
        }
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[2]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0] + iOException.getMessage());
        }
        q.a(iBMJCEPlusProvider, this.modulus.bitLength(), this.publicExponent);
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[1]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.algid = new AlgIdRSA();
        this.rsaPrivateCrtKey(this.algid, iBMJCEPlusProvider, rSAKey);
    }

    public void rsaPrivateCrtKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = algorithmId;
            this.key = rSAKey.getPrivateKeyBytes();
            this.rsaKey = rSAKey;
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[9]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    @Override
    public String getAlgorithm() {
        this.b();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.b();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.b();
        return super.getEncoded();
    }

    RSAKey a() {
        return this.rsaKey;
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            int n2 = derValue.getData().getInteger().intValue();
            if (n2 != 0) {
                throw new IOException(z[7]);
            }
            this.modulus = derValue.getData().getPositiveBigInteger();
            this.publicExponent = derValue.getData().getPositiveBigInteger();
            this.privateExponent = derValue.getData().getPositiveBigInteger();
            this.primeP = derValue.getData().getPositiveBigInteger();
            this.primeQ = derValue.getData().getPositiveBigInteger();
            this.primeExponentP = derValue.getData().getPositiveBigInteger();
            this.primeExponentQ = derValue.getData().getPositiveBigInteger();
            this.crtCoefficient = derValue.getData().getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[6]);
            }
        }
        catch (IOException iOException) {
            throw new IOException(z[8], iOException);
        }
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray()), new DerValue(2, bigInteger3.toByteArray()), new DerValue(2, bigInteger4.toByteArray()), new DerValue(2, bigInteger5.toByteArray()), new DerValue(2, bigInteger6.toByteArray()), new DerValue(2, bigInteger7.toByteArray()), new DerValue(2, bigInteger8.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    @Override
    public BigInteger getPrivateExponent() {
        this.b();
        return this.privateExponent;
    }

    @Override
    public BigInteger getModulus() {
        this.b();
        return this.modulus;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        this.b();
        return this.crtCoefficient;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        this.b();
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        this.b();
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getPrimeP() {
        this.b();
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        this.b();
        return this.primeQ;
    }

    @Override
    public BigInteger getPublicExponent() {
        this.b();
        return this.publicExponent;
    }

    private Object writeReplace() throws ObjectStreamException {
        this.b();
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.rsaKey = null;
            this.modulus = null;
            this.publicExponent = null;
            this.privateExponent = null;
            this.primeP = null;
            this.primeQ = null;
            this.primeExponentP = null;
            this.primeExponentQ = null;
            this.crtCoefficient = null;
            this.keyParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void b() {
        if (this.destroyed) {
            throw new IllegalStateException(z[5]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "t\t\u001a(!7\b\u00000eS#=d y\u0005\u0000  -F";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                block20: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block20;
                    n5 = n5;
                    if (n5 <= n4) break block21;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 23;
                            break;
                        }
                        case 1: {
                            n6 = 102;
                            break;
                        }
                        case 2: {
                            n6 = 111;
                            break;
                        }
                        case 3: {
                            n6 = 68;
                            break;
                        }
                        default: {
                            n6 = 69;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Q\u0007\u0006( sF\u001b+et\u0014\n%1rF=\u0017\u00047\u0016\u001d-3v\u0012\nd.r\u001f";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Q\u0007\u0006( sF\u001b+et\u0014\n%1rF=\u0017\u00047\u0016\u001d-3v\u0012\nd.r\u001f";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "E5.d\u000er\u001fO4$e\u0007\u0002!1r\u0014\u001cd&v\b\u0001+17\u0004\nd+b\n\u0003";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "t\t\u001a(!7\b\u00000eS#=d y\u0005\u0000  -F";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "C\u000e\u00067e|\u0003\u0016d,dF\u0001+e{\t\u0001# eF\u0019%)~\u0002";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "^\b\u0019%)~\u0002O\u0016\u0016V6\u001d-3v\u0012\n\u00077c-\n=er\b\f+!~\b\bhes\u0007\u001b%ex\u0010\n67b\b";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "A\u0003\u001d7,x\bO)0d\u0012O& 7V";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "^\b\u0019%)~\u0002O\u0016\u0016VF\u001f6,a\u0007\u001b!e|\u0003\u0016";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "Q\u0007\u0006( sF\u001b+et\u0014\n%1rF=\u0017\u00047\u0016\u001d-3v\u0012\nd.r\u001f";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

