/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.XECKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import ibm.security.internal.interfaces.XECPrivateKey;
import ibm.security.internal.spec.NamedParameterSpec;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Optional;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class XDHPrivateKeyImpl
extends PrivateKeyInfo
implements XECPrivateKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = 6034044314589513430L;
    private IBMJCEPlusProvider provider;
    private Optional<byte[]> scalar;
    private NamedParameterSpec params;
    BigInteger bi1;
    BigInteger bi2;
    BigInteger bi3;
    private Exception exception;
    private static final byte TAG_PARAMETERS_ATTRS = 0;
    private transient boolean destroyed;
    private transient XECKey xecKey;
    private static final String[] z;

    private void a() throws Exception {
        if (this.key == null) {
            this.key = this.a(this.xecKey.getPrivateKeyBytes());
            this.scalar = Optional.of(this.key);
            this.algid = XECKey.getAlgId(this.params.getCurve());
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, XECKey xECKey) throws InvalidKeyException {
        this.provider = null;
        this.exception = null;
        this.destroyed = false;
        this.xecKey = null;
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[0]);
        }
        if (xECKey == null) {
            throw new InvalidKeyException(z[1]);
        }
        this.xecKey = xECKey;
        this.provider = iBMJCEPlusProvider;
        try {
            this.a();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage());
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = null;
        this.exception = null;
        this.destroyed = false;
        this.xecKey = null;
        this.provider = iBMJCEPlusProvider;
        try {
            byte[] byArray2 = this.b(byArray);
            this.xecKey = XECKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray2, this.params.getCurve());
            this.scalar = Optional.of(this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[15]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, AlgorithmParameterSpec algorithmParameterSpec, Optional<byte[]> optional) throws InvalidParameterException {
        block15: {
            this.provider = null;
            this.exception = null;
            this.destroyed = false;
            this.xecKey = null;
            if (iBMJCEPlusProvider == null) {
                throw new InvalidParameterException(z[2]);
            }
            if (!(algorithmParameterSpec instanceof NamedParameterSpec)) {
                throw new InvalidParameterException(z[3]);
            }
            this.params = (NamedParameterSpec)algorithmParameterSpec;
            try {
                if (XECKey.isFFDHE(this.params.getCurve())) {
                    throw new InvalidParameterException(z[5]);
                }
            }
            catch (Exception exception) {
                throw new InvalidParameterException(exception.getMessage());
            }
            this.provider = iBMJCEPlusProvider;
            this.scalar = optional;
            if (optional != null) {
                this.key = optional.get();
            }
            try {
                block14: {
                    if (this.key != null) break block14;
                    this.xecKey = XECKey.generateKeyPair(iBMJCEPlusProvider.a(), this.params.getCurve());
                    break block15;
                }
                this.algid = XECKey.getAlgId(this.params.getCurve());
                byte[] byArray = this.b();
                this.xecKey = XECKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray, this.params.getCurve());
            }
            catch (Exception exception) {
                InvalidParameterException invalidParameterException = new InvalidParameterException(z[4]);
                iBMJCEPlusProvider.a(invalidParameterException, (Throwable)exception);
                throw invalidParameterException;
            }
        }
    }

    private byte[] b() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(0);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.algid.getOID());
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOctetString(this.key);
        derOutputStream.putOctetString(derOutputStream3.toByteArray());
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream);
        return derOutputStream4.toByteArray();
    }

    private byte[] a(byte[] byArray) throws IOException {
        Object object;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        DerInputStream derInputStream2 = null;
        if (derValueArray.length > 1) {
            derInputStream2 = derValueArray[1].getData();
            if (derInputStream2.tag != 0) {
                throw new IOException(z[14]);
            }
            try {
                object = this.a(derInputStream2, null);
            }
            catch (Exception exception) {
                throw new IOException(z[13]);
            }
        }
        object = null;
        if (derValueArray.length > 2) {
            object = derValueArray[2].getOctetString();
            object = this.params.getName().contains(z[12]) ? new DerInputStream(object).getInteger().toByteArray() : new DerInputStream(object).getOctetString();
            return object;
        }
        return null;
    }

    private ObjectIdentifier a(DerInputStream derInputStream, DerOutputStream derOutputStream) throws IOException {
        NamedParameterSpec.CURVE cURVE;
        ObjectIdentifier objectIdentifier;
        block5: {
            DerOutputStream derOutputStream2;
            objectIdentifier = derInputStream.getOID();
            XECKey.checkOid(objectIdentifier);
            try {
                derOutputStream2 = derInputStream.getSequence(3);
                if (((DerValue[])derOutputStream2).length < 3) {
                    throw new IOException(z[16]);
                }
                this.bi1 = derOutputStream2[0].getInteger();
                this.bi2 = derOutputStream2[1].getInteger();
                this.bi3 = derOutputStream2[2].getInteger();
                int n2 = this.bi1.bitLength();
                cURVE = XECKey.getCurve(objectIdentifier, n2);
            }
            catch (IOException iOException) {
                cURVE = XECKey.getCurve(objectIdentifier, null);
            }
            if (derOutputStream == null) break block5;
            derOutputStream.putOID(objectIdentifier);
            if (!XECKey.isFFDHE(cURVE)) break block5;
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(this.bi1);
            derOutputStream2.putInteger(this.bi2);
            derOutputStream2.putInteger(this.bi3);
            derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        }
        this.params = new NamedParameterSpec(cURVE);
        return objectIdentifier;
    }

    private byte[] b(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        DerOutputStream derOutputStream = new DerOutputStream();
        BigInteger bigInteger = derValueArray[0].getInteger();
        derOutputStream.putInteger(bigInteger);
        Object var6_6 = null;
        ObjectIdentifier objectIdentifier = null;
        if (derValueArray.length < 3) {
            throw new IOException(z[10]);
        }
        if (derValueArray[1].getTag() != 48) {
            throw new IOException(z[11]);
        }
        DerInputStream derInputStream2 = derValueArray[1].toDerInputStream();
        Object object = new DerOutputStream();
        objectIdentifier = this.a(derInputStream2, (DerOutputStream)object);
        this.algid = new AlgorithmId(objectIdentifier);
        derOutputStream.write((byte)48, object.toByteArray());
        this.key = derValueArray[2].getOctetString();
        derInputStream2 = new DerOutputStream();
        if (XECKey.isFFDHE(this.params.getCurve())) {
            object = new BigInteger(this.key);
            derInputStream2.putInteger((BigInteger)object);
        } else {
            derInputStream2.putOctetString(this.key);
        }
        derOutputStream.putOctetString(derInputStream2.toByteArray());
        object = new DerOutputStream();
        object.write((byte)48, derOutputStream);
        return object.toByteArray();
    }

    public XECKey getICCKey() {
        return this.xecKey;
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public Optional<byte[]> getScalar() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return this.scalar;
    }

    public byte[] getKeyBytes() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getKeyBytes();
    }

    public AlgorithmId getAlgorithmId() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getAlgorithmId();
    }

    public String getAlgorithm() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getAlgorithm();
    }

    public static void putFFDHEIntegers(DerOutputStream derOutputStream, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(bigInteger);
        derOutputStream2.putInteger(bigInteger2);
        derOutputStream2.putInteger(bigInteger3);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encode(OutputStream outputStream) throws IOException {
        try {
            this.a();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(z[6]);
            this.provider.a(iOException, (Throwable)exception);
            throw iOException;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(0);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream3.putOID(this.algid.getOID());
        switch (this.params.getCurve()) {
            case X25519: {
                derOutputStream3.putNull();
                break;
            }
            case X448: {
                derOutputStream3.putNull();
                break;
            }
            case Ed25519: {
                derOutputStream3.putNull();
                break;
            }
            case Ed448: {
                derOutputStream3.putNull();
                break;
            }
            case FFDHE2048: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE3072: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE4096: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE6144: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE8192: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
        }
        derOutputStream4.write((byte)48, derOutputStream3);
        derOutputStream.write(derOutputStream4.toByteArray());
        if (this.key != null) {
            derOutputStream.putOctetString(this.key);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (this.exception != null) {
            String string = this.exception.getMessage();
            string = string + z[8];
            StackTraceElement[] stackTraceElementArray = this.exception.getStackTrace();
            int n2 = stackTraceElementArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    throw new DestroyFailedException(z[9] + string);
                }
                StackTraceElement stackTraceElement = stackTraceElementArray[n3];
                string = string + z[7] + stackTraceElement.toString() + "\n";
                ++n3;
            }
        }
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.xecKey = null;
            this.scalar = null;
            this.params = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[17]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[18];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = ")A\u0005\t\t=V\u0018_\u00038]\u0004\u0010\u0014yQ\u000f_\u000e,_\u0006";
        int n3 = -1;
        block25: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                block28: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block28;
                    n5 = n5;
                    if (n5 <= n4) break block29;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 89;
                            break;
                        }
                        case 1: {
                            n6 = 51;
                            break;
                        }
                        case 2: {
                            n6 = 106;
                            break;
                        }
                        case 3: {
                            n6 = 127;
                            break;
                        }
                        default: {
                            n6 = 96;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "!V\t4\u0005 \u0013\t\u001e\u000e7\\\u001e_\u0002<\u0013\u0004\n\f5";
                    n3 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ")A\u0005\t\t=V\u0018_\r,@\u001e_\u000e6GJ\u001d\u0005y]\u001f\u0013\f";
                    n3 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ")R\u0018\u001e\r*\u0013\u0007\n\u0013-\u0013\b\u001a@6UJ\u000b\u0019)VJ1\u00014V\u000e/\u0001+R\u0007\u001a\u0014<A9\u000f\u0005:";
                    n3 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001fR\u0003\u0013\u0005=\u0013\u001e\u0010@:A\u000f\u001e\u0014<\u00132:#yC\u0018\u0016\u00168G\u000f_\u000b<J";
                    n3 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001fu.7%yR\u0006\u0018\u000f+Z\u001e\u0017\r*\u0013\u000b\r\u0005y]\u0005\u000b@*F\u001a\u000f\u000f<A\u001e\u001a\u0004";
                    n3 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001fR\u0003\u0013\u0005=\u0013\u0003\u0011@*V\u001e9\t<_\u000e\f&+\\\u0007'\u0005:X\u000f\u0006";
                    n3 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "t\u0013";
                    n3 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "S`\u001e\u001e\u00032\t`";
                    n3 = 7;
                    continue block25;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0018]J\u001a\u0018:V\u001a\u000b\t6]J\u0010\u0003:F\u0018\r\u0005=\u0013\u000e\n\u00120]\r_\u00141VJ\u001a\u0018<P\u001f\u000b\t6]J\u0010\u0006yG\u0002\u0016\u0013y\\\b\u0015\u0005:GP_";
                    n3 = 8;
                    continue block25;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\r[\u0003\f@:F\u0018\t\u0005yW\u0005\u001a\u0013y]\u0005\u000b@*V\u000f\u0012@-\\J\u001d\u0005yRJ\t\u00015Z\u000e_8\u001cpE9&\u001d{/_\u0003,A\u001c\u001a";
                    n3 = 9;
                    continue block25;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\f]\u000f\u0007\u0010<P\u001e\u001a\u0004y]\u0005\u0011@*V\u001b\n\u00057P\u000f_\u00171Z\u0006\u001a@)R\u0018\f\t7TJ\u000f\u00120E\u000b\u000b\u0005yX\u000f\u0006@;J\u001e\u001a\u0013";
                    n3 = 10;
                    continue block25;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u001fu.7";
                    n3 = 11;
                    continue block25;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\r[\u0003\f@:F\u0018\t\u0005yW\u0005\u001a\u0013y]\u0005\u000b@*V\u000f\u0012@-\\J\u001d\u0005yR\u0004_8\u001cpJ\u0010\u0012yu,;(\u001c\u0013\t\n\u0012/V";
                    n3 = 12;
                    continue block25;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "yg\u0002\u001a@7V\u0012\u000b@<]\t\u0010\u0004<WJ\f\u0014+F\t\u000b\u0015+VJ\u0012\u0015*GJ\u001d\u0005yRJ\u001c\u000f7G\u000f\u0007\u0014yP\u0005\u0011\u0013-A\u001f\u001c\u0014<WJ0)\u001d";
                    n3 = 13;
                    continue block25;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u001fR\u0003\u0013\u0005=\u0013\u001e\u0010@:A\u000f\u001e\u0014<\u00132:#yC\u0018\u0016\u00168G\u000f_\u000b<J";
                    n3 = 14;
                    continue block25;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\r[\u0003\f@:F\u0018\t\u0005yW\u0005\u001a\u0013y]\u0005\u000b@*V\u000f\u0012@-\\J\u001d\u0005yRJ\t\u00015Z\u000e_8\u001cpE9&\u001d{/_\u0003,A\u001c\u001a";
                    n3 = 15;
                    continue block25;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\r[\u0003\f@2V\u0013_\t*\u0013\u0004\u0010@5\\\u0004\u0018\u0005+\u0013\u001c\u001e\f0W";
                    n3 = 16;
                    continue block25;
                }
                case 16: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

