/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.XDHPrivateKeyImpl;
import com.ibm.crypto.plus.provider.icc.XECKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509Key;
import ibm.security.internal.interfaces.XECPublicKey;
import ibm.security.internal.spec.NamedParameterSpec;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class XDHPublicKeyImpl
extends X509Key
implements XECPublicKey,
Destroyable,
Serializable {
    private static final long serialVersionUID = 7187392471159151072L;
    private IBMJCEPlusProvider provider;
    private NamedParameterSpec params;
    private BigInteger u;
    private BigInteger bi1;
    private BigInteger bi2;
    private BigInteger bi3;
    private transient boolean destroyed;
    private transient XECKey xecKey;
    private static final byte TAG_PARAMETERS_ATTRS = 0;
    private static final String[] z;

    private void a(NamedParameterSpec.CURVE cURVE) throws Exception {
        byte[] byArray = this.xecKey.getPublicKeyBytes();
        if (cURVE.toString().contains(z[8])) {
            byArray = this.b(byArray);
        }
        this.setKey(new BitArray(byArray.length * 8, byArray));
        if (!cURVE.toString().contains(z[9])) {
            XDHPublicKeyImpl.c(byArray);
        }
        this.u = new BigInteger(byArray);
        this.params = new NamedParameterSpec(cURVE);
    }

    public XDHPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, XECKey xECKey, NamedParameterSpec.CURVE cURVE) throws InvalidKeyException {
        this.provider = null;
        this.destroyed = false;
        this.xecKey = null;
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[6]);
        }
        if (xECKey == null) {
            throw new InvalidKeyException(z[5]);
        }
        this.provider = iBMJCEPlusProvider;
        this.xecKey = xECKey;
        try {
            this.algid = XECKey.getAlgId(cURVE);
            this.a(cURVE);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[7]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public XDHPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = null;
        this.destroyed = false;
        this.xecKey = null;
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[14]);
        }
        if (byArray == null) {
            throw new InvalidKeyException(z[15]);
        }
        this.provider = iBMJCEPlusProvider;
        this.decode(byArray);
        try {
            byte[] byArray2 = (byte[])this.key.clone();
            if (!XECKey.isEd(this.params.getCurve())) {
                XDHPublicKeyImpl.c(byArray2);
            }
            this.u = new BigInteger(byArray2);
            byte[] byArray3 = this.a(byArray);
            this.xecKey = XECKey.createPublicKey(iBMJCEPlusProvider.a(), byArray3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[13]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public XDHPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger) throws InvalidParameterException {
        block13: {
            this.provider = null;
            this.destroyed = false;
            this.xecKey = null;
            if (iBMJCEPlusProvider == null) {
                throw new InvalidParameterException(z[3]);
            }
            if (!(algorithmParameterSpec instanceof NamedParameterSpec)) {
                throw new InvalidParameterException(z[2]);
            }
            this.params = (NamedParameterSpec)algorithmParameterSpec;
            try {
                if (XECKey.isFFDHE(this.params.getCurve())) {
                    throw new InvalidParameterException(z[0]);
                }
            }
            catch (Exception exception) {
                throw new InvalidParameterException(exception.getMessage());
            }
            this.provider = iBMJCEPlusProvider;
            this.u = bigInteger;
            try {
                if (bigInteger == null) {
                    this.xecKey = XECKey.generateKeyPair(iBMJCEPlusProvider.a(), this.params.getCurve());
                    this.a(this.params.getCurve());
                    break block13;
                }
                this.key = bigInteger.toByteArray();
                if (!XECKey.isEd(this.params.getCurve())) {
                    XDHPublicKeyImpl.c(this.key);
                }
                this.algid = XECKey.getAlgId(this.params.getCurve());
                byte[] byArray = this.a();
                this.xecKey = XECKey.createPublicKey(iBMJCEPlusProvider.a(), byArray);
            }
            catch (Exception exception) {
                InvalidParameterException invalidParameterException = new InvalidParameterException(z[1]);
                iBMJCEPlusProvider.a(invalidParameterException, (Throwable)exception);
                throw invalidParameterException;
            }
        }
    }

    private byte[] a() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOID(this.algid.getOID());
        if (XECKey.isFFDHE(this.params.getCurve())) {
            XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream2, this.bi1, this.bi2, this.bi3);
        }
        derOutputStream2.write((byte)48, derOutputStream3.toByteArray());
        derOutputStream2.putBitString(this.key);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    private ObjectIdentifier a(DerInputStream derInputStream, DerOutputStream derOutputStream) throws IOException {
        NamedParameterSpec.CURVE cURVE;
        ObjectIdentifier objectIdentifier;
        block5: {
            DerOutputStream derOutputStream2;
            objectIdentifier = derInputStream.getOID();
            XECKey.checkOid(objectIdentifier);
            try {
                derOutputStream2 = derInputStream.getSequence(3);
                if (((DerValue[])derOutputStream2).length < 3) {
                    throw new IOException(z[4]);
                }
                this.bi1 = derOutputStream2[0].getInteger();
                this.bi2 = derOutputStream2[1].getInteger();
                this.bi3 = derOutputStream2[2].getInteger();
                int n2 = this.bi1.bitLength();
                cURVE = XECKey.getCurve(objectIdentifier, n2);
            }
            catch (IOException iOException) {
                cURVE = XECKey.getCurve(objectIdentifier, null);
            }
            if (derOutputStream == null) break block5;
            derOutputStream.putOID(objectIdentifier);
            if (!XECKey.isFFDHE(cURVE)) break block5;
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(this.bi1);
            derOutputStream2.putInteger(this.bi2);
            derOutputStream2.putInteger(this.bi3);
            derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        }
        this.params = new NamedParameterSpec(cURVE);
        return objectIdentifier;
    }

    private byte[] a(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        ObjectIdentifier objectIdentifier = this.a(derValueArray[0].toDerInputStream(), derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        if (derValueArray.length <= 1) {
            throw new IOException(z[18]);
        }
        Object object = derValueArray[1].getBitString();
        derOutputStream.putBitString(object);
        object = new DerOutputStream();
        object.write((byte)48, derOutputStream);
        return object.toByteArray();
    }

    private byte[] b(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length < 2) {
            throw new IOException(z[17]);
        }
        DerInputStream derInputStream2 = null;
        derInputStream2 = derValueArray[0].getData();
        if (derInputStream2.tag != 0) {
            throw new IOException(z[16]);
        }
        this.a(derInputStream2, null);
        DerInputStream derInputStream3 = new DerInputStream(derValueArray[1].getBitString());
        return derInputStream3.getInteger().toByteArray();
    }

    private static void c(byte[] byArray) throws IOException {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by = byArray[i2];
            byArray[i2] = byArray[byArray.length - 1 - i2];
            byArray[byArray.length - 1 - i2] = by;
        }
    }

    XECKey b() {
        return this.xecKey;
    }

    public BigInteger getU() {
        return this.u;
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public byte[] getEncoded() {
        try {
            NamedParameterSpec.CURVE cURVE = this.params.getCurve();
            if (XECKey.isXEC(cURVE)) {
                return this.key;
            }
            if (this.encodedKey == null) {
                DerOutputStream derOutputStream;
                DerOutputStream derOutputStream2;
                block13: {
                    block12: {
                        DerOutputStream derOutputStream3;
                        block11: {
                            block10: {
                                derOutputStream2 = new DerOutputStream();
                                DerOutputStream derOutputStream4 = null;
                                if (XECKey.isFFDHE(cURVE)) {
                                    derOutputStream4 = new DerOutputStream();
                                    derOutputStream4.putInteger(this.bi1);
                                    derOutputStream4.putInteger(this.bi2);
                                    derOutputStream4.putInteger(this.bi3);
                                }
                                derOutputStream3 = new DerOutputStream();
                                derOutputStream3.putOID(this.algid.getOID());
                                if (derOutputStream4 == null) break block10;
                                derOutputStream3.write((byte)48, derOutputStream4);
                                break block11;
                            }
                            derOutputStream3.putNull();
                        }
                        DerOutputStream derOutputStream5 = null;
                        if (XECKey.isFFDHE(cURVE)) {
                            derOutputStream5 = new DerOutputStream();
                            derOutputStream5.putInteger(new BigInteger(this.key));
                        }
                        derOutputStream = new DerOutputStream();
                        derOutputStream.write((byte)48, derOutputStream3);
                        if (derOutputStream5 == null) break block12;
                        derOutputStream.putBitString(derOutputStream5.toByteArray());
                        break block13;
                    }
                    derOutputStream.putBitString(this.key);
                }
                derOutputStream2.write((byte)48, derOutputStream.toByteArray());
                this.encodedKey = derOutputStream2.toByteArray();
            }
            return (byte[])this.encodedKey.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.encodedKey = (byte[])byArray.clone();
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            if (derValueArray.length < 2) {
                throw new InvalidKeyException(z[11]);
            }
            DerInputStream derInputStream2 = derValueArray[0].toDerInputStream();
            ObjectIdentifier objectIdentifier = this.a(derInputStream2, null);
            this.algid = XECKey.getAlgId(this.params.getCurve());
            if (XECKey.isFFDHE(this.params.getCurve())) {
                DerInputStream derInputStream3 = new DerInputStream(derValueArray[1].getBitString());
                this.key = derInputStream3.getBigInteger().toByteArray();
            } else {
                this.key = derValueArray[1].getBitString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidKeyException(z[10]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.xecKey = null;
            this.u = null;
            this.params = null;
        }
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[12]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[19];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = ";om2V]HE\u001d|\u000f@]\u0012~\u000e\tH\bv]GF\u000e3\u000e\\Y\n|\u0018[]\u001fw";
        int n3 = -1;
        block26: while (true) {
            char[] cArray;
            block30: {
                int n4;
                int n5;
                block29: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block29;
                    n5 = n5;
                    if (n5 <= n4) break block30;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 125;
                            break;
                        }
                        case 1: {
                            n6 = 41;
                            break;
                        }
                        case 2: {
                            n6 = 41;
                            break;
                        }
                        case 3: {
                            n6 = 122;
                            break;
                        }
                        default: {
                            n6 = 19;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ";H@\u0016v\u0019\t]\u00153\u001e[L\u001bg\u0018\tq?P]Y\\\u0018\u007f\u0014J\t\u0011v\u0004";
                    n3 = 0;
                    continue block26;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\rH[\u001b~\u000e\tD\u000f`\t\tK\u001f3\u0012O\t\u000ej\rL\t4r\u0010LM*r\u000fHD\u001fg\u0018[z\nv\u001e";
                    n3 = 1;
                    continue block26;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\r[F\fz\u0019L[Z~\bZ]Z}\u0012]\t\u0018v]G\\\u0016\u007f";
                    n3 = 2;
                    continue block26;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ")A@\t3\u001e\\[\fv]MF\u001f`]GF\u000e3\u000eLL\u00173\tF\t\u0018v]H\t\fr\u0011@MZK8j\u0006<U9alZp\b[_\u001f";
                    n3 = 3;
                    continue block26;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0005LJ1v\u0004\tJ\u001b}\u0013F]Zq\u0018\tG\u000f\u007f\u0011";
                    n3 = 4;
                    continue block26;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\r[F\fz\u0019L[Zp\u001cGG\u0015g]KLZ}\bEE";
                    n3 = 5;
                    continue block26;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ";H@\u0016v\u0019\t]\u00153\u001e[L\u001bg\u0018\tq?P]Y\\\u0018\u007f\u0014J\t\u0011v\u0004";
                    n3 = 6;
                    continue block26;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ";om2V";
                    n3 = 7;
                    continue block26;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "8M";
                    n3 = 8;
                    continue block26;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "6LPZw\u0012LZZ}\u0012]\t\u001bc\rLH\b3\tF\t\u0018v]H\t\"V>\u0006o<W5l\t\u0011v\u0004";
                    n3 = 9;
                    continue block26;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "6LPZw\u0012LZZ}\u0012]\t\u001bc\rLH\b3\tF\t\u0018v]H\t\"V>\u0006o<W5l\t\u0011v\u0004";
                    n3 = 10;
                    continue block26;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = ")A@\t3\u0016LPZz\u000e\tG\u00153\u0011FG\u001dv\u000f\t_\u001b\u007f\u0014M";
                    n3 = 11;
                    continue block26;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = ";H@\u0016v\u0019\t]\u00153\u001e[L\u001bg\u0018\tq?P]Y\\\u0018\u007f\u0014J\t\u0011v\u0004";
                    n3 = 12;
                    continue block26;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\r[F\fz\u0019L[Zp\u001cGG\u0015g]KLZ}\bEE";
                    n3 = 13;
                    continue block26;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u0018GJ\u0015w\u0018M\t\u0011v\u0004\tJ\u001b}\u0013F]Zq\u0018\tG\u000f\u007f\u0011";
                    n3 = 14;
                    continue block26;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "]}A\u001f3\u0013LQ\u000e3\u0018GJ\u0015w\u0018M\t\tg\u000f\\J\u000ef\u000fL\t\u0017f\u000e]\t\u0018v]H\t\u0019|\u0013]L\u0002g]JF\u0014`\t[\\\u0019g\u0018M\t5Z9";
                    n3 = 15;
                    continue block26;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = ")A@\t3\u001e\\[\fv]MF\u001f`]GF\u000e3\u000eLL\u00173\tF\t\u0018v]H\t\fr\u0011@MZU;ma?3\u001e\\[\fv";
                    n3 = 16;
                    continue block26;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "9l{Z`\u0018X\\\u001f}\u001eL\t\u001e|\u0018Z\t\u0014|\t\tJ\u0015}\tH@\u00143\r\\K\u0016z\u001e\tB\u001fj";
                    n3 = 17;
                    continue block26;
                }
                case 17: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

