/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.beans;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkAttr;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitRepEvent;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkKupdRepEvent;
import com.ibm.security.certclient.base.PkKupdReqEvent;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkSecnRepEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.base.PkXcerRepEvent;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import com.ibm.security.certclient.util.PkCASetUp;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;

public class PkCertGen
extends PkPipe
implements PkConstants {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "com.ibm.security.certclient.PkCertGen";
    private String provider;

    public PkCertGen(String string) {
        this.provider = string;
    }

    private X509CertImpl getCert(PkCertReqEvent pkCertReqEvent) throws PkException {
        Object object;
        PkAttr pkAttr = pkCertReqEvent.getAttrs().get("cert.oper.privateKey");
        PrivateKey privateKey = (PrivateKey)pkAttr.getValue();
        PkAttrs pkAttrs = pkCertReqEvent.getAttrs();
        PkAttr pkAttr2 = pkAttrs.get("x509.info.algorithmID");
        String string = ((AlgorithmId)pkAttr2.getValue()).getName();
        PublicKey publicKey = (PublicKey)pkAttrs.getValue("x509.info.key");
        SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
        try {
            object = PkCASetUp.computeKID(publicKey, false);
            subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(object);
        }
        catch (IOException iOException) {
            throw new PkException(iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PkException(generalSecurityException);
        }
        pkAttrs.repOrAdd("x509.info.extensions.SubjectKeyIdentifier", 3, subjectKeyIdentifierExtension);
        try {
            object = subjectKeyIdentifierExtension.get("key_id");
            if (debug != null) {
                debug.text(0L, className, "getCert", "########### from PkCertGen....ki = {0}", object);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (debug != null) {
            debug.text(0L, className, "PkCertGen", "########### from PkCertGen.... attrs = {0}", (Object)pkAttrs);
        }
        try {
            object = new X509CertImpl((X509CertInfo)null);
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new PkException(certificateParsingException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new PkException(certificateEncodingException);
        }
        Object object2 = pkCertReqEvent.getAttrs().iterator();
        while (((PkAttrs.Iter)object2).hasNext()) {
            PkAttr pkAttr3 = ((PkAttrs.Iter)object2).nextAttr();
            if (!pkAttr3.isApplied() || !pkAttr3.isApproved()) continue;
            try {
                object.set(pkAttr3.getName(), pkAttr3.getValue());
            }
            catch (CertificateException certificateException) {
                throw new PkException(certificateException);
            }
            catch (IOException iOException) {
                throw new PkException(iOException);
            }
        }
        object2 = pkAttrs.getValue("x509.info.subject", "?");
        if (debug != null) {
            debug.text(0L, className, "PkCertGen", "####### subject = {0}", object2);
        }
        try {
            object.sign(privateKey, string, this.provider);
            if (debug != null) {
                debug.text(0L, className, "PkCertGen", "issued certificate to {0}", object2);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PkException(generalSecurityException);
        }
        return object;
    }

    private byte[] getEncoded(X509CertImpl x509CertImpl) throws PkException {
        try {
            return x509CertImpl.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new PkException(certificateEncodingException);
        }
    }

    @Override
    public PkCertRepEvent doCertReq(PkCertReqEvent pkCertReqEvent) throws PkException {
        X509CertImpl x509CertImpl = this.getCert(pkCertReqEvent);
        PkCertRepEvent pkCertRepEvent = new PkCertRepEvent(this, null, pkCertReqEvent, (Certificate)x509CertImpl);
        if (debug != null) {
            debug.text(0L, className, "doCertReq", pkCertRepEvent.getCert().toString());
        }
        return pkCertRepEvent;
    }

    @Override
    public PkInitRepEvent doInitReq(PkInitReqEvent pkInitReqEvent) throws PkException {
        Boolean bl = (Boolean)pkInitReqEvent.getAttrs().getValue("cert.oper.raEnrollment", Boolean.FALSE);
        if (!bl.booleanValue()) {
            X509CertImpl x509CertImpl = this.getCert(pkInitReqEvent);
            PkInitRepEvent pkInitRepEvent = new PkInitRepEvent(this, null, pkInitReqEvent, (Certificate)x509CertImpl);
            if (debug != null) {
                debug.text(0L, className, "doInitReq", pkInitRepEvent.getCert().toString());
            }
            return pkInitRepEvent;
        }
        X509CertImpl x509CertImpl = this.getCert(pkInitReqEvent);
        PkInitRepEvent pkInitRepEvent = new PkInitRepEvent(this, null, pkInitReqEvent, (Certificate)x509CertImpl);
        if (debug != null) {
            debug.text(0L, className, "doInitReq", pkInitRepEvent.getCert().toString());
        }
        return pkInitRepEvent;
    }

    @Override
    public PkSecnRepEvent doSecnReq(PkSecnReqEvent pkSecnReqEvent) throws PkException {
        X509CertImpl x509CertImpl = this.getCert(pkSecnReqEvent);
        PkSecnRepEvent pkSecnRepEvent = new PkSecnRepEvent(this, null, pkSecnReqEvent, (Certificate)x509CertImpl);
        if (debug != null) {
            debug.text(0L, className, "doSecnReq", pkSecnRepEvent.getCert().toString());
        }
        return pkSecnRepEvent;
    }

    @Override
    public PkKupdRepEvent doKupdReq(PkKupdReqEvent pkKupdReqEvent) throws PkException {
        X509CertImpl x509CertImpl = this.getCert(pkKupdReqEvent);
        PkKupdRepEvent pkKupdRepEvent = new PkKupdRepEvent(this, null, pkKupdReqEvent, (Certificate)x509CertImpl);
        if (debug != null) {
            debug.text(0L, className, "doKupdReq", pkKupdRepEvent.getCert().toString());
        }
        return pkKupdRepEvent;
    }

    @Override
    public PkXcerRepEvent doXcerReq(PkXcerReqEvent pkXcerReqEvent) throws PkException {
        X509CertImpl x509CertImpl = this.getCert(pkXcerReqEvent);
        PkXcerRepEvent pkXcerRepEvent = new PkXcerRepEvent(this, null, pkXcerReqEvent, (Certificate)x509CertImpl);
        if (debug != null) {
            debug.text(0L, className, "doXcerReq", pkXcerRepEvent.getCert().toString());
        }
        return pkXcerRepEvent;
    }
}

