/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

class JarVerifier {
    private static boolean debug = false;
    private Vector verifiedSignerCache = null;
    private URL jarURL;
    private JarFile jarFile;
    private boolean retrievedJarFile;

    JarVerifier(URL jarURL) {
        this.jarURL = jarURL;
        this.retrievedJarFile = false;
    }

    public void verify(X509Certificate[] trustedCaCerts) throws JarException, IOException {
        this.verifiedSignerCache = new Vector(2);
        try {
            this.verifyJars(this.jarURL, null, trustedCaCerts);
        }
        catch (NoSuchProviderException nspe) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        catch (CertificateException ce) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        finally {
            this.verifiedSignerCache = null;
        }
    }

    public JarFile getJarFile() {
        this.retrievedJarFile = true;
        return this.jarFile;
    }

    private void verifyJars(URL jarURL, Vector verifiedJarsCache, X509Certificate[] trustedCaCerts) throws NoSuchProviderException, CertificateException, IOException {
        String jarURLString = jarURL.toString();
        if (verifiedJarsCache == null || !verifiedJarsCache.contains(jarURLString)) {
            String supportingJars = this.verifySingleJar(jarURL, trustedCaCerts);
            if (verifiedJarsCache != null) {
                verifiedJarsCache.addElement(jarURLString);
            }
            if (supportingJars != null) {
                if (verifiedJarsCache == null) {
                    verifiedJarsCache = new Vector<String>();
                    verifiedJarsCache.addElement(jarURLString);
                }
                this.verifyManifestClassPathJars(jarURL, supportingJars, verifiedJarsCache, trustedCaCerts);
            }
        }
    }

    private void verifyManifestClassPathJars(URL baseURL, String supportingJars, Vector verifiedJarsCache, X509Certificate[] trustedCaCerts) throws NoSuchProviderException, CertificateException, IOException {
        String[] jarFileNames = this.parseAttrClasspath(supportingJars);
        try {
            for (int i = 0; i < jarFileNames.length; ++i) {
                URL url = new URL(baseURL, jarFileNames[i]);
                this.verifyJars(url, verifiedJarsCache, trustedCaCerts);
            }
        }
        catch (MalformedURLException mue) {
            MalformedURLException ex = new MalformedURLException("The JAR file " + baseURL.toString() + " contains invalid URLs in its Class-Path attribute. " + mue.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifySingleJar(URL jarURL, X509Certificate[] trustedCaCerts) throws NoSuchProviderException, CertificateException, IOException {
        final URL url = jarURL.getProtocol().equalsIgnoreCase("jar") ? jarURL : new URL("jar:" + jarURL.toString() + "!/");
        ZipFile jf = null;
        boolean isCached = true;
        try {
            try {
                jf = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        JarURLConnection conn = (JarURLConnection)url.openConnection();
                        conn.setUseCaches(false);
                        return conn.getJarFile();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                SecurityException se = new SecurityException("Cannot verify " + url.toString() + ". " + pae.getMessage());
                throw se;
            }
            byte[] buffer = new byte[8192];
            Vector<JarEntry> entriesVec = new Vector<JarEntry>();
            Enumeration<JarEntry> entries = ((JarFile)jf).entries();
            while (entries.hasMoreElements()) {
                int n;
                JarEntry je = entries.nextElement();
                entriesVec.addElement(je);
                InputStream is = ((JarFile)jf).getInputStream(je);
                while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                }
                is.close();
            }
            if (this.jarURL.equals(jarURL)) {
                this.jarFile = jf;
            } else {
                isCached = false;
            }
            Manifest man = ((JarFile)jf).getManifest();
            if (man == null) {
                throw new JarException(jarURL.toString() + " is not signed.");
            }
            Enumeration<JarEntry> e = ((JarFile)jf).entries();
            while (e.hasMoreElements()) {
                X509Certificate[] certChain;
                JarEntry je = e.nextElement();
                if (je.isDirectory()) continue;
                Certificate[] certs = je.getCertificates();
                if (certs == null || certs.length == 0) {
                    if (je.getName().startsWith("META-INF")) continue;
                    throw new JarException(jarURL.toString() + " has unsigned entries - " + je.getName());
                }
                int startIndex = 0;
                boolean signedAsExpected = false;
                while ((certChain = this.getAChain(certs, startIndex)) != null) {
                    if (this.verifiedSignerCache.contains(certChain[0])) {
                        signedAsExpected = true;
                        break;
                    }
                    if (this.isTrusted(certChain, trustedCaCerts)) {
                        signedAsExpected = true;
                        this.verifiedSignerCache.addElement(certChain[0]);
                        break;
                    }
                    startIndex += certChain.length;
                }
                if (signedAsExpected) continue;
                throw new JarException(jarURL.toString() + " is not signed by a trusted signer.");
            }
            String string = man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            return string;
        }
        finally {
            if (jf != null && !isCached) {
                jf.close();
            }
        }
    }

    private String[] parseAttrClasspath(String supportingJars) throws JarException {
        supportingJars = supportingJars.trim();
        int endIndex = supportingJars.indexOf(32);
        String name = null;
        Vector<String> values = new Vector<String>();
        boolean done = false;
        do {
            if (endIndex > 0) {
                name = supportingJars.substring(0, endIndex);
                supportingJars = supportingJars.substring(endIndex + 1).trim();
                endIndex = supportingJars.indexOf(32);
            } else {
                name = supportingJars;
                done = true;
            }
            if (!name.endsWith(".jar")) {
                throw new JarException("The provider contains un-verifiable components");
            }
            values.addElement(name);
        } while (!done);
        Object[] result = new String[values.size()];
        values.copyInto(result);
        return result;
    }

    private boolean isTrusted(X509Certificate[] chain, X509Certificate[] trustedCaCerts) {
        int i;
        int i2;
        for (i2 = 0; i2 < chain.length; ++i2) {
            X509Certificate currentCert = chain[i2];
            try {
                this.checkCriticalExts(currentCert, i2);
                continue;
            }
            catch (Exception e) {
                if (debug) {
                    e.printStackTrace(System.out);
                }
                return false;
            }
        }
        for (i2 = 0; i2 < chain.length - 1; ++i2) {
            PublicKey issuerKey = chain[i2 + 1].getPublicKey();
            X509Certificate currentCert = chain[i2];
            try {
                currentCert.verify(issuerKey);
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        X509Certificate topCert = chain[chain.length - 1];
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!trustedCaCerts[i].getSubjectDN().equals(topCert.getSubjectDN()) || !trustedCaCerts[i].equals(topCert)) continue;
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!trustedCaCerts[i].getSubjectDN().equals(topCert.getIssuerDN())) continue;
            try {
                topCert.verify(trustedCaCerts[i].getPublicKey());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void checkCriticalExts(X509Certificate cert, int index) throws Exception {
        Set<String> critSet = cert.getCriticalExtensionOIDs();
        if (critSet == null || critSet.size() == 0) {
            return;
        }
        this.checkBasicConstraints(cert, critSet, index);
    }

    private void checkBasicConstraints(X509Certificate cert, Set critSet, int index) throws Exception {
        int constraints;
        if (critSet != null && !critSet.isEmpty() && critSet.contains(new String("2.5.29.19")) && (constraints = cert.getBasicConstraints()) >= 0 && index > 0 && index - 1 > constraints) {
            throw new Exception("Violated basic constraints");
        }
    }

    private X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
        int i;
        if (startIndex > certs.length - 1) {
            return null;
        }
        for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
        }
        int certChainSize = i - startIndex + 1;
        X509Certificate[] ret = new X509Certificate[certChainSize];
        for (int j = 0; j < certChainSize; ++j) {
            ret[j] = (X509Certificate)certs[startIndex + j];
        }
        return ret;
    }

    protected void finalize() throws Throwable {
        if (!this.retrievedJarFile) {
            this.jarFile.close();
        }
    }
}

