/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.CK_VERSION;
import com.ibm.pkcs11.PKCS11Object;
import ibm.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class PKCS11TlsRsaPremasterSecretGenerator
extends KeyGeneratorSpi {
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11TlsRsaPremasterSecretGenerator";
    private SessionManager sessionManager = null;
    private Config config = null;
    private KeyMechanismBuilder mechanismBuilder;
    private TlsRsaPremasterSecretParameterSpec spec;
    private int mechanism;

    public PKCS11TlsRsaPremasterSecretGenerator(Provider provider, String algorithm, int mechanism) {
        IBMPKCS11Impl.verifyJceJar();
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(algorithm);
        this.mechanism = mechanism;
        if (debug != null) {
            debug.text(16384L, (Object)className, "PKCS11TlsRsaPremasterSecretGenerator()", "get mechanism type=" + mechanism);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null || !(params instanceof TlsRsaPremasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be specified and be an instance of TlsRsaPremasterSecretParameterSpec");
        }
        this.spec = (TlsRsaPremasterSecretParameterSpec)params;
        int major = this.spec.getMajorVersion();
        int minor = this.spec.getMinorVersion();
        if (major != 3 || this.config == null) throw new InvalidAlgorithmParameterException("not a supported major version " + major);
        if (minor == 0) {
            if (!this.config.supportMechanism(880)) throw new InvalidAlgorithmParameterException("not a supported minor version " + minor);
            this.mechanism = 880;
            if (debug == null) return;
            debug.text(16384L, (Object)className, "engineInit()", "get mechanism type=" + this.mechanism);
            return;
        } else {
            if (minor != 1) throw new InvalidAlgorithmParameterException("not a supported minor version " + minor);
            if (!this.config.supportMechanism(884)) throw new InvalidAlgorithmParameterException("not a supported minor version " + minor);
            this.mechanism = 884;
            if (debug == null) return;
            debug.text(16384L, (Object)className, "engineInit()", "get mechanism type=" + this.mechanism);
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException("params must be specified and be an instance of TlsRsaPremasterSecretParameterSpec");
    }

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException("params must be specified and be an instance of TlsRsaPremasterSecretParameterSpec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateKey() {
        GeneralKey genKey;
        if (this.spec == null) {
            throw new IllegalStateException("TlsRsaPremasterSecretGenerator must be initialized");
        }
        byte[] b = this.spec.getEncodedSecret();
        if (b != null) {
            return new SecretKeySpec(b, "TlsRsaPremasterSecret");
        }
        PKCS11Object obj = null;
        HashMap<Integer, Object> hattrs = new HashMap<Integer, Object>();
        int[] attrTypes = null;
        Object[] attrValues = null;
        if (this.config != null) {
            hattrs.putAll(this.config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, PKCS11Object.GENERIC_SECRET));
            hattrs.put(353, 48);
            if (!hattrs.isEmpty()) {
                attrTypes = new int[hattrs.size()];
                attrValues = new Object[hattrs.size()];
                Set keys = hattrs.keySet();
                Iterator it = keys.iterator();
                Integer key = null;
                int i = 0;
                while (it.hasNext()) {
                    key = (Integer)it.next();
                    attrTypes[i] = key;
                    attrValues[i] = hattrs.get(key);
                    ++i;
                }
            }
        } else {
            attrTypes = new int[]{};
            attrValues = new Object[]{};
        }
        if (debug != null) {
            for (int i = 0; i < attrTypes.length; ++i) {
                debug.text(16384L, (Object)className, "engineGenerateKey", "attrType=" + attrTypes[i] + ", attrValue=" + attrValues[i]);
            }
        }
        int major = this.spec.getMajorVersion();
        int minor = this.spec.getMinorVersion();
        CK_VERSION version = new CK_VERSION((byte)major, (byte)minor);
        Session session = null;
        try {
            session = this.sessionManager.getObjSession();
            obj = session.generateKey(this.mechanism, version, attrTypes, attrValues);
            session.addObject();
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGenerateKey", (Throwable)ex);
            }
            this.sessionManager.releaseSession(session);
            throw new RuntimeException(ex.getMessage());
        }
        try {
            genKey = new GeneralKey(session, obj, "TlsRsaPremasterSecret");
        }
        catch (Exception e) {
            genKey = null;
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
        return genKey;
    }
}

