/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public class PSSParameters
extends AlgorithmParametersSpi {
    protected AlgorithmId hashAlgorithm;
    protected AlgorithmId maskGenAlgorithm;
    protected AlgorithmParameterSpec mgfParameterSpec;
    protected int saltLength;
    protected int trailerField;
    byte TAG0 = DerValue.createTag((byte)-128, (boolean)true, (byte)0);
    byte TAG1 = DerValue.createTag((byte)-128, (boolean)true, (byte)1);
    byte TAG2 = DerValue.createTag((byte)-128, (boolean)true, (byte)2);
    byte TAG3 = DerValue.createTag((byte)-128, (boolean)true, (byte)3);

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof PSSParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        try {
            this.hashAlgorithm = AlgorithmId.get((String)((PSSParameterSpec)paramSpec).getDigestAlgorithm());
            this.maskGenAlgorithm = AlgorithmId.get((String)((PSSParameterSpec)paramSpec).getMGFAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidParameterSpecException(e.toString());
        }
        this.mgfParameterSpec = ((PSSParameterSpec)paramSpec).getMGFParameters();
        this.saltLength = ((PSSParameterSpec)paramSpec).getSaltLength();
        this.trailerField = ((PSSParameterSpec)paramSpec).getTrailerField();
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        this.decodePSSParameters(params);
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        String hashAlgName = this.hashAlgorithm.getName();
        String defaultHashAlgName = null;
        try {
            defaultHashAlgName = AlgorithmId.get((String)PSSParameterSpec.DEFAULT.getDigestAlgorithm()).getName();
        }
        catch (NoSuchAlgorithmException nsae) {
            defaultHashAlgName = null;
        }
        if (!hashAlgName.equalsIgnoreCase(defaultHashAlgName)) {
            DerValue derValueHash = this.encodeHashAlg(this.hashAlgorithm);
            out.putDerValue(derValueHash);
        }
        if (!this.maskGenAlgorithm.getName().equalsIgnoreCase(PSSParameterSpec.DEFAULT.getMGFAlgorithm())) {
            DerValue derValueMaskGen = this.encodeMaskGenAlg(this.maskGenAlgorithm, this.mgfParameterSpec);
            out.putDerValue(derValueMaskGen);
        } else if (this.mgfParameterSpec != null) {
            String mgf1DigestAlgName = ((MGF1ParameterSpec)this.mgfParameterSpec).getDigestAlgorithm();
            String normDigestAlgName = null;
            AlgorithmParameterSpec defaultAlgParamSpec = PSSParameterSpec.DEFAULT.getMGFParameters();
            String defaultMGFDigest = null;
            try {
                normDigestAlgName = AlgorithmId.get((String)mgf1DigestAlgName).getName();
                defaultMGFDigest = AlgorithmId.get((String)((MGF1ParameterSpec)defaultAlgParamSpec).getDigestAlgorithm()).getName();
            }
            catch (NoSuchAlgorithmException e) {
                out.close();
                throw new IOException("NoSuchAlgorithmException during encoding operations.");
            }
            if (normDigestAlgName != null && !normDigestAlgName.equalsIgnoreCase(defaultMGFDigest)) {
                DerValue derValueMaskGen = this.encodeMaskGenAlg(this.maskGenAlgorithm, this.mgfParameterSpec);
                out.putDerValue(derValueMaskGen);
            }
        }
        if (this.saltLength != PSSParameterSpec.DEFAULT.getSaltLength()) {
            DerValue derValueSalt = this.encodeSalt(this.saltLength);
            out.putDerValue(derValueSalt);
        }
        if (this.trailerField != PSSParameterSpec.DEFAULT.getTrailerField()) {
            DerValue derValueTrailerField = this.encodeTrailerField(this.trailerField);
            out.putDerValue(derValueTrailerField);
        }
        DerValue val = new DerValue(48, out.toByteArray());
        byte[] encodedPSSParameters = val.toByteArray();
        out.close();
        return encodedPSSParameters;
    }

    protected DerValue encodeSalt(int salt) throws IOException {
        try {
            DerOutputStream out = new DerOutputStream();
            byte tag = DerValue.createTag((byte)-128, (boolean)true, (byte)2);
            out.putInteger(this.saltLength);
            DerValue val = new DerValue(tag, out.toByteArray());
            out.close();
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in hashAlgorithm(): " + e);
        }
    }

    protected DerValue encodeTrailerField(int trailerField) throws IOException {
        try {
            DerOutputStream out = new DerOutputStream();
            byte tag = DerValue.createTag((byte)-128, (boolean)true, (byte)3);
            out.putInteger(trailerField);
            DerValue val = new DerValue(tag, out.toByteArray());
            out.close();
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in hashAlgorithm(): " + e);
        }
    }

    protected DerValue encodeHashAlg(AlgorithmId hashAlgorithm) throws IOException {
        try {
            DerOutputStream out = new DerOutputStream();
            out.putOID(hashAlgorithm.getOID());
            out.putNull();
            DerValue val1 = new DerValue(48, out.toByteArray());
            out.close();
            DerOutputStream out1 = new DerOutputStream();
            out1.putDerValue(val1);
            byte tag = DerValue.createTag((byte)-128, (boolean)true, (byte)0);
            DerValue val = new DerValue(tag, out1.toByteArray());
            out1.close();
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in hashAlgorithm(): " + e);
        }
    }

    private AlgorithmId decodeHashAlgorithm(DerValue encodedHashAlg) throws IOException {
        try {
            if (encodedHashAlg.getTag() != this.TAG0) {
                throw new IOException("Not a TAG0 encoding");
            }
            DerInputStream data1 = encodedHashAlg.getData();
            DerValue derValue1 = data1.getDerValue();
            DerInputStream data = derValue1.getData();
            ObjectIdentifier hashOID = data.getOID();
            AlgorithmId hashAlgID = new AlgorithmId(hashOID);
            return hashAlgID;
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            throw new IOException("Exception in decodeHashAlgorithm (): " + e);
        }
    }

    private int decodeSaltLength(DerValue encodedSaltLength) throws IOException {
        try {
            if (encodedSaltLength.getTag() != this.TAG2) {
                throw new IOException("Not a TAG2 encoding");
            }
            DerInputStream data = encodedSaltLength.getData();
            int saltLength = data.getInteger().intValue();
            return saltLength;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeSaltLength (): " + e);
        }
    }

    private int decodeTrailerField(DerValue encodedTrailerField) throws IOException {
        try {
            if (encodedTrailerField.getTag() != this.TAG3) {
                throw new IOException("Not a TAG3 encoding for trailerField");
            }
            DerInputStream data = encodedTrailerField.getData();
            int trailerField = data.getInteger().intValue();
            return trailerField;
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            throw new IOException("Exception in decodeTrailerField (): " + e);
        }
    }

    protected DerValue encodeMaskGenAlg(AlgorithmId maskGenAlgorithm, AlgorithmParameterSpec mgf1ParameterSpec) throws IOException {
        try {
            DerOutputStream out = new DerOutputStream();
            out.putOID(maskGenAlgorithm.getOID());
            if (this.mgfParameterSpec != null) {
                DerValue mgfDigest = this.encodeMgfParameterSpec(this.mgfParameterSpec);
                out.putDerValue(mgfDigest);
            }
            out.close();
            DerValue val1 = new DerValue(48, out.toByteArray());
            DerOutputStream out1 = new DerOutputStream();
            out1.putDerValue(val1);
            byte tag = DerValue.createTag((byte)-128, (boolean)true, (byte)1);
            DerValue val = new DerValue(tag, out1.toByteArray());
            out1.close();
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in MGF1Parameters: " + e);
        }
    }

    protected DerValue encodeMgfParameterSpec(AlgorithmParameterSpec mgfParameterSpec) throws IOException {
        try {
            DerOutputStream out = new DerOutputStream();
            String mgfDigestName = ((MGF1ParameterSpec)mgfParameterSpec).getDigestAlgorithm();
            out.putOID(AlgorithmId.get((String)mgfDigestName).getOID());
            out.putNull();
            DerValue val = new DerValue(48, out.toByteArray());
            out.close();
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in encodeMGfParameterSpec(): " + e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Exception in encodeMGfParameterSpec(): " + e);
        }
    }

    public PSSParameterSpec decodePSSParameters(byte[] encodedPSSParameters) throws IOException {
        try {
            DerInputStream derInputStreamParams = new DerInputStream(encodedPSSParameters);
            DerValue[] values = derInputStreamParams.getSequence(0);
            if (values == null) {
                return null;
            }
            try {
                this.hashAlgorithm = AlgorithmId.get((String)PSSParameterSpec.DEFAULT.getDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException e1) {
                throw new IOException("NoSuchAlgorithmException during decoding operations.");
            }
            try {
                this.maskGenAlgorithm = AlgorithmId.get((String)PSSParameterSpec.DEFAULT.getMGFAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("NoSuchAlgorithmException during decoding operations.");
            }
            this.mgfParameterSpec = PSSParameterSpec.DEFAULT.getMGFParameters();
            this.saltLength = PSSParameterSpec.DEFAULT.getSaltLength();
            this.trailerField = PSSParameterSpec.DEFAULT.getTrailerField();
            for (int i = 0; i < values.length; ++i) {
                byte tag = values[i].getTag();
                if (tag == this.TAG0) {
                    this.hashAlgorithm = this.decodeHashAlgorithm(values[i]);
                    continue;
                }
                if (tag == this.TAG1) {
                    this.maskGenAlgorithm = this.decodeMaskGenAlgorithm(values[i]);
                    continue;
                }
                if (tag == this.TAG2) {
                    this.saltLength = this.decodeSaltLength(values[i]);
                    continue;
                }
                if (tag == this.TAG3) {
                    this.trailerField = this.decodeTrailerField(values[i]);
                    continue;
                }
                throw new IOException("Unknown tag in the asn.1 encoding" + tag);
            }
            PSSParameterSpec pssParameterSpec = new PSSParameterSpec(this.hashAlgorithm.getName(), this.maskGenAlgorithm.getName(), this.mgfParameterSpec, this.saltLength, this.trailerField);
            return pssParameterSpec;
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            throw new IOException("Exception in decodePSSParameters(): " + e);
        }
    }

    private AlgorithmId decodeMaskGenAlgorithm(DerValue encodedMaskGenAlg) throws IOException {
        try {
            DerInputStream data1 = encodedMaskGenAlg.getData();
            DerValue derValue1 = data1.getDerValue();
            if (derValue1.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue1.getData();
            ObjectIdentifier maskGenOID = data.getOID();
            AlgorithmId maskGenAlgID = new AlgorithmId(maskGenOID);
            if (data.available() > 0) {
                DerValue encodedMGF1Parameters = data.getDerValue();
                this.mgfParameterSpec = this.decodeMGF1ParameterSpec(encodedMGF1Parameters);
            }
            return maskGenAlgID;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeMaskGenAlgorithm (): " + e);
        }
    }

    private AlgorithmParameterSpec decodeMGF1ParameterSpec(DerValue encodedMGF1Parameters) throws IOException {
        try {
            if (encodedMGF1Parameters.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = encodedMGF1Parameters.getData();
            ObjectIdentifier mgf1DigestOID = data.getOID();
            String mgf1DigestName = new AlgorithmId(mgf1DigestOID).getName();
            MGF1ParameterSpec mgf1ParameterSpec = new MGF1ParameterSpec(mgf1DigestName);
            return mgf1ParameterSpec;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeMGF1ParameterSpec(): " + e);
        }
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        try {
            Class<?> pssParamSpec = Class.forName("java.security.spec.PSSParameterSpec");
            if (pssParamSpec.isAssignableFrom(paramSpec)) {
                return new PSSParameterSpec(this.hashAlgorithm.getName(), this.maskGenAlgorithm.getName(), this.mgfParameterSpec, this.saltLength, this.trailerField);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected String engineToString() {
        String mdName = this.mgfParameterSpec == null ? this.hashAlgorithm.getName() : ((MGF1ParameterSpec)this.mgfParameterSpec).getDigestAlgorithm();
        return "\n\thashAlgorithm: " + this.hashAlgorithm + "\n\tmaskGenAlgorithm: " + this.maskGenAlgorithm + "\n\tmgf1ParameterSpec: " + mdName + "\n\tsaltLength: " + Integer.toString(this.saltLength) + "\n\ttrailerField: " + Integer.toString(this.trailerField) + "\n";
    }

    protected static AlgorithmParameters getAlgorithmParameters(PSSParameterSpec spec) throws InvalidKeyException, InvalidParameterSpecException {
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance("RSAPSS", "IBMJCE");
            params.init(spec);
            return params;
        }
        catch (GeneralSecurityException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e);
        }
    }

    String toHex(byte[] data) {
        String digits = "0123456789abcdef";
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int v = data[i] & 0xFF;
            buf.append(digits.charAt(v >> 4));
            buf.append(digits.charAt(v & 0xF));
        }
        return buf.toString();
    }
}

