/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.gss;

import com.ibm.xml.crypto.dsig.Constants;
import com.ibm.xml.crypto.spi.SignatureEngine;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class SignatureEngineGSSMIC
implements SignatureEngine,
Constants {
    public static final String KEY_ALGORITHM = "GSS";
    private GSSContext fContext;
    private ByteArrayOutputStream fData;
    private MessageProp fMessageProp;

    private void init(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Key not specified");
        }
        String s = key.getAlgorithm();
        if (!KEY_ALGORITHM.equalsIgnoreCase(s)) {
            throw new InvalidKeyException("Unknown algorithm: " + s);
        }
        this.fContext = (GSSContext)((Object)key);
        if (this.fData == null) {
            this.fData = new ByteArrayOutputStream();
        }
        if (this.fMessageProp == null) {
            this.fMessageProp = new MessageProp(false);
        }
    }

    @Override
    public void setParameter(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec != null) {
            throw new InvalidAlgorithmParameterException("Unknown parameter: " + spec);
        }
    }

    @Override
    public String getURI() {
        return "http://schemas.xmlsoap.org/ws/2003/12/IETF-RFC2743#GSS_MIC";
    }

    @Override
    public void initSign(Key key) throws InvalidKeyException {
        this.init(key);
    }

    @Override
    public void initVerify(Key key) throws InvalidKeyException {
        this.init(key);
    }

    @Override
    public void update(byte[] data) throws SignatureException {
        this.update(data, 0, data != null ? data.length : 0);
    }

    @Override
    public void update(byte[] data, int off, int len) throws SignatureException {
        if (data == null) {
            throw new NullPointerException("Data not specified");
        }
        this.fData.write(data, off, len);
    }

    @Override
    public byte[] sign() throws SignatureException {
        byte[] bb = this.fData.toByteArray();
        this.fMessageProp.setQOP(0);
        this.fMessageProp.setPrivacy(false);
        byte[] signature = null;
        try {
            signature = this.fContext.getMIC(bb, 0, bb.length, this.fMessageProp);
        }
        catch (GSSException e) {
            throw new SignatureException(e.toString());
        }
        this.fData.reset();
        return signature;
    }

    @Override
    public boolean verify(byte[] signature) throws SignatureException {
        if (signature == null) {
            throw new NullPointerException("Signature not specified");
        }
        byte[] bb = this.fData.toByteArray();
        boolean valid = true;
        try {
            this.fContext.verifyMIC(signature, 0, signature.length, bb, 0, bb.length, this.fMessageProp);
        }
        catch (GSSException e) {
            if (6 != e.getMajor()) {
                throw new SignatureException(e.toString());
            }
            valid = false;
        }
        this.fData.reset();
        return valid;
    }
}

