/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Util;
import java.math.BigInteger;
import java.util.Vector;

public final class TraceArgs {
    public static String traceFile;
    public static String outputFile;
    public static boolean indent;
    public static boolean summary;
    public static boolean debug;
    public static boolean symbolic;
    public static boolean isHelpOnly;
    public static boolean gui;
    public static boolean j9;
    public static boolean verbose;
    public static String userVMIdentifier;
    public static BigInteger timeZoneOffset;
    public static boolean is50orNewer;
    public static boolean override;
    public static String datFileDirectory;

    protected static final void initStatics() {
        traceFile = null;
        outputFile = null;
        indent = false;
        summary = false;
        debug = false;
        symbolic = false;
        gui = false;
        j9 = false;
        userVMIdentifier = null;
        is50orNewer = false;
        override = false;
    }

    public TraceArgs(String[] args) throws UsageException {
        if (args.length > 0) {
            if (args[0].equals("-help")) {
                isHelpOnly = true;
            } else {
                traceFile = args[0];
            }
            if (args.length > 1) {
                int index;
                if (args[1].startsWith("-")) {
                    outputFile = args[0] + ".fmt";
                    index = 1;
                } else {
                    outputFile = args[1];
                    index = 2;
                }
                while (index < args.length) {
                    if (args[index].equals("-summary")) {
                        summary = true;
                    } else if (args[index].startsWith("-entries:")) {
                        this.parseComponentParameter(args[index]);
                    } else if (args[index].startsWith("-thread:")) {
                        this.parseThread(args[index]);
                    } else if (args[index].equals("-indent")) {
                        indent = true;
                    } else if (args[index].equals("-symbolic")) {
                        symbolic = true;
                    } else if (args[index].equals("-help")) {
                        isHelpOnly = true;
                    } else if (args[index].equals("-version")) {
                        System.out.println("TraceFormat Version 1.0");
                    } else if (args[index].equals("-debug")) {
                        debug = true;
                        verbose = true;
                    } else if (args[index].equals("-j9")) {
                        j9 = true;
                    } else if (args[index].equals("-verbose")) {
                        verbose = true;
                    } else if (args[index].equalsIgnoreCase("-uservmid")) {
                        if (++index >= args.length || args[index].startsWith("-")) {
                            throw new UsageException("no uservmid string provided");
                        }
                        userVMIdentifier = args[index];
                    } else if (args[index].equalsIgnoreCase("-overridetimezone")) {
                        if (++index >= args.length) {
                            throw new UsageException("no time provided with overridetimezone option");
                        }
                        try {
                            int offset = Integer.parseInt(args[index]);
                            System.out.println("All formatted tracepoints will be formatted with an offset to the hours field of " + offset + "hours.");
                            timeZoneOffset = new BigInteger(args[index]);
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Cannot format " + args[index] + " into an integer to use as an hour offset in Trace Formatter.");
                            System.err.println(nfe);
                            throw new UsageException("please specify an integer value after -overridetimezone that will be used as an offset for the formatted hour field");
                        }
                    } else if (args[index].startsWith("-50")) {
                        is50orNewer = true;
                    } else if (args[index].startsWith("-11")) {
                        is50orNewer = false;
                        override = true;
                    } else if (args[index].startsWith("-datdir")) {
                        if (++index >= args.length || args[index].startsWith("-")) {
                            throw new UsageException("no dat file directory name provided");
                        }
                        datFileDirectory = new String(args[index]);
                    } else {
                        throw new UsageException();
                    }
                    ++index;
                }
            } else {
                outputFile = args[0] + ".fmt";
            }
        } else {
            throw new UsageException();
        }
    }

    private void parseComponentParameter(String comp) throws UsageException {
        String compString = comp.substring("-entries:".length());
        this.parseComponents(compString);
    }

    private void parseComponents(String compString) throws UsageException {
        int paren = compString.indexOf("(");
        int comma = compString.indexOf(",");
        if (comma != -1) {
            if (comma < paren) {
                this.parseComponent(compString.substring(0, comma));
                this.parseComponents(compString.substring(comma + 1, compString.length()));
            } else {
                int closeParen = compString.indexOf(")");
                this.parseComponent(compString.substring(0, closeParen + 1));
                int nextComma = compString.indexOf(",", closeParen);
                if (nextComma != -1) {
                    this.parseComponents(compString.substring(nextComma + 1, compString.length()));
                }
            }
        } else {
            this.parseComponent(compString);
        }
    }

    private void parseComponent(String component) throws UsageException {
        int open = component.indexOf("(");
        int close = component.indexOf(")");
        if (close < open) {
            throw new UsageException();
        }
        if (close == open) {
            Util.putComponent(component);
        } else {
            int index;
            Vector<String> types = new Vector<String>(10);
            String temp = component.substring(open + 1, component.length() - 1);
            while ((index = temp.indexOf(",")) != -1) {
                types.addElement(temp.substring(0, index));
                temp = temp.substring(index + 1, temp.length());
            }
            types.addElement(temp.substring(0, temp.length()));
            Util.putComponent(component.substring(0, open), types);
        }
    }

    private void parseThread(String thread) throws UsageException {
        String id = null;
        try {
            int index;
            String temp = thread.substring("-thread:".length());
            while ((index = temp.indexOf(",")) != -1) {
                id = temp.substring(0, index);
                Util.putThreadID(Long.decode(id));
                temp = temp.substring(index + 1, temp.length());
            }
            id = temp.substring(0, temp.length());
            Util.putThreadID(Long.decode(id));
        }
        catch (NumberFormatException nfe) {
            throw new UsageException("Bad thread ID: " + id);
        }
    }

    static {
        timeZoneOffset = BigInteger.ZERO;
        datFileDirectory = null;
    }

    class UsageException
    extends Exception {
        UsageException(String s) {
            super(s);
        }

        UsageException() {
        }
    }
}

