/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TracePoint;
import com.ibm.jvm.format.TraceRecord50;
import com.ibm.jvm.format.Util;
import com.ibm.jvm.trace.TracePointThreadChronologicalIterator;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Vector;

public final class TraceThread
extends Vector
implements com.ibm.jvm.trace.TraceThread {
    protected long threadID = 0L;
    protected String threadName;
    private TracePoint tp = null;
    private boolean primed = false;
    private TraceRecord50 currentTraceRecord = null;
    private int currentIndent = 0;
    public static int numBufs = 0;

    protected TraceThread(long ID, String threadName) {
        this.threadID = ID;
        this.threadName = threadName;
    }

    public static int getBuffersProcessed() {
        return numBufs;
    }

    private static synchronized void incrementBuffersProcessed() {
        ++numBufs;
    }

    private synchronized void prime() {
        if (!this.primed) {
            this.popTopTraceRecord();
            this.primed = true;
        }
    }

    private void popTopTraceRecord() {
        TraceRecord50 oldTraceRecord = this.currentTraceRecord;
        if (this.isEmpty()) {
            Util.Debug.println("last trace record popped from trace thread");
            Util.Debug.println("TraceThread " + Util.formatAsHexString(this.threadID) + " emptied");
            this.currentTraceRecord = null;
            return;
        }
        this.currentTraceRecord = (TraceRecord50)this.elementAt(0);
        byte[] extraData = null;
        BigInteger lastUpperWord = null;
        if (oldTraceRecord != null) {
            lastUpperWord = oldTraceRecord.getLastUpperWord();
            extraData = oldTraceRecord.getExtraData();
        }
        while (this.currentTraceRecord != null && this.currentTraceRecord.isMiddleOfTracePoint()) {
            byte[] temp = null;
            byte[] current = extraData;
            Util.Debug.println("\nTraceThread has found a pure middle of tracepoint buffer\n");
            temp = this.currentTraceRecord.getExtraData();
            Util.Debug.println("It's on thread " + Util.formatAsHexString(this.currentTraceRecord.getThreadIDAsLong()));
            Util.printDump(temp, temp.length);
            if (extraData == null) {
                Util.Debug.println("Adding the middle in - temp.length " + temp.length);
                extraData = new byte[temp.length];
                System.arraycopy(temp, 0, extraData, 0, temp.length);
            } else {
                extraData = new byte[current.length + temp.length];
                Util.Debug.println("Adding the middle in - current " + current.length + " temp.length " + temp.length);
                System.arraycopy(current, 0, extraData, 0, current.length);
                System.arraycopy(temp, 0, extraData, current.length, temp.length);
            }
            if (this.size() > 1) {
                this.removeElementAt(0);
                TraceThread.incrementBuffersProcessed();
                this.currentTraceRecord = (TraceRecord50)this.elementAt(0);
                continue;
            }
            this.currentTraceRecord = null;
        }
        if (this.currentTraceRecord != null) {
            if (extraData != null) {
                this.currentTraceRecord.addOverspillData(extraData, lastUpperWord);
            }
            this.tp = this.currentTraceRecord.getNextTracePoint();
            while (this.tp == null && this.size() > 1) {
                this.removeElementAt(0);
                TraceThread.incrementBuffersProcessed();
                this.currentTraceRecord = (TraceRecord50)this.elementAt(0);
                if (this.currentTraceRecord == null) continue;
                this.tp = this.currentTraceRecord.getNextTracePoint();
            }
        }
        this.removeElementAt(0);
        TraceThread.incrementBuffersProcessed();
    }

    public TracePoint getNextTracePoint() {
        TracePoint ret = this.tp;
        if (!this.primed) {
            this.prime();
        }
        if (this.currentTraceRecord != null) {
            this.tp = this.currentTraceRecord.getNextTracePoint();
            if (this.tp == null) {
                this.popTopTraceRecord();
            }
        } else {
            this.tp = null;
        }
        return ret;
    }

    public int getIndent() {
        return this.currentIndent;
    }

    public void indent() {
        ++this.currentIndent;
    }

    public void outdent() {
        --this.currentIndent;
        if (this.currentIndent < 0) {
            this.currentIndent = 0;
        }
    }

    public BigInteger getTimeOfNextTracePoint() {
        if (!this.primed) {
            this.prime();
        }
        if (this.tp != null) {
            return this.tp.getRawTimeStamp();
        }
        if (this.size() > 0) {
            this.popTopTraceRecord();
            if (this.tp != null) {
                return this.tp.getRawTimeStamp();
            }
        }
        return null;
    }

    @Override
    public Iterator getChronologicalTracePointIterator() {
        return new TracePointThreadChronologicalIterator(this);
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public long getThreadID() {
        return this.threadID;
    }
}

