/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.AdaptableX509CertSelector;
import com.ibm.security.cert.AlgorithmChecker;
import com.ibm.security.cert.PKIX;
import com.ibm.security.cert.URICertStore;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.CRLDistributionPointsExtension;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.IssuingDistributionPointExtension;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.ReasonFlags;
import com.ibm.security.x509.SerialNumber;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.util.Debug;

public class DistributionPointFetcher {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};

    private DistributionPointFetcher() {
    }

    public static Collection<X509CRL> getCRLs(X509CRLSelector selector, boolean signFlag, PublicKey prevKey, String provider, List<CertStore> certStores, boolean[] reasonsMask, Set<TrustAnchor> trustAnchors, Date validity, String variant) throws CertStoreException {
        return DistributionPointFetcher.getCRLs(selector, signFlag, prevKey, null, provider, certStores, reasonsMask, trustAnchors, validity, variant);
    }

    public static Collection<X509CRL> getCRLs(X509CRLSelector selector, boolean signFlag, PublicKey prevKey, String provider, List<CertStore> certStores, boolean[] reasonsMask, Set<TrustAnchor> trustAnchors, Date validity) throws CertStoreException {
        return DistributionPointFetcher.getCRLs(selector, signFlag, prevKey, null, provider, certStores, reasonsMask, trustAnchors, validity, "generic");
    }

    public static Collection<X509CRL> getCRLs(X509CRLSelector selector, boolean signFlag, PublicKey prevKey, X509Certificate prevCert, String provider, List<CertStore> certStores, boolean[] reasonsMask, Set<TrustAnchor> trustAnchors, Date validity, String variant) throws CertStoreException {
        X509Certificate cert = selector.getCertificateChecking();
        if (cert == null) {
            return Collections.emptySet();
        }
        try {
            CRLDistributionPointsExtension ext;
            X509CertImpl certImpl = X509CertImpl.toImpl((X509Certificate)cert);
            if (debug != null) {
                debug.println("DistributionPointFetcher.getCRLs: Checking CRLDPs for " + certImpl.getSubjectX500Principal());
            }
            if ((ext = certImpl.getCRLDistributionPointsExtension()) == null) {
                if (debug != null) {
                    debug.println("No CRLDP ext");
                }
                return Collections.emptySet();
            }
            DistributionPoint[] pointsArray = ext.get("points");
            ArrayList<DistributionPoint> points = new ArrayList<DistributionPoint>();
            for (int ii = 0; ii < pointsArray.length; ++ii) {
                if (pointsArray[ii] == null) continue;
                points.add(pointsArray[ii]);
            }
            HashSet<X509CRL> results = new HashSet<X509CRL>();
            Iterator t = points.iterator();
            while (t.hasNext() && !Arrays.equals(reasonsMask, ALL_REASONS)) {
                DistributionPoint point = (DistributionPoint)t.next();
                Collection<X509CRL> crls = DistributionPointFetcher.getCRLs(selector, certImpl, point, reasonsMask, signFlag, prevKey, prevCert, provider, certStores, trustAnchors, validity, variant);
                results.addAll(crls);
            }
            if (debug != null) {
                debug.println("Returning " + results.size() + " CRLs");
            }
            return results;
        }
        catch (IOException | CertificateException e) {
            return Collections.emptySet();
        }
    }

    private static Collection<X509CRL> getCRLs(X509CRLSelector selector, X509CertImpl certImpl, DistributionPoint point, boolean[] reasonsMask, boolean signFlag, PublicKey prevKey, X509Certificate prevCert, String provider, List<CertStore> certStores, Set<TrustAnchor> trustAnchors, Date validity, String variant) throws CertStoreException {
        GeneralNames fullName;
        block16: {
            fullName = point.getFullName();
            if (fullName == null) {
                RDN relativeName = point.getRelativeName();
                if (relativeName == null) {
                    return Collections.emptySet();
                }
                try {
                    GeneralNames crlIssuers = point.getCRLIssuer();
                    if (crlIssuers == null) {
                        fullName = DistributionPointFetcher.getFullNames((X500Name)certImpl.getIssuerDN(), relativeName);
                        break block16;
                    }
                    if (crlIssuers.size() != 1) {
                        return Collections.emptySet();
                    }
                    try {
                        fullName = DistributionPointFetcher.getFullNames((X500Name)crlIssuers.getGeneralName(0).getName(), relativeName);
                    }
                    catch (GeneralNamesException ex) {
                        return Collections.emptySet();
                    }
                }
                catch (IOException ioe) {
                    return Collections.emptySet();
                }
            }
        }
        ArrayList<X509CRL> possibleCRLs = new ArrayList<X509CRL>();
        CertStoreException savedCSE = null;
        Iterator t = fullName.iterator();
        while (t.hasNext()) {
            try {
                URIName uriName;
                X509CRL crl;
                GeneralName name = (GeneralName)t.next();
                if (name.getType() == 4) {
                    X500Name x500Name = (X500Name)name.getName();
                    possibleCRLs.addAll(DistributionPointFetcher.getCRLs(x500Name, certImpl.getIssuerX500Principal(), certStores));
                    continue;
                }
                if (name.getType() != 6 || (crl = DistributionPointFetcher.getCRL(uriName = (URIName)name.getName())) == null) continue;
                possibleCRLs.add(crl);
            }
            catch (CertStoreException cse) {
                savedCSE = cse;
            }
        }
        if (possibleCRLs.isEmpty() && savedCSE != null) {
            throw savedCSE;
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(2);
        for (X509CRL crl : possibleCRLs) {
            try {
                selector.setIssuerNames(null);
                if (!selector.match(crl) || !DistributionPointFetcher.verifyCRL(certImpl, point, crl, reasonsMask, signFlag, prevKey, prevCert, provider, trustAnchors, certStores, validity, variant)) continue;
                crls.add(crl);
            }
            catch (IOException | CRLException e) {
                if (debug == null) continue;
                debug.println("Exception verifying CRL: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return crls;
    }

    private static X509CRL getCRL(URIName name) throws CertStoreException {
        Collection<? extends CRL> crls;
        URI uri = name.getURI();
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + uri);
        }
        CertStore ucs = null;
        try {
            ucs = URICertStore.getInstance(new URICertStore.URICertStoreParameters(uri));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.println("Can't create URICertStore: " + e.getMessage());
            }
            return null;
        }
        if (debug != null) {
            System.out.println("DistributionPointFetcher.java:  getCRL(URIName):  Calling URICertStore.getCRLs() for the following URIName:  " + name);
        }
        if ((crls = ucs.getCRLs(null)).isEmpty()) {
            return null;
        }
        return (X509CRL)crls.iterator().next();
    }

    private static Collection<X509CRL> getCRLs(X500Name name, X500Principal certIssuer, List<CertStore> certStores) throws CertStoreException {
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + name);
        }
        X509CRLSelector xcs = new X509CRLSelector();
        X500Principal x500Principal = new X500Principal(name.getName());
        xcs.addIssuer(x500Principal);
        xcs.addIssuer(certIssuer);
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        PKIX.CertStoreTypeException savedCSE = null;
        if (debug != null) {
            System.out.println("DistributionPointFetcher.java:  getCRL(X500Name, X500Principal, List CertStores):  There are " + certStores.size() + " CertStores in the CertStores List passed in.");
        }
        for (CertStore store : certStores) {
            try {
                if (debug != null) {
                    System.out.println("DistributionPointFetcher.java:  getCRL(X500Name, X500Principal, List CertStores):  The next certstore to be processed is a:  " + store.getType());
                    System.out.println("DistributionPointFetcher.java:  getCRL(X500Name, X500Principal, List CertStores):  For this CertStore, calling certstore.getCRLs() with an X509CRLSelector for the issuer:  " + x500Principal);
                }
                for (CRL cRL : store.getCRLs(xcs)) {
                    crls.add((X509CRL)cRL);
                }
            }
            catch (CertStoreException cse) {
                if (debug != null) {
                    debug.println("Exception while retrieving CRLs: " + cse);
                    cse.printStackTrace();
                }
                savedCSE = new PKIX.CertStoreTypeException(store.getType(), cse);
            }
        }
        if (crls.isEmpty() && savedCSE != null) {
            throw savedCSE;
        }
        return crls;
    }

    static boolean verifyCRL(X509CertImpl certImpl, DistributionPoint point, X509CRL crl, boolean[] reasonsMask, boolean signFlag, PublicKey prevKey, X509Certificate prevCert, String provider, Set<TrustAnchor> trustAnchors, List<CertStore> certStores, Date validity, String variant) throws CRLException, IOException {
        int i;
        if (debug != null) {
            debug.println("DistributionPointFetcher.verifyCRL: checking revocation status for\n  SN: " + Debug.toHexString(certImpl.getSerialNumber()) + "\n  Subject: " + certImpl.getSubjectX500Principal() + "\n  Issuer: " + certImpl.getIssuerX500Principal());
        }
        boolean indirectCRL = false;
        X509CRLImpl crlImpl = X509CRLImpl.toImpl((X509CRL)crl);
        IssuingDistributionPointExtension idpExt = crlImpl.getIssuingDistributionPointExtension();
        X500Name certIssuer = (X500Name)certImpl.getIssuerDN();
        X500Name crlIssuer = (X500Name)crlImpl.getIssuerDN();
        GeneralNames pointCrlIssuers = point.getCRLIssuer();
        X500Name pointCrlIssuer = null;
        if (pointCrlIssuers != null) {
            if (idpExt == null || ((Boolean)idpExt.get("indirect_crl")).equals(Boolean.FALSE)) {
                return false;
            }
            boolean match = false;
            Iterator t = pointCrlIssuers.iterator();
            while (!match && t.hasNext()) {
                GeneralNameInterface name = ((GeneralName)t.next()).getName();
                if (!crlIssuer.equals((Object)name)) continue;
                pointCrlIssuer = (X500Name)name;
                match = true;
            }
            if (!match) {
                return false;
            }
            if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                prevKey = certImpl.getPublicKey();
            } else {
                indirectCRL = true;
            }
        } else {
            if (!crlIssuer.equals(certIssuer)) {
                if (debug != null) {
                    debug.println("crl issuer does not equal cert issuer.\ncrl issuer: " + crlIssuer + "\ncert issuer: " + certIssuer);
                }
                return false;
            }
            KeyIdentifier certAKID = certImpl.getAuthKeyId();
            KeyIdentifier crlAKID = crlImpl.getAuthKeyId();
            if (certAKID == null || crlAKID == null) {
                if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                    prevKey = certImpl.getPublicKey();
                }
            } else if (!certAKID.equals((Object)crlAKID)) {
                if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                    prevKey = certImpl.getPublicKey();
                } else {
                    indirectCRL = true;
                }
            }
        }
        if (!indirectCRL && !signFlag) {
            return false;
        }
        if (idpExt != null) {
            Boolean b;
            DistributionPointName idpPoint = (DistributionPointName)idpExt.get("distribution_pt");
            if (idpPoint != null) {
                GeneralNames idpNames = null;
                RDN relativeName = null;
                if (idpPoint instanceof GeneralNames) {
                    idpNames = (GeneralNames)idpPoint;
                } else if (idpPoint instanceof RDN) {
                    relativeName = (RDN)idpPoint;
                }
                if (idpNames == null) {
                    if (relativeName == null) {
                        if (debug != null) {
                            debug.println("IDP must be relative or full DN");
                        }
                        return false;
                    }
                    if (debug != null) {
                        debug.println("IDP relativeName:" + relativeName);
                    }
                    idpNames = DistributionPointFetcher.getFullNames(crlIssuer, relativeName);
                }
                if (point.getFullName() != null || point.getRelativeName() != null) {
                    GeneralNames pointNames = point.getFullName();
                    if (pointNames == null) {
                        relativeName = point.getRelativeName();
                        if (relativeName == null) {
                            if (debug != null) {
                                debug.println("DP must be relative or full DN");
                            }
                            return false;
                        }
                        if (debug != null) {
                            debug.println("DP relativeName:" + relativeName);
                        }
                        if (indirectCRL) {
                            if (pointCrlIssuers.size() != 1) {
                                if (debug != null) {
                                    debug.println("must only be one CRL issuer when relative name present");
                                }
                                return false;
                            }
                            pointNames = DistributionPointFetcher.getFullNames(pointCrlIssuer, relativeName);
                        } else {
                            pointNames = DistributionPointFetcher.getFullNames(certIssuer, relativeName);
                        }
                    }
                    boolean match = false;
                    Iterator i2 = idpNames.iterator();
                    while (!match && i2.hasNext()) {
                        GeneralNameInterface idpName = ((GeneralName)i2.next()).getName();
                        if (debug != null) {
                            debug.println("idpName: " + idpName);
                        }
                        Iterator p = pointNames.iterator();
                        while (!match && p.hasNext()) {
                            GeneralNameInterface pointName = ((GeneralName)p.next()).getName();
                            if (debug != null) {
                                debug.println("pointName: " + pointName);
                            }
                            match = idpName.equals(pointName);
                        }
                    }
                    if (!match) {
                        if (debug != null) {
                            debug.println("IDP name does not match DP name");
                        }
                        return false;
                    }
                } else {
                    boolean match = false;
                    Iterator t = pointCrlIssuers.iterator();
                    while (!match && t.hasNext()) {
                        GeneralNameInterface crlIssuerName = ((GeneralName)t.next()).getName();
                        Iterator i3 = idpNames.iterator();
                        while (!match && i3.hasNext()) {
                            GeneralNameInterface idpName = ((GeneralName)i3.next()).getName();
                            match = crlIssuerName.equals(idpName);
                        }
                    }
                    if (!match) {
                        return false;
                    }
                }
            }
            if ((b = (Boolean)idpExt.get("user_certs_only")).equals(Boolean.TRUE) && certImpl.getBasicConstraints() != -1) {
                if (debug != null) {
                    debug.println("cert must be a EE cert");
                }
                return false;
            }
            b = (Boolean)idpExt.get("ca_certs_only");
            if (b.equals(Boolean.TRUE) && certImpl.getBasicConstraints() == -1) {
                if (debug != null) {
                    debug.println("cert must be a CA cert");
                }
                return false;
            }
            b = (Boolean)idpExt.get("only_attribute_certs");
            if (b.equals(Boolean.TRUE)) {
                if (debug != null) {
                    debug.println("cert must not be an AA cert");
                }
                return false;
            }
        }
        boolean[] interimReasonsMask = new boolean[9];
        ReasonFlags reasons = null;
        if (idpExt != null) {
            reasons = (ReasonFlags)idpExt.get("limited_reasons");
        }
        boolean[] pointReasonFlags = point.getReasonFlags();
        if (reasons != null) {
            if (pointReasonFlags != null) {
                boolean[] idpReasonFlags = reasons.getFlags();
                for (i = 0; i < interimReasonsMask.length; ++i) {
                    interimReasonsMask[i] = i < idpReasonFlags.length && idpReasonFlags[i] && i < pointReasonFlags.length && pointReasonFlags[i];
                }
            } else {
                interimReasonsMask = (boolean[])reasons.getFlags().clone();
            }
        } else if (idpExt == null || reasons == null) {
            if (pointReasonFlags != null) {
                interimReasonsMask = (boolean[])pointReasonFlags.clone();
            } else {
                Arrays.fill(interimReasonsMask, true);
            }
        }
        boolean oneOrMore = false;
        for (i = 0; i < interimReasonsMask.length && !oneOrMore; ++i) {
            if (!interimReasonsMask[i] || i < reasonsMask.length && reasonsMask[i]) continue;
            oneOrMore = true;
        }
        if (!oneOrMore) {
            // empty if block
        }
        if (indirectCRL) {
            X509CertSelector certSel = new X509CertSelector();
            X500Principal crlIssuerX500Principal = new X500Principal(crlIssuer.getName());
            certSel.setSubject(crlIssuerX500Principal);
            boolean[] crlSign = new boolean[]{false, false, false, false, false, false, true};
            certSel.setKeyUsage(crlSign);
            AuthorityKeyIdentifierExtension akidext = crlImpl.getAuthKeyIdExtension();
            if (akidext != null) {
                SerialNumber asn;
                byte[] kid = akidext.getEncodedKeyIdentifier();
                if (kid != null) {
                    certSel.setSubjectKeyIdentifier(kid);
                }
                if ((asn = (SerialNumber)akidext.get("serial_number")) != null) {
                    certSel.setSerialNumber(asn.getNumber());
                }
            }
            HashSet<TrustAnchor> newTrustAnchors = new HashSet<TrustAnchor>(trustAnchors);
            if (prevKey != null) {
                TrustAnchor temporary;
                if (prevCert != null) {
                    temporary = new TrustAnchor(prevCert, null);
                } else {
                    X500Principal principal = certImpl.getIssuerX500Principal();
                    temporary = new TrustAnchor(principal, prevKey, null);
                }
                newTrustAnchors.add(temporary);
            }
            PKIXBuilderParameters params = null;
            try {
                params = new PKIXBuilderParameters(newTrustAnchors, (CertSelector)certSel);
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new CRLException(iape);
            }
            params.setCertStores(certStores);
            params.setSigProvider(provider);
            params.setDate(validity);
            try {
                CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "IBMCertPath");
                PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(params);
                prevKey = result.getPublicKey();
            }
            catch (GeneralSecurityException e) {
                throw new CRLException(e);
            }
        }
        try {
            AlgorithmChecker.check(prevKey, crl, variant);
        }
        catch (CertPathValidatorException cpve) {
            if (debug != null) {
                debug.println("CRL signature algorithm check failed: " + cpve);
            }
            return false;
        }
        try {
            crl.verify(prevKey, provider);
        }
        catch (GeneralSecurityException e) {
            if (debug != null) {
                debug.println("CRL signature failed to verify");
            }
            return false;
        }
        Set<String> unresCritExts = crl.getCriticalExtensionOIDs();
        if (unresCritExts != null) {
            unresCritExts.remove(PKIXExtensions.IssuingDistributionPoint_Id.toString());
            unresCritExts.remove(PKIXExtensions.DeltaCRLIndicator_Id.toString());
            if (!unresCritExts.isEmpty()) {
                if (debug != null) {
                    debug.println("Unrecognized critical extension(s) in CRL: " + unresCritExts);
                    for (String ext : unresCritExts) {
                        debug.println(ext);
                    }
                }
                return false;
            }
        }
        for (int i4 = 0; i4 < reasonsMask.length; ++i4) {
            reasonsMask[i4] = reasonsMask[i4] || i4 < interimReasonsMask.length && interimReasonsMask[i4];
        }
        return true;
    }

    private static GeneralNames getFullNames(X500Name issuer, RDN rdn) throws IOException {
        ArrayList<RDN> rdns = new ArrayList<RDN>(issuer.rdns());
        rdns.add(rdn);
        X500Name fullName = new X500Name(rdns.toArray(new RDN[0]));
        GeneralNames fullNames = new GeneralNames();
        fullNames.add(new GeneralName((GeneralNameInterface)fullName));
        return fullNames;
    }

    private static boolean issues(X509CertImpl cert, X509CRLImpl crl, String provider) throws IOException {
        boolean matched = false;
        AdaptableX509CertSelector issuerSelector = new AdaptableX509CertSelector();
        boolean[] usages = cert.getKeyUsage();
        if (usages != null) {
            usages[6] = true;
            issuerSelector.setKeyUsage(usages);
        }
        X500Principal crlIssuer = crl.getIssuerX500Principal();
        issuerSelector.setSubject(crlIssuer);
        AuthorityKeyIdentifierExtension crlAKID = crl.getAuthKeyIdExtension();
        issuerSelector.setSkiAndSerialNumber(crlAKID);
        matched = issuerSelector.match((Certificate)cert);
        if (matched && (crlAKID == null || cert.getAuthorityKeyIdentifierExtension() == null)) {
            try {
                crl.verify(cert.getPublicKey(), provider);
                matched = true;
            }
            catch (GeneralSecurityException e) {
                matched = false;
            }
        }
        return matched;
    }
}

