/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertId;
import com.ibm.security.cert.CertPathSystemProperties;
import com.ibm.security.cert.OCSPRequest;
import com.ibm.security.cert.OCSPResponse;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.AuthorityInfoAccessExtension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import sun.security.util.Debug;

public final class OCSP {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int CONNECT_TIMEOUT = OCSP.initializeTimeout();

    private static int initializeTimeout() {
        int tmp = CertPathSystemProperties.getOCSPConnectTimeout();
        if (debug != null) {
            System.out.println("OCSP.java:  initializeTimeout( ):  The OCSP CONNECT TIMEOUT value to be used (millisecs) will be:  " + tmp);
        }
        return tmp;
    }

    private OCSP() {
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert, URI responderURI, X509Certificate responderCert, Date date) throws IOException, CertPathValidatorException {
        return OCSP.check(cert, issuerCert, responderURI, responderCert, date, Collections.emptyList(), "generic");
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert, URI responderURI, X509Certificate responderCert, Date date, List<Extension> extensions, String variant) throws IOException, CertPathValidatorException {
        return OCSP.check(cert, responderURI, null, issuerCert, responderCert, date, extensions, variant);
    }

    public static RevocationStatus check(X509Certificate cert, URI responderURI, TrustAnchor anchor, X509Certificate issuerCert, X509Certificate responderCert, Date date, List<Extension> extensions, String variant) throws IOException, CertPathValidatorException {
        CertId certId;
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl((X509Certificate)cert);
            certId = new CertId(issuerCert, certImpl.getSerialNumberObject());
        }
        catch (IOException | CertificateException e) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", e);
        }
        OCSPResponse ocspResponse = OCSP.check(Collections.singletonList(certId), responderURI, new OCSPResponse.IssuerInfo(anchor, issuerCert), responderCert, date, extensions, variant);
        return ocspResponse.getSingleResponse(certId);
    }

    static OCSPResponse check(List<CertId> certIds, URI responderURI, OCSPResponse.IssuerInfo issuerInfo, X509Certificate responderCert, Date date, List<Extension> extensions, String variant) throws IOException, CertPathValidatorException {
        byte[] nonce = null;
        for (Extension ext : extensions) {
            if (!ext.getId().equals(PKIXExtensions.OCSPNonce_Id.toString())) continue;
            nonce = ext.getValue();
        }
        OCSPResponse ocspResponse = null;
        try {
            byte[] response = OCSP.getOCSPBytes(certIds, responderURI, extensions);
            ocspResponse = new OCSPResponse(response);
            ocspResponse.verify(certIds, issuerInfo, responderCert, date, nonce, variant);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Unable to determine revocation status due to network error", ioe, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        return ocspResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getOCSPBytes(List<CertId> certIds, URI responderURI, List<Extension> extensions) throws IOException {
        OCSPRequest request = new OCSPRequest(certIds, extensions);
        byte[] bytes = request.encodeBytes();
        InputStream in = null;
        OutputStream out = null;
        byte[] response = null;
        try {
            int count;
            URL url = responderURI.toURL();
            if (debug != null) {
                debug.println("connecting to OCSP service at: " + url);
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(CONNECT_TIMEOUT);
            con.setReadTimeout(CONNECT_TIMEOUT);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            con.setRequestProperty("Content-length", String.valueOf(bytes.length));
            out = con.getOutputStream();
            out.write(bytes);
            out.flush();
            if (debug != null && con.getResponseCode() != 200) {
                debug.println("Received HTTP error: " + con.getResponseCode() + " - " + con.getResponseMessage());
            }
            in = con.getInputStream();
            int contentLength = con.getContentLength();
            if (contentLength == -1) {
                contentLength = Integer.MAX_VALUE;
            }
            response = new byte[contentLength > 2048 ? 2048 : contentLength];
            int total = 0;
            while (total < contentLength && (count = in.read(response, total, response.length - total)) >= 0) {
                if ((total += count) < response.length || total >= contentLength) continue;
                response = Arrays.copyOf(response, total * 2);
            }
            response = Arrays.copyOf(response, total);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return response;
    }

    public static URI getResponderURI(X509Certificate cert) {
        try {
            return OCSP.getResponderURI(X509CertImpl.toImpl((X509Certificate)cert));
        }
        catch (CertificateException ce) {
            return null;
        }
    }

    static URI getResponderURI(X509CertImpl certImpl) {
        AuthorityInfoAccessExtension aia = certImpl.getAuthorityInfoAccessExtension();
        if (aia == null) {
            return null;
        }
        Vector descriptions = aia.getAccessDescriptions();
        for (AccessDescription description : descriptions) {
            GeneralName generalName;
            if (!description.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = description.getAccessLocation()).getType() != 6) continue;
            URIName uri = (URIName)generalName.getName();
            return uri.getURI();
        }
        return null;
    }

    public static interface RevocationStatus {
        public CertStatus getCertStatus();

        public Date getRevocationTime();

        public CRLReason getRevocationReason();

        public Map<String, Extension> getSingleExtensions();

        public static enum CertStatus {
            GOOD,
            REVOKED,
            UNKNOWN;

        }
    }
}

