/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.BasicChecker;
import com.ibm.security.cert.Builder;
import com.ibm.security.cert.CertId;
import com.ibm.security.cert.CertPathHelper;
import com.ibm.security.cert.CertPathSystemProperties;
import com.ibm.security.cert.DistributionPointFetcher;
import com.ibm.security.cert.OCSP;
import com.ibm.security.cert.OCSPResponse;
import com.ibm.security.cert.PKIX;
import com.ibm.security.cert.URICertStore;
import com.ibm.security.util.Debug;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.AuthorityInfoAccessExtension;
import com.ibm.security.x509.CRLDistributionPointsExtension;
import com.ibm.security.x509.CRLNumberExtension;
import com.ibm.security.x509.DeltaCRLIndicatorExtension;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.ReasonFlags;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLEntryImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.Extension;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

class RevocationChecker
extends PKIXRevocationChecker {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private TrustAnchor anchor;
    private PKIX.ValidatorParams params;
    private boolean onlyEE;
    private boolean softFail;
    private boolean crlDP;
    private URI responderURI;
    private X509Certificate responderCert;
    private List<CertStore> certStores;
    private Map<X509Certificate, byte[]> ocspResponses;
    private List<Extension> ocspExtensions;
    private final boolean legacy;
    private LinkedList<CertPathValidatorException> softFailExceptions = new LinkedList();
    private OCSPResponse.IssuerInfo issuerInfo;
    private PublicKey prevPubKey;
    private boolean crlSignFlag;
    private int certIndex;
    private Mode mode = Mode.PREFER_OCSP;
    private static final long MAX_CLOCK_SKEW = 900000L;
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static final boolean[] CRL_SIGN_USAGE = new boolean[]{false, false, false, false, false, false, true};

    RevocationChecker() {
        this.legacy = false;
    }

    RevocationChecker(TrustAnchor anchor, PKIX.ValidatorParams params) throws CertPathValidatorException {
        this.legacy = true;
        this.init(anchor, params);
    }

    void init(TrustAnchor anchor, PKIX.ValidatorParams params) throws CertPathValidatorException {
        block13: {
            if (debug != null) {
                System.out.println("RevocationChecker.java:  init( ):  com.ibm.security.onlyCheckRevocationOfEECert = " + CertPathSystemProperties.getOnlyEECert());
                System.out.println("RevocationChecker.java:  init( ):  com.ibm.security.enableDELTACRL              = " + CertPathSystemProperties.getEnableDELTACRL());
                System.out.println("RevocationChecker.java:  init( ):  com.ibm.security.enableAIAEXT                = " + CertPathSystemProperties.getEnableAIAEXT());
            }
            RevocationProperties rp = RevocationChecker.getRevocationProperties();
            URI uri = this.getOcspResponder();
            this.responderURI = uri == null ? RevocationChecker.toURI(rp.ocspUrl) : uri;
            X509Certificate cert = this.getOcspResponderCert();
            this.responderCert = cert == null ? RevocationChecker.getResponderCert(rp, params.trustAnchors(), params.certStores()) : cert;
            Set<PKIXRevocationChecker.Option> options = this.getOptions();
            block5: for (PKIXRevocationChecker.Option option : options) {
                switch (option) {
                    case ONLY_END_ENTITY: 
                    case PREFER_CRLS: 
                    case SOFT_FAIL: 
                    case NO_FALLBACK: {
                        continue block5;
                    }
                }
                throw new CertPathValidatorException("Unrecognized revocation parameter option: " + (Object)((Object)option));
            }
            this.softFail = options.contains((Object)PKIXRevocationChecker.Option.SOFT_FAIL);
            if (this.legacy) {
                this.mode = rp.ocspEnabled ? Mode.PREFER_OCSP : Mode.ONLY_CRLS;
                this.onlyEE = rp.onlyEE;
            } else {
                if (options.contains((Object)PKIXRevocationChecker.Option.NO_FALLBACK)) {
                    this.mode = options.contains((Object)PKIXRevocationChecker.Option.PREFER_CRLS) ? Mode.ONLY_CRLS : Mode.ONLY_OCSP;
                } else if (options.contains((Object)PKIXRevocationChecker.Option.PREFER_CRLS)) {
                    this.mode = Mode.PREFER_CRLS;
                }
                this.onlyEE = options.contains((Object)PKIXRevocationChecker.Option.ONLY_END_ENTITY);
            }
            this.crlDP = this.legacy ? rp.crlDPEnabled : true;
            if (debug != null) {
                System.out.println("RevocationChecker:  init():  crlDP = " + this.crlDP);
            }
            this.ocspResponses = this.getOcspResponses();
            this.ocspExtensions = this.getOcspExtensions();
            this.anchor = anchor;
            this.params = params;
            this.certStores = new ArrayList<CertStore>(params.certStores());
            try {
                this.certStores.add(CertStore.getInstance("Collection", new CollectionCertStoreParameters(params.certificates())));
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                if (debug == null) break block13;
                debug.println("RevocationChecker: error creating Collection CertStore: " + e);
            }
        }
    }

    private static URI toURI(String uriString) throws CertPathValidatorException {
        try {
            if (uriString != null) {
                return new URI(uriString);
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new CertPathValidatorException("cannot parse ocsp.responderURL property", e);
        }
    }

    private static RevocationProperties getRevocationProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<RevocationProperties>(){

            @Override
            public RevocationProperties run() {
                RevocationProperties rp = new RevocationProperties();
                rp.onlyEE = CertPathSystemProperties.getOnlyEECert();
                String ocspEnabled = Security.getProperty("ocsp.enable");
                boolean bl = rp.ocspEnabled = ocspEnabled != null && ocspEnabled.equalsIgnoreCase("true");
                if (rp.ocspEnabled) {
                    rp.ocspUrl = Security.getProperty("ocsp.responderURL");
                    rp.ocspSubject = Security.getProperty("ocsp.responderCertSubjectName");
                    rp.ocspIssuer = Security.getProperty("ocsp.responderCertIssuerName");
                    rp.ocspSerial = Security.getProperty("ocsp.responderCertSerialNumber");
                } else {
                    rp.ocspUrl = null;
                    rp.ocspSubject = null;
                    rp.ocspIssuer = null;
                    rp.ocspSerial = null;
                }
                rp.crlDPEnabled = CertPathSystemProperties.getEnableCRLDP();
                if (debug != null) {
                    System.out.println("RevocationChecker.java:  getRevocationProperties( ):  The revocation properties are:      ");
                    System.out.println("RevocationChecker.java:  getRevocationProperties( ):  rp.onlyEE       " + rp.onlyEE);
                    System.out.println("RevocationChecker.java:  getRevocationProperties( ):  rp.crlDPEnabled " + rp.crlDPEnabled);
                    System.out.println("RevocationChecker.java:  getRevocationProperties( ):  rp.ocspEnabled  " + rp.ocspEnabled);
                    System.out.println("RevocationChecker.java:  getRevocationProperties( ):  rp.ocspUrl      " + rp.ocspUrl);
                    System.out.println("RevocationChecker.java:  getRevocationProperties( ):  rp.ocspSubject  " + rp.ocspSubject);
                    System.out.println("RevocationChecker.java:  getRevocationProperties( ):  rp.ocspIssuer   " + rp.ocspIssuer);
                    System.out.println("RevocationChecker.java:  getRevocationProperties( ):  rp.ocspSerial   " + rp.ocspSerial);
                }
                return rp;
            }
        });
    }

    private static X509Certificate getResponderCert(RevocationProperties rp, Set<TrustAnchor> anchors, List<CertStore> stores) throws CertPathValidatorException {
        if (rp.ocspSubject != null) {
            return RevocationChecker.getResponderCert(rp.ocspSubject, anchors, stores);
        }
        if (rp.ocspIssuer != null && rp.ocspSerial != null) {
            return RevocationChecker.getResponderCert(rp.ocspIssuer, rp.ocspSerial, anchors, stores);
        }
        if (rp.ocspIssuer != null || rp.ocspSerial != null) {
            throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
        }
        return null;
    }

    private static X509Certificate getResponderCert(String subject, Set<TrustAnchor> anchors, List<CertStore> stores) throws CertPathValidatorException {
        X509CertSelector sel = new X509CertSelector();
        try {
            sel.setSubject(new X500Principal(subject));
        }
        catch (IllegalArgumentException e) {
            throw new CertPathValidatorException("cannot parse ocsp.responderCertSubjectName property", e);
        }
        return RevocationChecker.getResponderCert(sel, anchors, stores);
    }

    private static X509Certificate getResponderCert(String issuer, String serial, Set<TrustAnchor> anchors, List<CertStore> stores) throws CertPathValidatorException {
        X509CertSelector sel = new X509CertSelector();
        try {
            sel.setIssuer(new X500Principal(issuer));
        }
        catch (IllegalArgumentException e) {
            throw new CertPathValidatorException("cannot parse ocsp.responderCertIssuerName property", e);
        }
        try {
            sel.setSerialNumber(new BigInteger(RevocationChecker.stripOutSeparators(serial), 16));
        }
        catch (NumberFormatException e) {
            throw new CertPathValidatorException("cannot parse ocsp.responderCertSerialNumber property", e);
        }
        return RevocationChecker.getResponderCert(sel, anchors, stores);
    }

    private static X509Certificate getResponderCert(X509CertSelector sel, Set<TrustAnchor> anchors, List<CertStore> stores) throws CertPathValidatorException {
        for (TrustAnchor anchor : anchors) {
            X509Certificate cert = anchor.getTrustedCert();
            if (cert == null || !sel.match(cert)) continue;
            return cert;
        }
        for (CertStore store : stores) {
            try {
                Collection<? extends Certificate> certs = store.getCertificates(sel);
                if (certs.isEmpty()) continue;
                return (X509Certificate)certs.iterator().next();
            }
            catch (CertStoreException e) {
                if (debug == null) continue;
                debug.println("CertStore exception:" + e);
            }
        }
        throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        if (this.anchor != null) {
            this.issuerInfo = new OCSPResponse.IssuerInfo(this.anchor);
            this.prevPubKey = this.issuerInfo.getPublicKey();
        }
        this.crlSignFlag = true;
        this.certIndex = this.params != null && this.params.certPath() != null ? this.params.certPath().getCertificates().size() - 1 : -1;
        this.softFailExceptions.clear();
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public List<CertPathValidatorException> getSoftFailExceptions() {
        return Collections.unmodifiableList(this.softFailExceptions);
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        this.check((X509Certificate)cert, unresolvedCritExts, this.prevPubKey, this.crlSignFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void check(X509Certificate xcert, Collection<String> unresolvedCritExts, PublicKey pubKey, boolean crlSignFlag) throws CertPathValidatorException {
        if (debug != null) {
            debug.println("RevocationChecker.check: checking cert\n  SN: " + Debug.toHexString((BigInteger)xcert.getSerialNumber()) + "\n  Subject: " + xcert.getSubjectX500Principal() + "\n  Issuer: " + xcert.getIssuerX500Principal());
        }
        try {
            if (this.onlyEE && xcert.getBasicConstraints() != -1) {
                if (debug == null) return;
                debug.println("Skipping revocation check; cert is not an end entity cert");
                return;
            }
            switch (this.mode) {
                case PREFER_OCSP: 
                case ONLY_OCSP: {
                    this.checkOCSP(xcert, unresolvedCritExts);
                    return;
                }
                case PREFER_CRLS: 
                case ONLY_CRLS: {
                    this.checkCRLs(xcert, unresolvedCritExts, null, pubKey, crlSignFlag);
                    return;
                }
            }
            return;
        }
        catch (CertPathValidatorException e) {
            if (e.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                throw e;
            }
            boolean eSoftFail = this.isSoftFailException(e);
            if (eSoftFail) {
                if (this.mode == Mode.ONLY_OCSP) return;
                if (this.mode == Mode.ONLY_CRLS) {
                    return;
                }
            } else {
                if (this.mode == Mode.ONLY_OCSP) throw e;
                if (this.mode == Mode.ONLY_CRLS) {
                    throw e;
                }
            }
            CertPathValidatorException cause = e;
            if (debug != null) {
                debug.println("RevocationChecker.check() " + e.getMessage());
                debug.println("RevocationChecker.check() preparing to failover");
            }
            try {
                switch (this.mode) {
                    case PREFER_OCSP: {
                        this.checkCRLs(xcert, unresolvedCritExts, null, pubKey, crlSignFlag);
                        return;
                    }
                    case PREFER_CRLS: {
                        this.checkOCSP(xcert, unresolvedCritExts);
                        return;
                    }
                }
                return;
            }
            catch (CertPathValidatorException x) {
                if (debug != null) {
                    debug.println("RevocationChecker.check() failover failed");
                    debug.println("RevocationChecker.check() " + x.getMessage());
                }
                if (x.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                    throw x;
                }
                if (!this.isSoftFailException(x)) {
                    cause.addSuppressed(x);
                    throw cause;
                }
                if (eSoftFail) return;
                throw cause;
            }
        }
        finally {
            this.updateState(xcert);
        }
    }

    private boolean isSoftFailException(CertPathValidatorException e) {
        if (this.softFail && e.getReason() == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
            CertPathValidatorException e2 = new CertPathValidatorException(e.getMessage(), e.getCause(), this.params.certPath(), this.certIndex, e.getReason());
            this.softFailExceptions.addFirst(e2);
            return true;
        }
        return false;
    }

    private void updateState(X509Certificate cert) throws CertPathValidatorException {
        this.issuerInfo = new OCSPResponse.IssuerInfo(this.anchor, cert);
        PublicKey pubKey = cert.getPublicKey();
        if (PKIX.isDSAPublicKeyWithoutParams(pubKey)) {
            pubKey = BasicChecker.makeInheritedParamsKey(pubKey, this.prevPubKey);
        }
        this.prevPubKey = pubKey;
        this.crlSignFlag = RevocationChecker.certCanSignCrl(cert);
        if (this.certIndex > 0) {
            --this.certIndex;
        }
    }

    private void checkCRLs(X509Certificate cert, Collection<String> unresolvedCritExts, Set<X509Certificate> stackedCerts, PublicKey pubKey, boolean signFlag) throws CertPathValidatorException {
        this.checkCRLs(cert, pubKey, null, signFlag, true, stackedCerts, this.params.trustAnchors());
    }

    static boolean isCausedByNetworkIssue(String type, CertStoreException cse) {
        boolean result;
        Throwable t = cse.getCause();
        switch (type) {
            case "LDAP": {
                if (t != null) {
                    String cn = t.getClass().getName();
                    result = cn.equals("javax.naming.ServiceUnavailableException") || cn.equals("javax.naming.CommunicationException");
                    break;
                }
                result = false;
                break;
            }
            case "SSLServer": {
                result = t != null && t instanceof IOException;
                break;
            }
            case "URI": {
                result = t != null && t instanceof IOException;
                break;
            }
            default: {
                return false;
            }
        }
        return result;
    }

    private void checkCRLs(X509Certificate cert, PublicKey prevKey, X509Certificate prevCert, boolean signFlag, boolean allowSeparateKey, Set<X509Certificate> stackedCerts, Set<TrustAnchor> anchors) throws CertPathValidatorException {
        block39: {
            if (debug != null) {
                debug.println("RevocationChecker.checkCRLs() ---checking revocation status ...");
            }
            if (CertPathSystemProperties.getEnableNULLCRLDP()) {
                if (debug != null) {
                    System.out.println("RevocationChecker.java:  checkCRLS():  com.ibm.security.NULLCRLDP = true");
                }
                try {
                    if (((X509CertImpl)cert).getCRLDistributionPointsExtension() == null) {
                        return;
                    }
                    break block39;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        System.out.println("RevocationChecker.java:  checkCRLS():  An exception was thrown while trying to obtain CRL distribution points from the input cert.");
                        System.out.println("                                       The exception thrown was:");
                        ex.printStackTrace();
                    }
                    break block39;
                }
            }
            if (debug != null) {
                System.out.println("RevocationChecker.java:  checkCRLS():  com.ibm.security.NULLCRLDP = false");
            }
        }
        if (stackedCerts != null && stackedCerts.contains(cert)) {
            if (debug != null) {
                debug.println("RevocationChecker.checkCRLs() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        HashSet<X509CRL> possibleCRLs = new HashSet<X509CRL>();
        ArrayList<X509CRL> approvedCRLs = new ArrayList<X509CRL>();
        X509CRLSelector sel = new X509CRLSelector();
        sel.setCertificateChecking(cert);
        CertPathHelper.setDateAndTime(sel, this.params.date(), 900000L);
        CertPathValidatorException networkFailureException = null;
        for (CertStore store : this.certStores) {
            try {
                for (CRL cRL : store.getCRLs(sel)) {
                    possibleCRLs.add((X509CRL)cRL);
                }
            }
            catch (CertStoreException e) {
                if (debug != null) {
                    debug.println("RevocationChecker.checkCRLs() CertStoreException: " + e.getMessage());
                }
                if (networkFailureException != null || !RevocationChecker.isCausedByNetworkIssue(store.getType(), e)) continue;
                networkFailureException = new CertPathValidatorException("Unable to determine revocation status due to network error", e, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
            }
        }
        if (debug != null) {
            debug.println("RevocationChecker.checkCRLs() possibleCRLs.size() = " + possibleCRLs.size());
        }
        boolean[] reasonsMask = new boolean[9];
        if (!possibleCRLs.isEmpty()) {
            approvedCRLs.addAll(this.verifyPossibleCRLs(possibleCRLs, cert, prevKey, signFlag, reasonsMask, anchors));
        }
        if (debug != null) {
            debug.println("RevocationChecker.checkCRLs() approvedCRLs.size() = " + approvedCRLs.size());
        }
        if (!approvedCRLs.isEmpty() && Arrays.equals(reasonsMask, ALL_REASONS)) {
            this.checkApprovedCRLs(cert, approvedCRLs);
        } else {
            try {
                if (this.crlDP) {
                    if (debug != null) {
                        System.out.println("RevocationChecker.java:  checkCRLs():  DistibutionPointFetcher not skipped because crlDP boolean = true");
                        System.out.println("RevocationChecker.java:  checkCRLs():  Before calling DistributionPointFetcher to get additional CRLs, the approvedCRLs count was:  " + approvedCRLs.size());
                    }
                    approvedCRLs.addAll(DistributionPointFetcher.getCRLs(sel, signFlag, prevKey, prevCert, this.params.sigProvider(), this.certStores, reasonsMask, anchors, null, this.params.variant()));
                    if (debug != null) {
                        System.out.println("RevocationChecker.java:  checkCRLs():  After calling DistributionPointFetcher to get additional CRLs, the approvedCRLs count was:  " + approvedCRLs.size());
                    }
                } else if (debug != null) {
                    System.out.println("RevocationChecker.java:  checkCRLs():  DistibutionPointFetcher skipped because crlDP boolean = false");
                }
            }
            catch (CertStoreException e) {
                PKIX.CertStoreTypeException cste;
                if (e instanceof PKIX.CertStoreTypeException && RevocationChecker.isCausedByNetworkIssue((cste = (PKIX.CertStoreTypeException)e).getType(), e)) {
                    throw new CertPathValidatorException("Unable to determine revocation status due to network error", e, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
                }
                throw new CertPathValidatorException(e);
            }
            if (debug != null) {
                System.out.println("======================== BEGIN DUMP OF approvedCRLs HashSet =================================");
                if (approvedCRLs.isEmpty()) {
                    System.out.println("RevocationChecker.java:  checkCRLs():  The list of approvedCRLs is EMPTY");
                } else {
                    System.out.println("RevocationChecker.java:  checkCRLs():  The list of approvedCRLs is NOT EMPTY.  There are " + approvedCRLs.size() + "CRLs in the approvedCRLs List");
                }
                System.out.println("======================== END DUMP OF approvedCRLs HashSet =================================");
            }
            if (!approvedCRLs.isEmpty() && Arrays.equals(reasonsMask, ALL_REASONS)) {
                this.checkApprovedCRLs(cert, approvedCRLs);
            } else {
                if (allowSeparateKey) {
                    try {
                        if (debug != null) {
                            System.out.println("RevocationChecker.java:  checkCRLs():  Calling verifywithSeparateSigningKey()");
                        }
                        this.verifyWithSeparateSigningKey(cert, prevKey, signFlag, stackedCerts);
                        return;
                    }
                    catch (CertPathValidatorException cpve) {
                        if (networkFailureException != null) {
                            throw networkFailureException;
                        }
                        throw cpve;
                    }
                }
                if (networkFailureException != null) {
                    throw networkFailureException;
                }
                throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
            }
        }
    }

    private void checkApprovedCRLs(X509Certificate cert, ArrayList<X509CRL> approvedCRLs) throws CertPathValidatorException {
        if (debug != null) {
            BigInteger sn = cert.getSerialNumber();
            debug.println("RevocationChecker.checkApprovedCRLs() starting the final sweep...");
            debug.println("RevocationChecker.checkApprovedCRLs() cert SN: " + sn.toString());
        }
        this.sortApprovedCRLsByDescendingIssueDate(approvedCRLs);
        if (debug != null) {
            System.out.println("RevocationChecker.java:  checkApprovedCRLs():  The cert being revocation checked is:");
            System.out.println(cert.toString());
        }
        CRLReason reasonCode = CRLReason.UNSPECIFIED;
        X509CRLEntryImpl entry = null;
        for (X509CRL crl : approvedCRLs) {
            Set unresCritExts;
            X509CRLEntry e = crl.getRevokedCertificate(cert);
            if (e == null) continue;
            try {
                entry = X509CRLEntryImpl.toImpl((X509CRLEntry)e);
            }
            catch (CRLException ce) {
                throw new CertPathValidatorException(ce);
            }
            if (debug != null) {
                debug.println("RevocationChecker.checkApprovedCRLs() CRL entry: " + entry.toString());
            }
            if ((unresCritExts = entry.getCriticalExtensionOIDs()) != null && !unresCritExts.isEmpty()) {
                unresCritExts.remove(PKIXExtensions.ReasonCode_Id.toString());
                unresCritExts.remove(PKIXExtensions.CertificateIssuer_Id.toString());
                if (!unresCritExts.isEmpty()) {
                    throw new CertPathValidatorException("Unrecognized critical extension(s) in revoked CRL entry");
                }
            }
            if ((reasonCode = entry.getRevocationReason()) == null) {
                reasonCode = CRLReason.UNSPECIFIED;
            }
            if (reasonCode == CRLReason.REMOVE_FROM_CRL && RevocationChecker.isDeltaCRL(crl)) {
                return;
            }
            Date revocationDate = entry.getRevocationDate();
            if (!revocationDate.before(this.params.date())) continue;
            CertificateRevokedException t = new CertificateRevokedException(revocationDate, reasonCode, crl.getIssuerX500Principal(), entry.getExtensions());
            throw new CertPathValidatorException(((Throwable)t).getMessage(), t, null, -1, CertPathValidatorException.BasicReason.REVOKED);
        }
    }

    private void checkOCSP(X509Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        X509CertImpl currCert = null;
        try {
            currCert = X509CertImpl.toImpl((X509Certificate)cert);
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException(ce);
        }
        OCSPResponse response = null;
        CertId certId = null;
        try {
            certId = new CertId(this.issuerInfo.getName(), this.issuerInfo.getPublicKey(), currCert.getSerialNumberObject());
            byte[] responseBytes = this.ocspResponses.get(cert);
            if (responseBytes != null) {
                if (debug != null) {
                    debug.println("Found cached OCSP response");
                }
                response = new OCSPResponse(responseBytes);
                byte[] nonce = null;
                for (Extension ext : this.ocspExtensions) {
                    if (!ext.getId().equals("1.3.6.1.5.5.7.48.1.2")) continue;
                    nonce = ext.getValue();
                }
                response.verify(Collections.singletonList(certId), this.issuerInfo, this.responderCert, this.params.date(), nonce, this.params.variant());
            } else {
                URI responderURI;
                URI uRI = responderURI = this.responderURI != null ? this.responderURI : OCSP.getResponderURI(currCert);
                if (responderURI == null) {
                    throw new CertPathValidatorException("Certificate does not specify OCSP responder", null, null, -1);
                }
                response = OCSP.check(Collections.singletonList(certId), responderURI, this.issuerInfo, this.responderCert, null, this.ocspExtensions, this.params.variant());
            }
        }
        catch (IOException e) {
            throw new CertPathValidatorException("Unable to determine revocation status due to network error", e, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        OCSPResponse.SingleResponse rs = response.getSingleResponse(certId);
        OCSP.RevocationStatus.CertStatus certStatus = rs.getCertStatus();
        if (certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
            Date revocationTime = rs.getRevocationTime();
            if (revocationTime.before(this.params.date())) {
                CertificateRevokedException t = new CertificateRevokedException(revocationTime, rs.getRevocationReason(), response.getSignerCertificate().getSubjectX500Principal(), rs.getSingleExtensions());
                throw new CertPathValidatorException(((Throwable)t).getMessage(), t, null, -1, CertPathValidatorException.BasicReason.REVOKED);
            }
        } else if (certStatus == OCSP.RevocationStatus.CertStatus.UNKNOWN) {
            throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.params.certPath(), -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
    }

    private static String stripOutSeparators(String value) {
        char[] chars = value.toCharArray();
        StringBuilder hexNumber = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (HEX_DIGITS.indexOf(chars[i]) == -1) continue;
            hexNumber.append(chars[i]);
        }
        return hexNumber.toString();
    }

    static boolean certCanSignCrl(X509Certificate cert) {
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage != null) {
            return keyUsage[6];
        }
        return false;
    }

    private Collection<X509CRL> verifyPossibleCRLs(Set<X509CRL> crls, X509Certificate cert, PublicKey prevKey, boolean signFlag, boolean[] reasonsMask, Set<TrustAnchor> anchors) throws CertPathValidatorException {
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl((X509Certificate)cert);
            if (debug != null) {
                debug.println("RevocationChecker.verifyPossibleCRLs: Checking CRLDPs for " + certImpl.getSubjectX500Principal());
            }
            CRLDistributionPointsExtension ext = certImpl.getCRLDistributionPointsExtension();
            List<DistributionPoint> points = null;
            if (ext == null) {
                X500Name certIssuer = (X500Name)certImpl.getIssuerDN();
                GeneralName generalNameToBeAdded = new GeneralName((GeneralNameInterface)certIssuer);
                GeneralNames generalNamesObject = new GeneralNames();
                generalNamesObject.add(generalNameToBeAdded);
                DistributionPoint point = new DistributionPoint((DistributionPointName)generalNamesObject, (ReasonFlags)null, (GeneralNames)null);
                points = Collections.singletonList(point);
            } else {
                DistributionPoint[] pointsArray = ext.get("points");
                points = new ArrayList<DistributionPoint>();
                for (int ii = 0; ii < pointsArray.length; ++ii) {
                    if (pointsArray[ii] == null) continue;
                    points.add(pointsArray[ii]);
                }
            }
            if (debug != null) {
                System.out.println("RevocationChecker.java:  VerifyPossibleCRLs():  How many CRLs were passed in:  " + crls.size());
            }
            HashSet<X509CRL> results = new HashSet<X509CRL>();
            for (DistributionPoint point : points) {
                X509CRL deltaCRL = null;
                for (X509CRL crl : crls) {
                    if (!DistributionPointFetcher.verifyCRL(certImpl, point, crl, reasonsMask, signFlag, prevKey, null, this.params.sigProvider(), anchors, this.certStores, this.params.date(), this.params.variant())) continue;
                    deltaCRL = RevocationChecker.processVerifiedCRL(crl, deltaCRL, results);
                }
            }
            if (debug != null) {
                System.out.println("RevocationChecker.java:  VerifyPossibleCRLs():  How many CRLs were returned:  " + results.size());
            }
            return results;
        }
        catch (IOException | CRLException | CertificateException e) {
            if (debug != null) {
                debug.println("Exception while verifying CRL: " + e.getMessage());
                e.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    private void verifyWithSeparateSigningKey(X509Certificate cert, PublicKey prevKey, boolean signFlag, Set<X509Certificate> stackedCerts) throws CertPathValidatorException {
        String msg = "revocation status";
        if (debug != null) {
            debug.println("RevocationChecker.verifyWithSeparateSigningKey() ---checking " + msg + "...");
        }
        if (stackedCerts != null && stackedCerts.contains(cert)) {
            if (debug != null) {
                debug.println("RevocationChecker.verifyWithSeparateSigningKey() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        if (!signFlag) {
            this.buildToNewKey(cert, null, stackedCerts);
        } else {
            this.buildToNewKey(cert, prevKey, stackedCerts);
        }
    }

    private void buildToNewKey(X509Certificate currCert, PublicKey prevKey, Set<X509Certificate> stackedCerts) throws CertPathValidatorException {
        PKIXBuilderParameters builderParams;
        if (debug != null) {
            debug.println("RevocationChecker.buildToNewKey() starting work");
        }
        HashSet<PublicKey> badKeys = new HashSet<PublicKey>();
        if (prevKey != null) {
            badKeys.add(prevKey);
        }
        RejectKeySelector certSel = new RejectKeySelector(badKeys);
        certSel.setSubject(currCert.getIssuerX500Principal());
        certSel.setKeyUsage(CRL_SIGN_USAGE);
        Set<TrustAnchor> newAnchors = this.anchor == null ? this.params.trustAnchors() : Collections.singleton(this.anchor);
        try {
            builderParams = new PKIXBuilderParameters(newAnchors, (CertSelector)certSel);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException(iape);
        }
        builderParams.setInitialPolicies(this.params.initialPolicies());
        builderParams.setCertStores(this.certStores);
        builderParams.setExplicitPolicyRequired(this.params.explicitPolicyRequired());
        builderParams.setPolicyMappingInhibited(this.params.policyMappingInhibited());
        builderParams.setAnyPolicyInhibited(this.params.anyPolicyInhibited());
        builderParams.setDate(this.params.date());
        builderParams.setCertPathCheckers(this.params.certPathCheckers());
        builderParams.setSigProvider(this.params.sigProvider());
        builderParams.setRevocationEnabled(false);
        if (Builder.USE_AIA) {
            X509CertImpl currCertImpl;
            block42: {
                if (debug != null) {
                    System.out.println("RevocationChecker.java:  buildToNewKey():  Builder.USE_AIA == true ");
                }
                currCertImpl = null;
                try {
                    currCertImpl = X509CertImpl.toImpl((X509Certificate)currCert);
                }
                catch (CertificateException ce) {
                    if (debug == null) break block42;
                    debug.println("RevocationChecker.buildToNewKey: error decoding cert: " + ce);
                }
            }
            AuthorityInfoAccessExtension aiaExt = null;
            if (currCertImpl != null) {
                aiaExt = currCertImpl.getAuthorityInfoAccessExtension();
            }
            if (aiaExt != null) {
                Vector adList;
                if (debug != null) {
                    System.out.println("RevocationChecker.java:  buildToNewKey():  The aiaExt from the cert is NOT NULL");
                }
                if ((adList = aiaExt.getAccessDescriptions()) != null) {
                    if (debug != null) {
                        System.out.println("RevocationChecker.java:  buildToNewKey():  The AccessDescription list in the aiaExt is NOT NULL");
                    }
                    for (AccessDescription ad : adList) {
                        CertStore cs;
                        if (debug != null) {
                            System.out.println("RevocationChecker.java:  buildToNewKey():  Try to create a CertStore from this AccessDescription");
                            System.out.println(ad.toString());
                        }
                        if ((cs = URICertStore.getInstance(ad)) != null) {
                            if (debug != null) {
                                System.out.println("RevocationChecker.java:  buildToNewKey():  The CertStore created is NOT NULL");
                                System.out.println("RevocationChecker.java:  buildToNewKey():  The CertStore is a:  " + cs.getClass().getName());
                            }
                            if (debug != null) {
                                debug.println("adding AIAext CertStore");
                            }
                            builderParams.addCertStore(cs);
                            continue;
                        }
                        if (debug == null) continue;
                        System.out.println("RevocationChecker.java:  buildToNewKey():  The CertStore created is NULL");
                    }
                } else if (debug != null) {
                    System.out.println("RevocationChecker.java:  buildToNewKey():  The AccessDescription list in the aiaExt is NULL");
                }
            } else if (debug != null) {
                System.out.println("RevocationChecker.java:  buildToNewKey():  The aiaExt from the cert is NULL");
            }
        } else if (debug != null) {
            System.out.println("RevocationChecker.java:  buildToNewKey():  Builder.USE_AIA == false ");
        }
        CertPathBuilder builder = null;
        try {
            builder = CertPathBuilder.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CertPathValidatorException(nsae);
        }
        try {
            while (true) {
                if (debug != null) {
                    debug.println("RevocationChecker.buildToNewKey() about to try build ...");
                }
                PKIXCertPathBuilderResult cpbr = (PKIXCertPathBuilderResult)builder.build(builderParams);
                if (debug != null) {
                    debug.println("RevocationChecker.buildToNewKey() about to check revocation ...");
                }
                if (stackedCerts == null) {
                    stackedCerts = new HashSet<X509Certificate>();
                }
                stackedCerts.add(currCert);
                TrustAnchor ta = cpbr.getTrustAnchor();
                PublicKey prevKey2 = ta.getCAPublicKey();
                if (prevKey2 == null) {
                    prevKey2 = ta.getTrustedCert().getPublicKey();
                }
                boolean signFlag = true;
                List<? extends Certificate> cpList = cpbr.getCertPath().getCertificates();
                try {
                    for (int i = cpList.size() - 1; i >= 0; --i) {
                        X509Certificate cert = (X509Certificate)cpList.get(i);
                        if (debug != null) {
                            debug.println("RevocationChecker.buildToNewKey() index " + i + " checking " + cert);
                        }
                        this.checkCRLs(cert, prevKey2, null, signFlag, true, stackedCerts, newAnchors);
                        signFlag = RevocationChecker.certCanSignCrl(cert);
                        prevKey2 = cert.getPublicKey();
                    }
                }
                catch (CertPathValidatorException cpve) {
                    badKeys.add(cpbr.getPublicKey());
                    continue;
                }
                if (debug != null) {
                    debug.println("RevocationChecker.buildToNewKey() got key " + cpbr.getPublicKey());
                }
                PublicKey newKey = cpbr.getPublicKey();
                X509Certificate newCert = cpList.isEmpty() ? null : (X509Certificate)cpList.get(0);
                try {
                    this.checkCRLs(currCert, newKey, newCert, true, false, null, this.params.trustAnchors());
                    return;
                }
                catch (CertPathValidatorException cpve) {
                    if (cpve.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                        throw cpve;
                    }
                    badKeys.add(newKey);
                    continue;
                }
                break;
            }
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new CertPathValidatorException(iape);
        }
        catch (CertPathBuilderException cpbe) {
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
    }

    private void sortApprovedCRLsByDescendingIssueDate(ArrayList<X509CRL> approvedCRLs) {
        if (null == approvedCRLs) {
            return;
        }
        approvedCRLs.sort(new CRLIssueDateComparator());
    }

    private static boolean isDeltaCRL(X509CRL crl) {
        Set<String> criticalExtensions = crl.getCriticalExtensionOIDs();
        if (null == criticalExtensions) {
            return false;
        }
        return criticalExtensions.contains(PKIXExtensions.DeltaCRLIndicator_Id.toString());
    }

    private static boolean isMatchingBaseCRL(X509CRL crl, X509CRL deltaCRL) {
        if (crl.equals(deltaCRL)) {
            return false;
        }
        if (null == crl || null == deltaCRL) {
            return false;
        }
        BigInteger baseCRLNumberFromDeltaCRL = null;
        try {
            baseCRLNumberFromDeltaCRL = RevocationChecker.getBaseNumber(deltaCRL);
        }
        catch (CertPathValidatorException e) {
            return false;
        }
        BigInteger baseCRLNumber = null;
        try {
            baseCRLNumber = RevocationChecker.getCRLNumber(crl);
        }
        catch (CertPathValidatorException e) {
            return false;
        }
        return null == baseCRLNumberFromDeltaCRL || null == baseCRLNumber || baseCRLNumber.equals(baseCRLNumberFromDeltaCRL);
    }

    private static BigInteger getBaseNumber(X509CRL deltaCRL) throws CertPathValidatorException {
        BigInteger number = null;
        byte[] bytes = deltaCRL.getExtensionValue(PKIXExtensions.DeltaCRLIndicator_Id.toString());
        if (bytes != null) {
            try {
                com.ibm.security.x509.Extension ext = new com.ibm.security.x509.Extension(PKIXExtensions.DeltaCRLIndicator_Id, false, bytes);
                DeltaCRLIndicatorExtension obj = new DeltaCRLIndicatorExtension(new Boolean(ext.isCritical()), (Object)ext.getExtensionValue());
                number = (BigInteger)obj.get("value");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred when processing the DeltaCRLIndicator extension.", e);
            }
        }
        return number;
    }

    private static BigInteger getCRLNumber(X509CRL crl) throws CertPathValidatorException {
        BigInteger number = null;
        byte[] bytes = crl.getExtensionValue(OIDMap.getOID((String)"x509.info.extensions.CRLNumber").toString());
        if (bytes != null) {
            try {
                com.ibm.security.x509.Extension ext = new com.ibm.security.x509.Extension(PKIXExtensions.CRLNumber_Id, false, bytes);
                CRLNumberExtension obj = new CRLNumberExtension(new Boolean(ext.isCritical()), (Object)ext.getExtensionValue());
                number = obj.get("value");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred when processing the CRLNumber extension.", e);
            }
        }
        return number;
    }

    private static X509CRL processVerifiedCRL(X509CRL crl, X509CRL unmatchedDeltaCRL, Set<X509CRL> approvedCRLs) {
        if (RevocationChecker.isDeltaCRL(crl) && CertPathSystemProperties.getEnableDELTACRL()) {
            if (RevocationChecker.hasMatchingBaseBeenProcessedAlready(crl, approvedCRLs)) {
                approvedCRLs.add(crl);
                unmatchedDeltaCRL = null;
            } else {
                unmatchedDeltaCRL = crl;
            }
            if (RevocationChecker.isMatchingBaseCRL(crl, unmatchedDeltaCRL)) {
                approvedCRLs.add(unmatchedDeltaCRL);
                unmatchedDeltaCRL = null;
            }
        } else {
            if (RevocationChecker.isDeltaCRL(crl) && !CertPathSystemProperties.getEnableDELTACRL()) {
                return unmatchedDeltaCRL;
            }
            approvedCRLs.add(crl);
        }
        return unmatchedDeltaCRL;
    }

    private static boolean hasMatchingBaseBeenProcessedAlready(X509CRL deltaCRL, Set<X509CRL> approvedCRLs) {
        for (X509CRL crl : approvedCRLs) {
            if (!RevocationChecker.isMatchingBaseCRL(crl, deltaCRL)) continue;
            return true;
        }
        return false;
    }

    class CRLIssueDateComparator
    implements Comparator<X509CRL> {
        CRLIssueDateComparator() {
        }

        @Override
        public int compare(X509CRL x509crl1, X509CRL x509crl2) {
            if (null == x509crl1 && null == x509crl2) {
                return 0;
            }
            if (null == x509crl1 && null != x509crl2) {
                return 1;
            }
            if (null != x509crl1 && null == x509crl2) {
                return -1;
            }
            Date issueDate1 = x509crl1.getThisUpdate();
            Date issueDate2 = x509crl2.getThisUpdate();
            return issueDate2.compareTo(issueDate1);
        }
    }

    private static class RejectKeySelector
    extends X509CertSelector {
        private final Set<PublicKey> badKeySet;

        RejectKeySelector(Set<PublicKey> badPublicKeys) {
            this.badKeySet = badPublicKeys;
        }

        @Override
        public boolean match(Certificate cert) {
            if (!super.match(cert)) {
                return false;
            }
            if (this.badKeySet.contains(cert.getPublicKey())) {
                if (debug != null) {
                    debug.println("RejectKeySelector.match: bad key");
                }
                return false;
            }
            if (debug != null) {
                debug.println("RejectKeySelector.match: returning true");
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RejectKeySelector: [\n");
            sb.append(super.toString());
            sb.append(this.badKeySet);
            sb.append("]");
            return sb.toString();
        }
    }

    private static class RevocationProperties {
        boolean onlyEE;
        boolean ocspEnabled;
        boolean crlDPEnabled;
        String ocspUrl;
        String ocspSubject;
        String ocspIssuer;
        String ocspSerial;

        private RevocationProperties() {
        }
    }

    private static enum Mode {
        PREFER_OCSP,
        PREFER_CRLS,
        ONLY_CRLS,
        ONLY_OCSP;

    }
}

