/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import sun.security.util.Debug;

public class Vertex {
    private static final Debug debug = Debug.getInstance("certpath");
    private X509Certificate cert;
    private int index;
    private Throwable throwable;

    Vertex(X509Certificate cert) {
        this.cert = cert;
        this.index = -1;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int ndx) {
        this.index = ndx;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String toString() {
        return this.certToString() + this.throwableToString() + this.indexToString();
    }

    /*
     * WARNING - void declaration
     */
    public String certToString() {
        StringBuilder sb;
        block11: {
            boolean[] sUID;
            sb = new StringBuilder();
            X509CertImpl x509Cert = null;
            try {
                x509Cert = X509CertImpl.toImpl((X509Certificate)this.cert);
            }
            catch (CertificateException ce) {
                if (debug != null) {
                    debug.println("Vertex.certToString() unexpected exception");
                    ce.printStackTrace();
                }
                return sb.toString();
            }
            sb.append("Issuer:     ").append(x509Cert.getIssuerX500Principal()).append("\n");
            sb.append("Subject:    ").append(x509Cert.getSubjectX500Principal()).append("\n");
            sb.append("SerialNum:  ").append(x509Cert.getSerialNumber().toString(16)).append("\n");
            sb.append("Expires:    ").append(x509Cert.getNotAfter().toString()).append("\n");
            boolean[] iUID = x509Cert.getIssuerUniqueID();
            if (iUID != null) {
                sb.append("IssuerUID:  ");
                for (boolean bl : iUID) {
                    sb.append(bl ? 1 : 0);
                }
                sb.append("\n");
            }
            if ((sUID = x509Cert.getSubjectUniqueID()) != null) {
                void var7_15;
                sb.append("SubjectUID: ");
                boolean[] blArray = sUID;
                int n = blArray.length;
                boolean bl = false;
                while (var7_15 < n) {
                    boolean b = blArray[var7_15];
                    sb.append(b ? 1 : 0);
                    ++var7_15;
                }
                sb.append("\n");
            }
            try {
                AuthorityKeyIdentifierExtension aKeyID;
                SubjectKeyIdentifierExtension sKeyID = x509Cert.getSubjectKeyIdentifierExtension();
                if (sKeyID != null) {
                    KeyIdentifier keyID = sKeyID.get("key_id");
                    sb.append("SubjKeyID:  ").append(keyID.toString());
                }
                if ((aKeyID = x509Cert.getAuthorityKeyIdentifierExtension()) != null) {
                    KeyIdentifier keyIdentifier = (KeyIdentifier)aKeyID.get("key_id");
                    sb.append("AuthKeyID:  ").append(keyIdentifier.toString());
                }
            }
            catch (IOException e) {
                if (debug == null) break block11;
                debug.println("Vertex.certToString() unexpected exception");
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public String throwableToString() {
        StringBuilder sb = new StringBuilder("Exception:  ");
        if (this.throwable != null) {
            sb.append(this.throwable.toString());
        } else {
            sb.append("null");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String moreToString() {
        StringBuilder sb = new StringBuilder("Last cert?  ");
        sb.append(this.index == -1 ? "Yes" : "No");
        sb.append("\n");
        return sb.toString();
    }

    public String indexToString() {
        return "Index:      " + this.index + "\n";
    }
}

