/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.DataValueReader;
import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.IIOPOutputStream;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ObjectStreamField;
import com.ibm.rmi.io.ReflectField;
import com.ibm.rmi.io.Serializer;
import com.ibm.rmi.io.SunSerializableFactory;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;

public class ObjectSerializer
extends Serializer {
    static final String CLASS = ObjectSerializer.class.getName();
    static boolean isUsingUnsafe = Serializer.unsafe != null;
    private static final ObjectSerializer instance = new ObjectSerializer();

    protected ObjectSerializer() {
    }

    public static final ObjectSerializer getObjectSerializerInstance() {
        return instance;
    }

    @Override
    public Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINER, CLASS, "write");
        }
        IIOPOutputStream iIOPOutputStream = this.getIIOPOutputStream(encoderOutputStream);
        if (objectStreamClass.isExternalizable()) {
            if (Trc.enabled(2)) {
                Trc.begin(Trc.FINER, CLASS, "write:93");
            }
            iIOPOutputStream.writeExternalizable(object);
            return null;
        }
        ObjectStreamClass objectStreamClass2 = objectStreamClass;
        for (ObjectStreamClass objectStreamClass3 = objectStreamClass.getSuperclass(); objectStreamClass3 != null && objectStreamClass3.isSerializable(); objectStreamClass3 = objectStreamClass3.getSuperclass()) {
            iIOPOutputStream.addPendingSubClass(object, objectStreamClass2);
            objectStreamClass2 = objectStreamClass3;
        }
        if (objectStreamClass2 != objectStreamClass) {
            Serializer serializer = objectStreamClass2.getSerializer();
            if (serializer != null) {
                return serializer.write(encoderOutputStream, object, objectStreamClass2);
            }
            return iIOPOutputStream.outputObject(object, objectStreamClass2);
        }
        return this.writeFn(encoderOutputStream, object, objectStreamClass);
    }

    public Object writeFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        try {
            if (objectStreamClass.getPrimitiveIndexEnd() != -1) {
                ReflectField reflectField = null;
                ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFieldsNoCopy();
                int n = objectStreamClass.getPrimitiveIndexEnd() + 1;
                block12: for (int i = 0; i < n; ++i) {
                    ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                    reflectField = objectStreamField.getReflectField();
                    if (reflectField == null) {
                        throw new InvalidClassException(objectStreamField.getClazz().getName(), "Nonexistent field " + objectStreamField.getName());
                    }
                    switch (objectStreamField.getTypeCode()) {
                        case 'I': {
                            if (isUsingUnsafe) {
                                encoderOutputStream.write_longInVarint(unsafe.getInt(object, reflectField.getFieldOffset()));
                                continue block12;
                            }
                            encoderOutputStream.write_longInVarint(objectStreamFieldArray[i].getReflectField().getInt(object));
                            continue block12;
                        }
                        case 'B': {
                            if (isUsingUnsafe) {
                                encoderOutputStream.write_octet(unsafe.getByte(object, reflectField.getFieldOffset()));
                                continue block12;
                            }
                            encoderOutputStream.write_octet(objectStreamFieldArray[i].getReflectField().getByte(object));
                            continue block12;
                        }
                        case 'C': {
                            if (isUsingUnsafe) {
                                encoderOutputStream.write_wchar(unsafe.getChar(object, reflectField.getFieldOffset()));
                                continue block12;
                            }
                            encoderOutputStream.write_wchar(objectStreamFieldArray[i].getReflectField().getChar(object));
                            continue block12;
                        }
                        case 'S': {
                            if (isUsingUnsafe) {
                                encoderOutputStream.write_short(unsafe.getShort(object, reflectField.getFieldOffset()));
                                continue block12;
                            }
                            encoderOutputStream.write_short(objectStreamFieldArray[i].getReflectField().getShort(object));
                            continue block12;
                        }
                        case 'J': {
                            if (isUsingUnsafe) {
                                encoderOutputStream.write_longlongInVarint(unsafe.getLong(object, reflectField.getFieldOffset()));
                                continue block12;
                            }
                            encoderOutputStream.write_longlongInVarint(objectStreamFieldArray[i].getReflectField().getLong(object));
                            continue block12;
                        }
                        case 'Z': {
                            if (isUsingUnsafe) {
                                encoderOutputStream.write_boolean(unsafe.getBoolean(object, reflectField.getFieldOffset()));
                                continue block12;
                            }
                            encoderOutputStream.write_boolean(objectStreamFieldArray[i].getReflectField().getBoolean(object));
                            continue block12;
                        }
                        case 'F': {
                            if (isUsingUnsafe) {
                                encoderOutputStream.write_float(unsafe.getFloat(object, reflectField.getFieldOffset()));
                                continue block12;
                            }
                            encoderOutputStream.write_float(objectStreamFieldArray[i].getReflectField().getFloat(object));
                            continue block12;
                        }
                        case 'D': {
                            if (isUsingUnsafe) {
                                encoderOutputStream.write_double(unsafe.getDouble(object, reflectField.getFieldOffset()));
                                continue block12;
                            }
                            encoderOutputStream.write_double(objectStreamFieldArray[i].getReflectField().getDouble(object));
                        }
                    }
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            IOException iOException = new IOException(illegalAccessException.getMessage());
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
        int n = objectStreamClass.getReferenceIndexStart();
        if (objectStreamClass.getReferenceIndexStart() != -1) {
            return this.writeReferenceFields(encoderOutputStream, object, objectStreamClass, n);
        }
        return null;
    }

    public Object readFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        try {
            if (objectStreamClass.getPrimitiveIndexEnd() != -1) {
                ReflectField reflectField = null;
                ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFieldsNoCopy();
                int n = objectStreamClass.getPrimitiveIndexEnd() + 1;
                block12: for (int i = 0; i < n; ++i) {
                    ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                    reflectField = objectStreamField.getReflectField();
                    if (reflectField == null) {
                        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
                        iIOPInputStream.readPrimGetField(objectStreamField);
                        continue;
                    }
                    switch (objectStreamField.getTypeCode()) {
                        case 'I': {
                            if (isUsingUnsafe) {
                                unsafe.putInt(object, reflectField.getFieldOffset(), encoderInputStream.read_longInVarint());
                                continue block12;
                            }
                            objectStreamFieldArray[i].getReflectField().setInt(object, encoderInputStream.read_longInVarint());
                            continue block12;
                        }
                        case 'B': {
                            if (isUsingUnsafe) {
                                unsafe.putByte(object, reflectField.getFieldOffset(), encoderInputStream.read_octet());
                                continue block12;
                            }
                            objectStreamFieldArray[i].getReflectField().setByte(object, encoderInputStream.read_octet());
                            continue block12;
                        }
                        case 'C': {
                            if (isUsingUnsafe) {
                                unsafe.putChar(object, reflectField.getFieldOffset(), encoderInputStream.read_wchar());
                                continue block12;
                            }
                            objectStreamFieldArray[i].getReflectField().setChar(object, encoderInputStream.read_wchar());
                            continue block12;
                        }
                        case 'S': {
                            if (isUsingUnsafe) {
                                unsafe.putShort(object, reflectField.getFieldOffset(), encoderInputStream.read_short());
                                continue block12;
                            }
                            objectStreamFieldArray[i].getReflectField().setShort(object, encoderInputStream.read_short());
                            continue block12;
                        }
                        case 'J': {
                            if (isUsingUnsafe) {
                                unsafe.putLong(object, reflectField.getFieldOffset(), encoderInputStream.read_longlongInVarint());
                                continue block12;
                            }
                            objectStreamFieldArray[i].getReflectField().setLong(object, encoderInputStream.read_longlongInVarint());
                            continue block12;
                        }
                        case 'Z': {
                            if (isUsingUnsafe) {
                                unsafe.putBoolean(object, reflectField.getFieldOffset(), encoderInputStream.read_boolean());
                                continue block12;
                            }
                            objectStreamFieldArray[i].getReflectField().setBoolean(object, encoderInputStream.read_boolean());
                            continue block12;
                        }
                        case 'F': {
                            if (isUsingUnsafe) {
                                unsafe.putFloat(object, reflectField.getFieldOffset(), encoderInputStream.read_float());
                                continue block12;
                            }
                            objectStreamFieldArray[i].getReflectField().setFloat(object, encoderInputStream.read_float());
                            continue block12;
                        }
                        case 'D': {
                            if (isUsingUnsafe) {
                                unsafe.putDouble(object, reflectField.getFieldOffset(), encoderInputStream.read_double());
                                continue block12;
                            }
                            objectStreamFieldArray[i].getReflectField().setDouble(object, encoderInputStream.read_double());
                        }
                    }
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            IOException iOException = new IOException(illegalAccessException.getMessage());
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
        int n = objectStreamClass.getReferenceIndexStart();
        if (objectStreamClass.getReferenceIndexStart() != -1) {
            return this.readReferenceFields(encoderInputStream, object, objectStreamClass, n);
        }
        return object;
    }

    private Object readObjectUsingOSF(ObjectStreamField objectStreamField, EncoderInputStream encoderInputStream) throws IOException {
        try {
            IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
            ObjectStreamClass objectStreamClass = objectStreamField.getObjectStreamClass();
            Object object = this.readObject(encoderInputStream, objectStreamClass);
            if (object == DataValueReader.PENDING_READ) {
                boolean bl = encoderInputStream.getPrevIsChunked();
                int n = encoderInputStream.getValueIndirection();
                iIOPInputStream.addRecursionBreak();
                object = iIOPInputStream.simpleReadObjectLoop(object);
                object = iIOPInputStream.doPostReadProcessing(object, bl, n);
            }
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException(classNotFoundException.getMessage());
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
    }

    public Object writeFn(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        IIOPOutputStream iIOPOutputStream = this.getIIOPOutputStream(encoderOutputStream);
        if (objectStreamClass.isCustomMarshaled()) {
            boolean bl = objectStreamClass.hasWriteObjectMethod();
            if (bl) {
                iIOPOutputStream.setCurrentObjectAndClassDesc(object, objectStreamClass);
                iIOPOutputStream.outputObject(object, objectStreamClass);
                return null;
            }
            return this.writeFields(encoderOutputStream, object, objectStreamClass);
        }
        return this.writeFields(encoderOutputStream, object, objectStreamClass);
    }

    public Object writeReferenceFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass, int n) throws IOException {
        if (n == -1) {
            n = objectStreamClass.getReferenceIndexStart();
        }
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFieldsNoCopy();
        Object object2 = null;
        for (int i = n; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamClass objectStreamClass2;
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            ReflectField reflectField = objectStreamField.getReflectField();
            Object object3 = unsafe.getObject(object, reflectField.getFieldOffset());
            object2 = this.writeObject(encoderOutputStream, object3, objectStreamClass2 = objectStreamField.getObjectStreamClass());
            if (object2 != EncoderOutputStream.PENDING_WRITE) continue;
            boolean bl = encoderOutputStream.getPrevMustChunk();
            this.getIIOPOutputStream(encoderOutputStream).addPendingResumeFields(object, objectStreamClass, i, bl);
            object3 = encoderOutputStream.getCurrentObject();
            return object3;
        }
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
        if (objectStreamClass.isExternalizable()) {
            try {
                return iIOPInputStream.readExternalizable(encoderInputStream.getValueClass(), objectStreamClass, encoderInputStream.getRepositoryIDString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                IOException iOException = new IOException(classNotFoundException.getMessage());
                iOException.initCause(classNotFoundException);
                throw iOException;
            }
        }
        if (object == null) {
            object = SunSerializableFactory.INSTANCE.createSerializable(objectStreamClass.getType(), objectStreamClass);
            encoderInputStream.addToValueCache(object);
        }
        ObjectStreamClass objectStreamClass2 = objectStreamClass;
        for (ObjectStreamClass objectStreamClass3 = objectStreamClass.getSuperclass(); objectStreamClass3 != null && objectStreamClass3.isSerializable(); objectStreamClass3 = objectStreamClass3.getSuperclass()) {
            iIOPInputStream.addPendingSubClass(object, objectStreamClass2, null);
            objectStreamClass2 = objectStreamClass3;
        }
        if (objectStreamClass2 != objectStreamClass) {
            Serializer serializer = objectStreamClass2.getSerializer();
            if (serializer != null) {
                return serializer.read(encoderInputStream, object, objectStreamClass2);
            }
            try {
                return iIOPInputStream.inputObjectUsingClassDesc(object, objectStreamClass2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                IOException iOException = new IOException(classNotFoundException.getMessage());
                iOException.initCause(classNotFoundException);
                throw iOException;
            }
        }
        return this.readFn(encoderInputStream, object, objectStreamClass);
    }

    public Object readFn(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        try {
            IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
            iIOPInputStream.setCurrentObjectAndClassDesc(object, objectStreamClass);
            if (!objectStreamClass.isCustomMarshaled() && !objectStreamClass.hasReadObjectMethod()) {
                return this.readFields(encoderInputStream, object, objectStreamClass);
            }
            iIOPInputStream.inputObjectUsingClassDesc(object, objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException();
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
        return object;
    }

    public Object readReferenceFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass, int n) throws IOException {
        if (n == -1) {
            n = objectStreamClass.getReferenceIndexStart();
        }
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFieldsNoCopy();
        Object object2 = null;
        for (int i = n; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            ReflectField reflectField = objectStreamField.getReflectField();
            if (reflectField == null) {
                return this.readObjectUsingOSF(objectStreamField, encoderInputStream);
            }
            ObjectStreamClass objectStreamClass2 = objectStreamField.getObjectStreamClass();
            object2 = this.readObject(encoderInputStream, objectStreamClass2);
            if (object2 == DataValueReader.PENDING_READ) {
                boolean bl = encoderInputStream.getPrevIsChunked();
                int n2 = encoderInputStream.getValueIndirection();
                this.getIIOPInputStream(encoderInputStream).addPendingResumeFields(object, objectStreamClass, i, bl, n2);
                return object2;
            }
            unsafe.putObject(object, reflectField.getFieldOffset(), object2);
        }
        return object;
    }

    protected void writeToLoop(EncoderOutputStream encoderOutputStream, Object object) throws IOException {
        IIOPOutputStream iIOPOutputStream = this.getIIOPOutputStream(encoderOutputStream);
        Object object2 = encoderOutputStream.fast_write_abstract_interface((Serializable)object);
        if (object2 == EncoderOutputStream.PENDING_WRITE) {
            iIOPOutputStream.addRecursionBreak();
            boolean bl = encoderOutputStream.getPrevMustChunk();
            Serializable serializable = encoderOutputStream.getCurrentObject();
            iIOPOutputStream.simpleWriteObjectLoop(serializable);
            encoderOutputStream.postFastWriteVal(bl);
        }
    }

    protected Object readFromLoop(EncoderInputStream encoderInputStream) throws IOException {
        try {
            IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
            Object object = encoderInputStream.fast_read_abstract_interface();
            if (object == DataValueReader.PENDING_READ) {
                boolean bl = encoderInputStream.getPrevIsChunked();
                int n = encoderInputStream.getValueIndirection();
                iIOPInputStream.addRecursionBreak();
                object = iIOPInputStream.simpleReadObjectLoop(object);
                object = iIOPInputStream.doPostReadProcessing(object, bl, n);
            }
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException(classNotFoundException.getMessage());
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
    }

    public Object readFieldForMeta(EncoderInputStream encoderInputStream, ObjectStreamClass objectStreamClass) throws IOException {
        Object object = null;
        object = this.readObject(encoderInputStream, objectStreamClass);
        return object;
    }
}

