/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class UnresolvedAttribute
extends PKCSDerObject
implements DerEncoder,
Cloneable {
    private ObjectIdentifier attributeId;
    private byte[] attributeValue;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.UnresolvedAttribute";
    private volatile int cachedHashVal = 0;

    public UnresolvedAttribute() {
        if (debug != null) {
            debug.entry(16384L, className, "UnresolvedAttribute");
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UnresolvedAttribute", provider);
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UnresolvedAttribute", (Object)der);
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "UnresolvedAttribute", der, provider);
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(ObjectIdentifier id, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "UnresolvedAttribute", id, value);
        }
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "UnresolvedAttribute", "Non-standard Attribute value must be a byte array");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be a byte array");
        }
        DerValue der = new DerValue((byte[])value);
        if (der.getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "UnresolvedAttribute", "Non-standard Attribute value must be DER-encoding of a SET OF");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be DER-encoding of a SET OF");
        }
        this.attributeId = id;
        this.attributeValue = (byte[])value;
        if (debug != null) {
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(ObjectIdentifier id, Object value, String provider) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{id, value, provider};
            debug.entry(16384L, className, "UnresolvedAttribute");
        }
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "UnresolvedAttribute", "Non-standard Attribute value must be a byte array");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be a byte array");
        }
        DerValue der = new DerValue((byte[])value);
        if (der.getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "UnresolvedAttribute", "Non-standard Attribute value must be DER-encoding of a SET OF");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be DER-encoding of a SET OF");
        }
        this.attributeId = id;
        this.attributeValue = (byte[])value;
        if (debug != null) {
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "UnresolvedAttribute", filename, new Boolean(base64));
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "UnresolvedAttribute", parms);
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
                debug.exit(16384L, (Object)className, "clone_1", new UnresolvedAttribute(this.attributeId, this.attributeValue, ((PKCSDerObject)this).provider));
            }
            return new UnresolvedAttribute(this.attributeId, this.attributeValue, ((PKCSDerObject)this).provider);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (obj instanceof UnresolvedAttribute) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((UnresolvedAttribute)obj));
            }
            return this.equals((UnresolvedAttribute)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "encode");
        }
        this.derEncode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        if (this.attributeValue == null) {
            if (debug != null) {
                debug.text(16384L, className, "derEncode", "Attribute value is null");
            }
            throw new IOException("Attribute value is null");
        }
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout.putOID(this.attributeId);
        tmpout.write(this.attributeValue);
        tmpout2.write((byte)48, tmpout.toByteArray());
        out.write(tmpout2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", this.attributeId);
        }
        return this.attributeId;
    }

    public Object getValue() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
        }
        UnresolvedAttribute attr = new UnresolvedAttribute(this.attributeId, this.attributeValue, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue", attr.attributeValue);
        }
        return attr.attributeValue;
    }

    @Override
    public String toString() {
        HexDumpEncoder hd = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "Object Identifier: ";
        out = out + this.attributeId.toString();
        out = out + "\r\n";
        out = out + "Value:\r\n";
        out = out + hd.encodeBuffer(this.attributeValue);
        out = out + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PKCS Attribute encoding error");
            }
            throw new IOException("PKCS Attribute encoding error");
        }
        DerInputStream derIn = new DerInputStream(encoding.toByteArray());
        DerValue[] val = derIn.getSequence(2);
        if (derIn.available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Excess data parsing PKCS Attribute");
            }
            throw new IOException("Excess data parsing PKCS Attribute");
        }
        if (val.length != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PKCS Attribute doesn't have two components");
            }
            throw new IOException("PKCS Attribute doesn't have two components");
        }
        this.attributeId = val[0].getOID();
        if (val[1].getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Non-standard Attribute value must be DER-encoding of a SET OF");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be DER-encoding of a SET OF");
        }
        this.attributeValue = val[1].toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(UnresolvedAttribute other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", false);
        }
        return true;
    }
}

