/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Timestamp;
import java.security.cert.X509Certificate;
import java.util.Date;

public class ConstraintsParameters {
    private final String algorithm;
    private final AlgorithmParameters algParams;
    private final Key publicKey;
    private final X509Certificate cert;
    private final boolean trustedMatch;
    private final Date pkixDate;
    private final Timestamp jarTimestamp;
    private final String variant;

    public ConstraintsParameters(X509Certificate c, boolean match, Date pkixdate, Timestamp jarTime, String variant) {
        this.cert = c;
        this.trustedMatch = match;
        this.pkixDate = pkixdate;
        this.jarTimestamp = jarTime;
        this.variant = variant == null ? "generic" : variant;
        this.algorithm = null;
        this.algParams = null;
        this.publicKey = null;
    }

    public ConstraintsParameters(String algorithm, AlgorithmParameters params, Key key, String variant) {
        this.algorithm = algorithm;
        this.algParams = params;
        this.publicKey = key;
        this.cert = null;
        this.trustedMatch = false;
        this.pkixDate = null;
        this.jarTimestamp = null;
        this.variant = variant == null ? "generic" : variant;
    }

    public ConstraintsParameters(X509Certificate c) {
        this(c, false, null, null, "generic");
    }

    public ConstraintsParameters(Timestamp jarTime) {
        this(null, false, null, jarTime, "generic");
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmParameters getAlgParams() {
        return this.algParams;
    }

    public Key getPublicKey() {
        return this.publicKey;
    }

    public boolean isTrustedMatch() {
        return this.trustedMatch;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public Date getPKIXParamDate() {
        return this.pkixDate;
    }

    public Timestamp getJARTimestamp() {
        return this.jarTimestamp;
    }

    public String getVariant() {
        return this.variant;
    }
}

