/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNameInterface;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class IPAddressName
implements GeneralNameInterface {
    private byte[] address;
    private boolean isIPv4;
    private String name;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.IPAddressName";
    private static final int MASKSIZE = 16;
    private static final int IN6ADDRSZ = 16;
    private static final int INT16SZ = 2;
    private static final int INADDRSZ = 4;

    public IPAddressName(DerValue derValue) throws IOException {
        this(derValue.getOctetString());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IPAddressName", derValue);
            debug.exit(16384L, className, "IPAddressName");
        }
    }

    public IPAddressName(byte[] address) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IPAddressName", (Object)address);
        }
        if (address != null) {
            if (address.length == 4 || address.length == 8) {
                this.isIPv4 = true;
            } else if (address.length == 16 || address.length == 32) {
                this.isIPv4 = false;
            } else {
                throw new IOException("Invalid IPAddressName");
            }
            this.address = (byte[])address.clone();
        } else {
            this.address = address;
        }
        if (debug != null) {
            debug.exit(16384L, className, "IPAddressName");
        }
    }

    public IPAddressName(String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException("IPAddressName cannot be null");
        }
        if (name.charAt(name.length() - 1) == '/') {
            throw new IOException("Invalid IPAddress " + name);
        }
        if (name.indexOf(":") >= 0) {
            this.parseIPv6(name);
            this.isIPv4 = false;
        } else if (name.indexOf(".") >= 0) {
            this.isIPv4 = true;
            int slashNdx = name.indexOf(47);
            if (slashNdx == -1) {
                this.address = IPAddressName.ipv4_getByteArray(name);
                if (this.address == null) {
                    throw new IOException("Invalid IPAddress" + name);
                }
            } else {
                this.address = new byte[8];
                byte[] mask = IPAddressName.ipv4_getByteArray(name.substring(slashNdx + 1));
                byte[] host = IPAddressName.ipv4_getByteArray(name.substring(0, slashNdx));
                if (mask == null || host == null) {
                    throw new IOException("Invalid IPAddress" + name);
                }
                System.arraycopy(host, 0, this.address, 0, 4);
                System.arraycopy(mask, 0, this.address, 4, 4);
            }
        } else {
            throw new IOException("Invalid IPAddressName " + name);
        }
    }

    private void parseIPv6(String name) throws IOException {
        int slashNdx = name.indexOf(47);
        if (slashNdx >= 0) {
            this.address = new byte[32];
            byte[] base = IPAddressName.ipv6_getByteArray(name.substring(0, slashNdx));
            if (base == null) {
                throw new IOException("Invalid IPAddress" + name);
            }
            System.arraycopy(base, 0, this.address, 0, 16);
        } else {
            this.address = IPAddressName.ipv6_getByteArray(name);
            if (this.address == null) {
                throw new IOException("Invalid IPAddress" + name);
            }
        }
        if (slashNdx >= 0) {
            String prefixStr = name.substring(slashNdx + 1);
            int prefixLen = Integer.parseInt(prefixStr);
            if (prefixLen > 128) {
                throw new IOException("Prefix may not be longer than 128");
            }
            BitArray bitArray = new BitArray(128);
            for (int i = 0; i < prefixLen; ++i) {
                bitArray.set(i, true);
            }
            byte[] maskArray = bitArray.toByteArray();
            for (int i = 0; i < 16; ++i) {
                this.address[16 + i] = maskArray[i];
            }
        }
    }

    @Override
    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 7);
        }
        return 7;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.address != null) {
            out.putOctetString(this.address);
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        try {
            return "IPAddress: " + this.getName();
        }
        catch (IOException ioe) {
            HexDumpEncoder enc = new HexDumpEncoder();
            return "IPAddress: " + enc.encodeBuffer(this.address);
        }
    }

    public byte[] getBytes() {
        if (this.address != null) {
            return (byte[])this.address.clone();
        }
        return null;
    }

    public String getName() throws IOException {
        String s = "";
        if (this.address != null) {
            if (this.isIPv4) {
                s = s + (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF);
                if (this.address.length == 8) {
                    s = s + "/" + (this.address[4] & 0xFF) + "." + (this.address[5] & 0xFF) + "." + (this.address[6] & 0xFF) + "." + (this.address[7] & 0xFF);
                }
            } else {
                String sep = "";
                int len = this.address.length;
                for (int i = 0; i < 8; ++i) {
                    int comp = ((this.address[i * 2] & 0xFF) << 8) + (this.address[i * 2 + 1] & 0xFF);
                    String compStr = Integer.toHexString(comp);
                    if (compStr.length() > 4) {
                        compStr = compStr.substring(compStr.length() - 4, compStr.length());
                    }
                    sep = i == 7 ? (len == 16 ? "" : "/") : ":";
                    s = s + compStr + sep;
                }
                if (len == 32) {
                    int i;
                    byte[] maskBytes = new byte[16];
                    for (int i2 = 16; i2 < 32; ++i2) {
                        maskBytes[i2 - 16] = this.address[i2];
                    }
                    BitArray ba = new BitArray(128, maskBytes);
                    for (i = 0; i < 128 && ba.get(i); ++i) {
                    }
                    s = s + i;
                    while (i < 128) {
                        if (ba.get(i)) {
                            throw new IOException("Invalid IPv6 subdomain - set bit " + i + " not contiguous");
                        }
                        ++i;
                    }
                }
            }
        }
        return s;
    }

    static byte[] ipv6_getByteArray(String src) {
        byte[] srcb = null;
        try {
            srcb = src.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            if (debug != null) {
                debug.exception(16384L, className, "ipv6_getByteArray", ex);
            }
            srcb = src.getBytes();
        }
        byte[] dst = new byte[16];
        int colonp = -1;
        int i = 0;
        int j = 0;
        if (srcb[i] == 58 && srcb[++i] != 58) {
            return null;
        }
        boolean saw_xdigit = false;
        int val = 0;
        while (i < srcb.length) {
            byte ch;
            int chval;
            if ((chval = Character.digit((char)(ch = srcb[i++]), 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    return null;
                }
                saw_xdigit = true;
                continue;
            }
            if (ch == 58) {
                if (!saw_xdigit) {
                    if (colonp != -1) {
                        return null;
                    }
                    colonp = j;
                    continue;
                }
                if (i == srcb.length) {
                    return null;
                }
                if (j + 2 > 16) {
                    return null;
                }
                dst[j++] = (byte)(val >> 8 & 0xFF);
                dst[j++] = (byte)(val & 0xFF);
                saw_xdigit = false;
                val = 0;
                continue;
            }
            if (ch == 46 && j + 4 <= 16) {
                byte[] v4addr = IPAddressName.ipv4_getByteArray(src.substring(i));
                for (int k = 0; k < 4; ++k) {
                    dst[j++] = v4addr[k];
                }
                saw_xdigit = false;
                break;
            }
            return null;
        }
        if (saw_xdigit) {
            if (j + 2 > 16) {
                return null;
            }
            dst[j++] = (byte)(val >> 8 & 0xFF);
            dst[j++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            int n = j - colonp;
            if (j == 16) {
                return null;
            }
            for (i = 1; i <= n; ++i) {
                dst[16 - i] = dst[colonp + n - i];
                dst[colonp + n - i] = 0;
            }
            j = 16;
        }
        if (j != 16) {
            return null;
        }
        return dst;
    }

    static byte[] ipv4_getByteArray(String src) {
        byte[] dst = new byte[4];
        byte[] srcb = null;
        try {
            srcb = src.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            if (debug != null) {
                debug.exception(16384L, className, "ipv4_getByteArray", ex);
            }
            srcb = src.getBytes();
        }
        boolean saw_digit = false;
        int octets = 0;
        int i = 0;
        int cur = 0;
        while (i < srcb.length) {
            byte ch;
            if (Character.isDigit((char)(ch = srcb[i++]))) {
                dst[cur] = (byte)(dst[cur] * 10 + (Character.digit((char)ch, 10) & 0xFF));
                if (dst[cur] > 255) {
                    return null;
                }
                if (saw_digit) continue;
                if (++octets > 4) {
                    return null;
                }
                saw_digit = true;
                continue;
            }
            if (ch == 46 && saw_digit) {
                if (octets == 4) {
                    return null;
                }
                dst[++cur] = 0;
                saw_digit = false;
                continue;
            }
            return null;
        }
        if (octets < 4) {
            return null;
        }
        return dst;
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (this.address == null) {
            return 2;
        }
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 7) {
            constraintType = -1;
        } else if (((IPAddressName)inputName).equals(this)) {
            constraintType = 0;
        } else {
            byte[] otherAddress = ((IPAddressName)inputName).getBytes();
            if (otherAddress.length == 4 && this.address.length == 4) {
                constraintType = 3;
            } else if (otherAddress.length == 8 && this.address.length == 8 || otherAddress.length == 32 && this.address.length == 32) {
                boolean otherSubsetOfThis = true;
                boolean thisSubsetOfOther = true;
                boolean thisEmpty = false;
                boolean otherEmpty = false;
                int maskOffset = this.address.length / 2;
                for (int i = 0; i < maskOffset; ++i) {
                    if ((byte)(this.address[i] & this.address[i + maskOffset]) != this.address[i]) {
                        thisEmpty = true;
                    }
                    if ((byte)(otherAddress[i] & otherAddress[i + maskOffset]) != otherAddress[i]) {
                        otherEmpty = true;
                    }
                    if ((byte)(this.address[i + maskOffset] & otherAddress[i + maskOffset]) != this.address[i + maskOffset] || (byte)(this.address[i] & this.address[i + maskOffset]) != (byte)(otherAddress[i] & this.address[i + maskOffset])) {
                        otherSubsetOfThis = false;
                    }
                    if ((byte)(otherAddress[i + maskOffset] & this.address[i + maskOffset]) == otherAddress[i + maskOffset] && (byte)(otherAddress[i] & otherAddress[i + maskOffset]) == (byte)(this.address[i] & otherAddress[i + maskOffset])) continue;
                    thisSubsetOfOther = false;
                }
                constraintType = thisEmpty || otherEmpty ? (thisEmpty && otherEmpty ? 0 : (thisEmpty ? 2 : 1)) : (otherSubsetOfThis ? 1 : (thisSubsetOfOther ? 2 : 3));
            } else if (otherAddress.length == 8 || otherAddress.length == 32) {
                int i;
                int maskOffset = otherAddress.length / 2;
                for (i = 0; i < maskOffset && (this.address[i] & otherAddress[i + maskOffset]) == otherAddress[i]; ++i) {
                }
                constraintType = i == maskOffset ? 2 : 3;
            } else if (this.address.length == 8 || this.address.length == 32) {
                int i;
                int maskOffset = this.address.length / 2;
                for (i = 0; i < maskOffset && (otherAddress[i] & this.address[i + maskOffset]) == this.address[i]; ++i) {
                }
                constraintType = i == maskOffset ? 1 : 3;
            } else {
                constraintType = 3;
            }
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for IPAddressName");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IPAddressName)) {
            return false;
        }
        byte[] other = ((IPAddressName)obj).getBytes();
        if (other == null) {
            return this.address == null;
        }
        if (this.address == null) {
            return false;
        }
        if (other.length != this.address.length) {
            return false;
        }
        if (this.address.length == 8 || this.address.length == 32) {
            int i;
            int maskLen = this.address.length / 2;
            byte[] maskedThis = new byte[maskLen];
            byte[] maskedOther = new byte[maskLen];
            for (i = 0; i < maskLen; ++i) {
                maskedThis[i] = (byte)(this.address[i] & this.address[i + maskLen]);
                maskedOther[i] = (byte)(other[i] & other[i + maskLen]);
                if (maskedThis[i] == maskedOther[i]) continue;
                return false;
            }
            for (i = maskLen; i < this.address.length; ++i) {
                if (this.address[i] == other[i]) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(other, this.address);
    }

    public int hashCode() {
        int retval = 0;
        if (this.address != null) {
            for (int i = 0; i < this.address.length; ++i) {
                retval += this.address[i] * i;
            }
        }
        return retval;
    }
}

