/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.util.BitSet;
import sun.security.action.GetPropertyAction;

public class URLEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static final String hexStr = "0123456789ABCDEF";
    static String dfltEncName;

    private URLEncoder() {
    }

    @Deprecated
    public static String encode(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static String encode(String string, String string2) throws UnsupportedEncodingException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3 / 2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        ResettableBufferedOutputStreamWriter resettableBufferedOutputStreamWriter = new ResettableBufferedOutputStreamWriter(byteArrayOutputStream, string2);
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (dontNeedEncoding.get(n2)) {
                if (n2 == 32) {
                    n2 = 43;
                    bl = true;
                }
                stringBuffer.append((char)n2);
                bl2 = true;
                continue;
            }
            try {
                char c;
                if (bl2) {
                    resettableBufferedOutputStreamWriter.reset();
                    bl2 = false;
                }
                resettableBufferedOutputStreamWriter.write(n2);
                if (n2 >= 55296 && n2 <= 56319 && i + 1 < string.length() && (c = string.charAt(i + 1)) >= '\udc00' && c <= '\udfff') {
                    resettableBufferedOutputStreamWriter.write(c);
                    ++i;
                }
                resettableBufferedOutputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append('%');
                stringBuffer.append(hexStr.charAt(byArray[j] >> 4 & 0xF));
                stringBuffer.append(hexStr.charAt(byArray[j] & 0xF));
            }
            byteArrayOutputStream.reset();
            bl = true;
        }
        return bl ? stringBuffer.toString() : string;
    }

    static {
        int n;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dfltEncName = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
    }

    private static class ResettableBufferedOutputStreamWriter {
        private static final int DEFAULT_BUFFER_SIZE = 2;
        private OutputStream out;
        private CharsetEncoder encoder;
        private CharBuffer charbuf;
        private ByteBuffer bytebuf;

        public ResettableBufferedOutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
            Charset charset;
            this.out = outputStream;
            try {
                charset = Charset.forName(string);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw (UnsupportedEncodingException)new UnsupportedEncodingException().initCause(illegalCharsetNameException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw (UnsupportedEncodingException)new UnsupportedEncodingException().initCause(unsupportedCharsetException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (UnsupportedEncodingException)new UnsupportedEncodingException().initCause(illegalArgumentException);
            }
            this.encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.charbuf = CharBuffer.allocate(2);
            this.bytebuf = ByteBuffer.allocate(2 * (int)this.encoder.maxBytesPerChar());
        }

        private void flushBuffer() throws IOException {
            CoderResult coderResult;
            if (this.charbuf.position() == 0) {
                return;
            }
            this.charbuf.flip();
            this.bytebuf.clear();
            while (!(coderResult = this.encoder.encode(this.charbuf, this.bytebuf, true)).isUnderflow()) {
                if (coderResult.isOverflow()) {
                    int n = this.bytebuf.capacity() * 2;
                    ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                    this.bytebuf.flip();
                    byteBuffer.put(this.bytebuf);
                    this.bytebuf = byteBuffer;
                    continue;
                }
                coderResult.throwException();
            }
            this.bytebuf.flip();
            this.out.write(this.bytebuf.array(), 0, this.bytebuf.limit());
            this.charbuf.clear();
        }

        public void write(int n) throws IOException {
            if (!this.charbuf.hasRemaining()) {
                this.flushBuffer();
            }
            this.charbuf.put((char)n);
        }

        public void reset() throws IOException {
            this.flushBuffer();
            this.encoder.reset();
        }

        public void flush() throws IOException {
            this.flushBuffer();
            this.out.flush();
        }
    }
}

