/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionData;
import com.ibm.java.diagnostics.healthcenter.environment.data.EnvironmentDataImpl;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.DebugOptionChecker;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.DumpabilityChecker;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.Messages;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.OptionChecker;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.UnsupportedOptionChecker;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.UnwiseOptionChecker;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.data.JVMDataImpl;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;

public class AnalysingEnvironmentPostprocessor
extends PostProcessorBase
implements PostProcessor {
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";
    private static final String VERSION_STRING_DELIMETER_REGEX = "\\.";
    private static final String GOOD_CONFIGURATION = Messages.getString("AnalysingEnvironmentPostprocessor.0");
    private static final Logger TRACE = LogFactory.getTrace(AnalysingEnvironmentPostprocessor.class);
    private final String className = this.getClass().getName();
    public static final String RECOMMENDATION_LABEL = Messages.getString("AnalysingEnvironmentPostprocessor.2");
    private final DumpabilityChecker dumpabilityChecker = new DumpabilityChecker();
    private final UnsupportedOptionChecker unsupportedOptionChecker = new UnsupportedOptionChecker();
    private final OptionChecker debugOptionChecker = new DebugOptionChecker();
    private UnwiseOptionChecker unwiseOptionChecker = null;
    private String pathSeparator = ":";

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(this.className, "postprocess");
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (dataBuilder2 instanceof EnvironmentDataImpl) {
            this.addEnvironmentSummaryData((EnvironmentDataImpl)dataBuilder2, dataBuilder);
        }
        TRACE.exiting(this.className, "postprocess");
    }

    public void addEnvironmentSummaryData(EnvironmentDataImpl environmentDataImpl, DataBuilder dataBuilder) {
        environmentDataImpl.clearValue();
        StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl(RECOMMENDATION_LABEL);
        this.checkForBacklevelAgentVersion(structuredStringDataImpl, environmentDataImpl);
        DataBuilder dataBuilder2 = environmentDataImpl.getData(EnvironmentLabels.SYSTEM_PROPERTIES);
        if (dataBuilder2 instanceof TableData) {
            TableData tableData = (TableData)((Object)dataBuilder2);
            List<String> list = environmentDataImpl.getCommandLineOptions();
            if (list != null) {
                this.unsupportedOptionChecker.checkOptions(list, structuredStringDataImpl);
                this.debugOptionChecker.checkOptions(list, structuredStringDataImpl);
                this.getUnwiseOptionChecker(tableData).checkOptions(list, structuredStringDataImpl);
                this.dumpabilityChecker.checkOptions(environmentDataImpl, structuredStringDataImpl);
            }
            TableDataRow tableDataRow = tableData.get("java.fullversion");
            this.checkForNonProductionVersions(structuredStringDataImpl, tableDataRow, environmentDataImpl);
            this.checkUlimitAgainstReceivedData(structuredStringDataImpl, dataBuilder, environmentDataImpl, tableDataRow);
            environmentDataImpl.addData(structuredStringDataImpl);
            if (this.hasNoRecommendation(structuredStringDataImpl)) {
                structuredStringDataImpl.addGoodThing(GOOD_CONFIGURATION);
            }
            this.setHighLevelMessage(environmentDataImpl, structuredStringDataImpl);
        }
    }

    private void checkForNonProductionVersions(StructuredStringDataBuilder structuredStringDataBuilder, TableDataRow tableDataRow, DataBuilder dataBuilder) {
        if (this.isNonProductionVersion(tableDataRow, dataBuilder)) {
            structuredStringDataBuilder.addWarning(Messages.getString("AnalysingEnvironmentPostprocessor.not.recommended.for.production"));
        }
    }

    private void checkForBacklevelAgentVersion(StructuredStringDataBuilder structuredStringDataBuilder, EnvironmentDataImpl environmentDataImpl) {
        if (!"".equalsIgnoreCase(environmentDataImpl.getAgentVersion())) {
            String string = "3.0.6.20160923";
            if (this.isAgentVersionLessThanLatestPublishedAgent(environmentDataImpl.getAgentVersion(), string)) {
                structuredStringDataBuilder.addWarning(MessageFormat.format(Messages.getString("AnalysingEnvironmentPostprocessor.old.agent"), string));
            }
        }
    }

    private boolean isAgentVersionLessThanLatestPublishedAgent(String string, String string2) {
        if (string == null) {
            return true;
        }
        if (string2 == null) {
            return false;
        }
        String[] stringArray = string.split(VERSION_STRING_DELIMETER_REGEX);
        if (stringArray.length < 4) {
            return true;
        }
        String[] stringArray2 = string2.split(VERSION_STRING_DELIMETER_REGEX);
        if (stringArray2.length < 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int n;
            int n2;
            try {
                n2 = Integer.parseInt(stringArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
            try {
                n = Integer.parseInt(stringArray2[i]);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n > n2) {
                return true;
            }
            if (n >= n2) continue;
            return false;
        }
        return false;
    }

    private boolean isNonProductionVersion(TableDataRow tableDataRow, DataBuilder dataBuilder) {
        if (tableDataRow != null && tableDataRow.getRowData().length == 2) {
            String string = (String)tableDataRow.getRowData()[1];
            VMLevelChecker vMLevelChecker = new VMLevelChecker(string);
            JVMDataImpl jVMDataImpl = (JVMDataImpl)dataBuilder.findRootData();
            if (vMLevelChecker.getJavaVersion() == 5 && vMLevelChecker.isVMOlderThan(20090430) || vMLevelChecker.getJavaVersion() == 6 && vMLevelChecker.isVMOlderThan(20090330) || vMLevelChecker.isVMSoftRealtime() && vMLevelChecker.isVMOlderThan(20090901) || vMLevelChecker.isVMRealtime() && vMLevelChecker.isVMOlderThan(20100331) || jVMDataImpl.isSoftRealtimeVM() && vMLevelChecker.isVMOlderThan(20090901) || jVMDataImpl.isRealtimeVM() && vMLevelChecker.isVMOlderThan(20100331)) {
                return true;
            }
        }
        return false;
    }

    private void checkUlimitAgainstReceivedData(StructuredStringDataBuilder structuredStringDataBuilder, DataBuilder dataBuilder, EnvironmentDataImpl environmentDataImpl, TableDataRow tableDataRow) {
        if (this.isNonProductionVersion(tableDataRow, dataBuilder)) {
            StringDataImpl stringDataImpl;
            String string = null;
            DataBuilder dataBuilder2 = environmentDataImpl.getData(EnvironmentLabels.ULIMIT_FILE_LABEL);
            if (dataBuilder2 instanceof StringDataImpl && (string = (stringDataImpl = (StringDataImpl)dataBuilder2).getValue()) != null && string.length() > 0) {
                if (string.startsWith("unlimited")) {
                    return;
                }
                Long l = new Long(string);
                DataBuilder dataBuilder3 = dataBuilder.getTopLevelData(JVMLabels.CONNECTION);
                ConnectionData connectionData = null;
                if (dataBuilder3 instanceof ConnectionData) {
                    connectionData = (ConnectionData)((Object)dataBuilder3);
                    if (l - connectionData.getAmountOfDataReceived() < l / 10L) {
                        structuredStringDataBuilder.addProblem(MessageFormat.format(Messages.getString("AnalysingEnvironmentPostprocessor.exceed.ulimit"), string));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnwiseOptionChecker getUnwiseOptionChecker(TableData tableData) {
        AnalysingEnvironmentPostprocessor analysingEnvironmentPostprocessor = this;
        synchronized (analysingEnvironmentPostprocessor) {
            if (this.unwiseOptionChecker == null) {
                Object[] objectArray;
                TableDataRow tableDataRow;
                if (tableData != null && (tableDataRow = tableData.get("path.separator")) != null && (objectArray = tableDataRow.getRowData()).length == 2) {
                    String string = ((String)objectArray[1]).trim();
                    if (string.contentEquals(SEMICOLON) || string.contentEquals(COLON)) {
                        this.pathSeparator = string;
                    } else {
                        TRACE.warning(MessageFormat.format(Messages.getString("AnalysingEnvironmentPostprocessor.3"), string));
                    }
                }
                this.unwiseOptionChecker = new UnwiseOptionChecker(this.pathSeparator);
            }
            return this.unwiseOptionChecker;
        }
    }
}

