/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.j9;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.J9MMTraceParser;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.ThreadState;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;

public class J9MMJava5TraceParser
extends J9MMTraceParser {
    private static final String _1_6_0 = "1.6.0";
    private static final String _1_5_0 = "1.5.0";

    public static boolean canParseThisVersion(String string) {
        if (string == null) {
            return true;
        }
        return string.contains(_1_5_0) || string.contains(_1_6_0) && J9MMJava5TraceParser.getDate(string) < 20080401;
    }

    protected J9MMJava5TraceParser(DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) {
        super(dataBuilder, outputProperties, traceMetaData);
    }

    @Override
    protected void endConcurrentCollection(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
    }

    @Override
    protected void startConcurrentCollection(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        this.isSystemGC = false;
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        this.util.addNumberDataPoint(threadState, GCLabels.CARDS_CLEANED, d, (Long)objectArray[12]);
        this.util.addNumberDataPoint(threadState, GCLabels.CARDS_TRACED, d, (Long)objectArray[9]);
    }
}

