/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection;

import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.StatusManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.ZipEntrySourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipFileConnectionDataImpl
extends ConnectionDataImpl {
    private final ConnectionType connectionType;
    private final File file;
    public static final String ZIP_SUFFIX = ".zip";
    public static final String HEALTH_CENTER_EXPORT_SUFFIX = ".hcd";
    private static final Logger TRACE = LogFactory.getTrace(ZipFileConnectionDataImpl.class);

    public ZipFileConnectionDataImpl(File file) {
        super(file.getName());
        this.file = file;
        this.connectionType = file.getName().endsWith(HEALTH_CENTER_EXPORT_SUFFIX) ? ConnectionType.HEALTH_CENTER_RAW_EXPORT : (file.getName().endsWith(ZIP_SUFFIX) ? ConnectionType.ZIP_FILE : ConnectionType.FILE);
        if (file.exists()) {
            this.isConnectionAlive = true;
            this.setStatus(Status.HEALTHY);
        } else {
            this.setStatus(Status.PROBLEM);
            this.clearValue();
            this.addValue(MessageFormat.format(Messages.getString("FileConnectionDataImpl.file.does.not.exist"), file.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean spawnSources(Marshaller var1_1) {
        var2_2 = null;
        var3_3 = false;
        try {
            var2_2 = new ZipInputStream(new FileInputStream(this.file));
            var4_4 = var2_2.getNextEntry();
            if (var4_4 == null) {
                var5_8 = this.getConnectionType() == ConnectionType.ZIP_FILE ? Messages.getString("ZipFileConnectionDataImpl.not.valid.zip.file") : Messages.getString("ZipFileConnectionDataImpl.not.valid.healthcenter.file");
                var6_9 = MessageFormat.format(var5_8, new Object[]{this.file});
                this.addValue((String)var6_9);
            } else {
                while (var4_4 != null) {
                    while (var4_4 != null) {
                        var5_8 = var4_4.getName();
                        if (var5_8.startsWith("environment") || var5_8.startsWith("EnvironmentSource")) {
                            var6_9 = new ZipEntrySourceImpl((ZipEntry)var4_4, this.file, this);
                            var1_1.addSource((Source)var6_9);
                            var1_1.blockUntilParsingCompleted(0);
                            var3_3 = true;
                        }
                        var2_2.closeEntry();
                        var4_4 = var2_2.getNextEntry();
                    }
                    var2_2.close();
                    var2_2 = new ZipInputStream(new FileInputStream(this.file));
                    var4_4 = var2_2.getNextEntry();
                    while (var4_4 != null) {
                        var5_8 = var4_4.getName();
                        if (!(var5_8.startsWith("EnvironmentSource") || var5_8.startsWith("environment") || var5_8.contains("/") || var5_8.contains("\\"))) {
                            var6_9 = new ZipEntrySourceImpl((ZipEntry)var4_4, this.file, this);
                            var1_1.addSource((Source)var6_9);
                            var3_3 = true;
                        }
                        var2_2.closeEntry();
                        var4_4 = var2_2.getNextEntry();
                    }
                }
            }
            ** if (var2_2 == null) goto lbl-1000
        }
        catch (IOException var4_6) {
            try {
                var5_8 = Messages.getString("ZipFileConnectionDataImpl.ioexception");
                var6_10 = MessageFormat.format(var5_8, new Object[]{this.file, var4_6.toString()});
                this.addValue(var6_10);
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var7_11) {
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var8_12) {
                        var9_13 = Messages.getString("ZipFileConnectionDataImpl.ioexception");
                        var10_14 = MessageFormat.format(var9_13, new Object[]{this.file, var8_12.toString()});
                        ZipFileConnectionDataImpl.TRACE.warning(var10_14);
                    }
                }
                throw var7_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (IOException var4_7) {
                    var5_8 = Messages.getString("ZipFileConnectionDataImpl.ioexception");
                    var6_10 = MessageFormat.format(var5_8, new Object[]{this.file, var4_7.toString()});
                    ZipFileConnectionDataImpl.TRACE.warning(var6_10);
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                var2_2.close();
            }
            catch (IOException var4_5) {
                var5_8 = Messages.getString("ZipFileConnectionDataImpl.ioexception");
                var6_9 = MessageFormat.format(var5_8, new Object[]{this.file, var4_5.toString()});
                ZipFileConnectionDataImpl.TRACE.warning((String)var6_9);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        var4_4 = Messages.getString("SourceAddingJob.imported.from.file");
        var5_8 = MessageFormat.format((String)var4_4, new Object[]{this.file.getName()});
        StatusManager.setSources(var5_8);
        return var3_3;
    }

    @Override
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }
}

