/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.locking.data;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TableDataRowImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.locking.LockingLabels;
import com.ibm.java.diagnostics.healthcenter.locking.LockingTableData;
import com.ibm.java.diagnostics.healthcenter.locking.LockingTableRow;
import com.ibm.java.diagnostics.healthcenter.locking.data.LockingTableRowImpl;
import com.ibm.java.diagnostics.healthcenter.locking.data.Messages;
import com.ibm.java.diagnostics.healthcenter.locking.data.MonitorData;
import com.ibm.java.diagnostics.healthcenter.locking.data.MonitorMetrics;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Logger;

public class MonitorTableData
extends DataImpl
implements TableData,
LockingTableData {
    private static final MonitorData[] TEMPLATE_MONITORDATA_ARRAY = new MonitorData[0];
    private static final Logger TRACE = LogFactory.getTrace(MonitorTableData.class);
    private static final DataFactory dataFactory = DataFactory.getFactory();
    private static final String CLOCK_CYCLES_UNIT_LABEL = LockingLabels.CLOCK_CYCLES_UNIT_LABEL;
    private static final String NUMBER_UNIT_LABEL = LockingLabels.NUMBER_UNIT_LABEL;
    private static final String COUNT_LABEL = LockingLabels.COUNT_LABEL;
    private static final String TIME_LABEL = LockingLabels.TIME_LABEL;
    private static final YAxis COUNT_AXIS = dataFactory.createYAxis(COUNT_LABEL, NUMBER_UNIT_LABEL);
    public static final YAxis CYCLES_AXIS = dataFactory.createYAxis(TIME_LABEL, CLOCK_CYCLES_UNIT_LABEL);
    private final XDataAxis timeDataAxis;
    private final YDataAxis countAxis;
    private final YDataAxis cyclesAxis;

    public MonitorTableData(String string, OutputProperties outputProperties) {
        super(string);
        this.timeDataAxis = AxisUtil.prepareXAxis(outputProperties);
        this.countAxis = COUNT_AXIS.createDataAxis(outputProperties, NUMBER_UNIT_LABEL);
        this.cyclesAxis = CYCLES_AXIS.createDataAxis(outputProperties, CLOCK_CYCLES_UNIT_LABEL);
    }

    public XDataAxis getXAxis() {
        return this.timeDataAxis;
    }

    @Override
    public boolean contains(String string) {
        DataBuilder dataBuilder = this.getTopLevelData(string);
        return dataBuilder != null;
    }

    @Override
    public TableDataRow get(String string) {
        DataBuilder dataBuilder = this.getTopLevelData(string);
        if (dataBuilder == null) {
            return null;
        }
        if (dataBuilder instanceof MonitorData) {
            MonitorData monitorData = (MonitorData)dataBuilder;
            return new TableDataRowImpl(monitorData.toArray());
        }
        String string2 = Messages.getString("MonitorTableData.not.monitor.data");
        String string3 = MessageFormat.format(string2, string);
        TRACE.warning(string3);
        return null;
    }

    @Override
    public String[] getColumnTitles() {
        return MonitorData.getColumnTitles();
    }

    @Override
    public LockingTableRow[] getContents() {
        MonitorData[] monitorDataArray = this.getMonitors();
        LockingTableRow[] lockingTableRowArray = new LockingTableRow[monitorDataArray.length];
        int n = 0;
        for (MonitorData monitorData : monitorDataArray) {
            Object[] objectArray = monitorData.toArray();
            lockingTableRowArray[n] = new LockingTableRowImpl(objectArray);
            ++n;
        }
        return lockingTableRowArray;
    }

    @Override
    public LockingTableRow getRow(int n) {
        LockingTableRow[] lockingTableRowArray = this.getContents();
        return lockingTableRowArray[n];
    }

    @Override
    public int size() {
        int n = 0;
        DataBuilder[] dataBuilderArray = this.getChildren();
        if (dataBuilderArray != null) {
            n = dataBuilderArray.length;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public MonitorData[] getMonitors() {
        DataBuilder[] dataBuilderArray;
        ArrayList<MonitorData> arrayList = new ArrayList<MonitorData>();
        for (DataBuilder dataBuilder : dataBuilderArray = this.getChildren()) {
            if (!(dataBuilder instanceof MonitorData)) continue;
            MonitorData monitorData = (MonitorData)dataBuilder;
            arrayList.add(monitorData);
        }
        return arrayList.toArray(TEMPLATE_MONITORDATA_ARRAY);
    }

    public void addMonitorMetrics(MonitorMetrics monitorMetrics, int n, OutputProperties outputProperties) {
        if (monitorMetrics == null) {
            return;
        }
        String string = monitorMetrics.getName();
        DataBuilder dataBuilder = this.getTopLevelData(string);
        if (dataBuilder == null) {
            dataBuilder = new MonitorData(string, outputProperties, this.timeDataAxis, this.countAxis, this.cyclesAxis);
            this.addData(dataBuilder);
        }
        if (dataBuilder instanceof MonitorData) {
            MonitorData monitorData = (MonitorData)dataBuilder;
            monitorData.addMonitorMetrics(monitorMetrics, n);
        }
    }
}

